/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.oms;

import se.ericsson.cello.nia.NIAAddressInfo;
import se.ericsson.cello.nia.NIAListener;
import se.ericsson.cello.nia.NIAMgr;
import se.ericsson.cello.nia.NIAMgrFactory;
import se.ericsson.cello.oms.ORBRestartManager;
import se.ericsson.cello.support.debug.MessageLog;

public class NodeIpAddressSubscriber
implements NIAListener {
    private String ipv4Address;
    private String ipv6Address;
    private NIAMgr niaMgr = null;
    static boolean isStartingWithNoIpAddress = false;
    private static NodeIpAddressSubscriber instance = new NodeIpAddressSubscriber();
    private static final int TRACE_GROUP = 5;
    static /* synthetic */ Class class$se$ericsson$cello$oms$NodeIpAddressSubscriber;

    public static NodeIpAddressSubscriber getInstance() {
        return instance;
    }

    private void getInitialIpAddresses() {
        NIAAddressInfo[] nIAAddressInfoArray = this.niaMgr.getNodeIpAddress();
        if (nIAAddressInfoArray == null) {
            nIAAddressInfoArray = new NIAAddressInfo[]{new NIAAddressInfo(true, false, true, "127.0.0.1", "lo")};
            isStartingWithNoIpAddress = true;
        }
        this.resolveIpAddresses(nIAAddressInfoArray);
    }

    private void resolveIpAddresses(NIAAddressInfo[] nIAAddressInfoArray) {
        for (int i = 0; i < nIAAddressInfoArray.length; ++i) {
            if (nIAAddressInfoArray[i].isIPv4Address() && nIAAddressInfoArray[i].isValid()) {
                this.ipv4Address = nIAAddressInfoArray[i].getNodeAddress();
                MessageLog.info((Class)(class$se$ericsson$cello$oms$NodeIpAddressSubscriber == null ? NodeIpAddressSubscriber.class$("se.ericsson.cello.oms.NodeIpAddressSubscriber") : class$se$ericsson$cello$oms$NodeIpAddressSubscriber), (String)("Found IPV4: " + this.ipv4Address));
                continue;
            }
            if (nIAAddressInfoArray[i].isIPv4Address() || !nIAAddressInfoArray[i].isValid()) continue;
            this.ipv6Address = nIAAddressInfoArray[i].getNodeAddress();
            MessageLog.info((Class)(class$se$ericsson$cello$oms$NodeIpAddressSubscriber == null ? NodeIpAddressSubscriber.class$("se.ericsson.cello.oms.NodeIpAddressSubscriber") : class$se$ericsson$cello$oms$NodeIpAddressSubscriber), (String)("Found IPV6: " + this.ipv6Address));
        }
    }

    public void init() {
        this.niaMgr = NIAMgrFactory.createNIAMgr();
        this.niaMgr.registerSubscriber((NIAListener)this);
        this.getInitialIpAddresses();
    }

    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public String getIpv6Address() {
        return this.ipv6Address;
    }

    private void restartOrbIfIpAddressChanged(NIAAddressInfo[] nIAAddressInfoArray) {
        boolean bl = false;
        for (int i = 0; i < nIAAddressInfoArray.length; ++i) {
            MessageLog.trace((int)5, this.getClass(), (String)("Interface/isChanged/isValid: " + nIAAddressInfoArray[i].getnodeInterfaceName() + "/" + nIAAddressInfoArray[i].isChanged() + "/" + nIAAddressInfoArray[i].isValid()));
            if (nIAAddressInfoArray[i].isChanged() && nIAAddressInfoArray[i].isValid()) {
                bl = true;
            }
            if (!isStartingWithNoIpAddress) continue;
            bl = true;
            isStartingWithNoIpAddress = false;
        }
        if (bl) {
            MessageLog.info(this.getClass(), (String)"Node IP address has been changed, ORB will be restarted");
            ORBRestartManager.instance().restartORB();
        }
    }

    public void notifyIpAddressChanged(NIAAddressInfo[] nIAAddressInfoArray) {
        MessageLog.trace((int)5, this.getClass(), (String)"notifyIpAddressChanged");
        this.restartOrbIfIpAddressChanged(nIAAddressInfoArray);
        this.resolveIpAddresses(nIAAddressInfoArray);
    }

    public void notifyIpAddressChanged(String string, String string2) {
        NIAAddressInfo[] nIAAddressInfoArray = this.niaMgr.getNodeIpAddress();
        this.restartOrbIfIpAddressChanged(nIAAddressInfoArray);
        this.resolveIpAddresses(nIAAddressInfoArray);
    }

    private NodeIpAddressSubscriber() {
    }
}

