/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.event.signal;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.List;
import java.util.Vector;
import se.ericsson.cello.pms.event.SubscriptionContent;
import se.ericsson.cello.pms.event.signal.OmsPmsAddSubscriptionCfm;
import se.ericsson.cello.pms.event.signal.OmsPmsAddSubscriptionReq;
import se.ericsson.cello.pms.event.signal.OmsPmsDeleteSubscriptionCfm;
import se.ericsson.cello.pms.event.signal.OmsPmsDeleteSubscriptionReq;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;

public class PmDistributorProxy {
    private static String PMS_SERVICE_NAME = "CelloPms";
    private static PmDistributorProxy instance = new PmDistributorProxy();
    private List subscriptions = new Vector();
    private PmsObserver pmsObserver = null;

    public synchronized OmsPmsAddSubscriptionCfm sendAddSubscription(SubscriptionContent subscriptionContent) {
        if (!this.subscriptions.contains(subscriptionContent)) {
            this.subscriptions.add(subscriptionContent);
        }
        if (this.pmsObserver == null) {
            this.pmsObserver = new PmsObserver();
        }
        OmsPmsAddSubscriptionReq omsPmsAddSubscriptionReq = new OmsPmsAddSubscriptionReq(subscriptionContent.getScannerPid(), subscriptionContent.getResourceId(), subscriptionContent.getAttributes());
        OseProcess oseProcess = OseNameServer.lookup((String)PMS_SERVICE_NAME);
        if (oseProcess == null) {
            return null;
        }
        OmsPmsAddSubscriptionCfm omsPmsAddSubscriptionCfm = (OmsPmsAddSubscriptionCfm)SignalHelper.sendAndReceive((OseProcess)oseProcess, (Signal)omsPmsAddSubscriptionReq, (Class)OmsPmsAddSubscriptionCfm.class);
        return omsPmsAddSubscriptionCfm;
    }

    public synchronized OmsPmsDeleteSubscriptionCfm sendDeleteSubscription(SubscriptionContent subscriptionContent) {
        this.subscriptions.remove(subscriptionContent);
        if (this.subscriptions.size() == 0) {
            this.pmsObserver.destroy();
            this.pmsObserver = null;
        }
        OmsPmsDeleteSubscriptionReq omsPmsDeleteSubscriptionReq = new OmsPmsDeleteSubscriptionReq(subscriptionContent.getScannerPid(), subscriptionContent.getResourceId(), subscriptionContent.getAttributes());
        OseProcess oseProcess = OseNameServer.lookup((String)PMS_SERVICE_NAME);
        if (oseProcess == null) {
            return null;
        }
        OmsPmsDeleteSubscriptionCfm omsPmsDeleteSubscriptionCfm = (OmsPmsDeleteSubscriptionCfm)SignalHelper.sendAndReceive((OseProcess)oseProcess, (Signal)omsPmsDeleteSubscriptionReq, (Class)OmsPmsDeleteSubscriptionCfm.class);
        return omsPmsDeleteSubscriptionCfm;
    }

    public static PmDistributorProxy instance() {
        return instance;
    }

    private PmDistributorProxy() {
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        public void run() {
            MessageLog.trace((int)5, this.getClass(), (String)("Number of subscriptions to send to pms_lm: " + PmDistributorProxy.this.subscriptions.size()));
            for (int i = 0; i < PmDistributorProxy.this.subscriptions.size(); ++i) {
                SubscriptionContent subscriptionContent = (SubscriptionContent)PmDistributorProxy.this.subscriptions.get(i);
                PmDistributorProxy.this.sendAddSubscription(subscriptionContent);
            }
        }
    }

    private class PmsObserver
    implements SubscriptionObserver {
        PmsObserver() {
            OseNameServer.addSubscriptionObserver((String)PMS_SERVICE_NAME, (SubscriptionObserver)this);
        }

        void destroy() {
            OseNameServer.removeSubscriptionObserver((String)PMS_SERVICE_NAME, (SubscriptionObserver)this);
        }

        public void serviceAdded(String string) {
            MessageLog.trace((int)5, this.getClass(), (String)("serviceAdded (" + string + ")"));
            if (string.equals(PMS_SERVICE_NAME)) {
                Thread thread = new Thread((Runnable)new Worker(), "Oms_pms_observer");
                thread.start();
            }
        }

        public void serviceRemoved(String string) {
            MessageLog.trace((int)5, this.getClass(), (String)("serviceRemoved (" + string + ")"));
        }
    }
}

