/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.LoadControl;
import se.ericsson.cello.support.debug.MessageLog;

public class ObjectRepository {
    private static ObjectRepository uniqueInstance = new ObjectRepository();
    private Hashtable factoryTable = new Hashtable();
    private Hashtable counterTable = new Hashtable();
    private Hashtable counterTypes = new Hashtable();

    public static ObjectRepository instance() {
        return uniqueInstance;
    }

    public synchronized void registerObjects(String string, String[] stringArray, int[] nArray, BasicScannerFactory basicScannerFactory) throws MoTypeExistsException {
        if (this.factoryTable.containsKey(string)) {
            throw new MoTypeExistsException(string);
        }
        this.registerCounterTypes(string, stringArray, nArray, basicScannerFactory);
    }

    public synchronized void deregisterObjects(String string, BasicScannerFactory basicScannerFactory) {
        if (this.factoryTable.containsKey(string) && basicScannerFactory.equals(this.factoryTable.get(string))) {
            this.factoryTable.remove(string);
            if (this.counterTable.containsKey(string)) {
                this.counterTable.remove(string);
            }
        }
    }

    public synchronized void deregisterObjects(BasicScannerFactory basicScannerFactory) {
        if (this.factoryTable.containsValue(basicScannerFactory)) {
            Enumeration enumeration = this.factoryTable.keys();
            while (enumeration.hasMoreElements()) {
                BasicScannerFactory basicScannerFactory2 = (BasicScannerFactory)this.factoryTable.get((String)enumeration.nextElement());
                if (!basicScannerFactory.equals(basicScannerFactory2)) continue;
                this.factoryTable.remove((String)enumeration.nextElement());
                this.counterTable.remove((String)enumeration.nextElement());
            }
        }
    }

    public void setMaxActiveCounters(int n) {
        LoadControl.instance().setMaxCounterReads(n);
    }

    public int getMaxActiveCounters() {
        return LoadControl.instance().getMaxCounterReads();
    }

    boolean containsMoType(String string) {
        return this.factoryTable.containsKey(string);
    }

    BasicScannerFactory getFactory(String string) {
        return (BasicScannerFactory)this.factoryTable.get(string);
    }

    String[] checkAttributes(String string, String[] stringArray) {
        if (!this.counterTable.containsKey(string)) {
            return new String[0];
        }
        return this.addAttributes(string, stringArray, false);
    }

    String[] checkCounterTypes(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.counterTypes.containsKey(stringArray[i])) continue;
            vector.add(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    String[] getRegisteredAttributes(String string, String[] stringArray) {
        if (!this.counterTable.containsKey(string)) {
            return stringArray;
        }
        return this.addAttributes(string, stringArray, true);
    }

    private String[] addAttributes(String string, String[] stringArray, boolean bl) {
        Vector<String> vector = new Vector<String>();
        HashSet hashSet = (HashSet)this.counterTable.get(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl && hashSet.contains(stringArray[i])) {
                vector.add(stringArray[i]);
                continue;
            }
            if (bl || hashSet.contains(stringArray[i])) continue;
            vector.add(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    int convertToNoOfCounterElements(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.counterTypes.containsKey(stringArray[i])) {
                n += ((Integer)this.counterTypes.get(stringArray[i])).intValue();
                MessageLog.trace((int)8, this.getClass(), (String)("no of elements for attribute " + stringArray[i] + " = " + (Integer)this.counterTypes.get(stringArray[i])));
                continue;
            }
            ++n;
        }
        return n;
    }

    private ObjectRepository() {
    }

    synchronized void registerCounterTypes(String string, String[] stringArray, BasicScannerFactory basicScannerFactory) {
        HashSet<String> hashSet = (HashSet<String>)this.counterTable.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        this.factoryTable.put(string, basicScannerFactory);
        this.counterTable.put(string, hashSet);
    }

    synchronized void registerCounterTypes(String string, String[] stringArray, int[] nArray, BasicScannerFactory basicScannerFactory) {
        this.registerCounterTypes(string, stringArray, basicScannerFactory);
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[i] <= 1) continue;
            this.counterTypes.put(stringArray[i], new Integer(nArray[i]));
        }
    }

    public class MoTypeExistsException
    extends Exception {
        MoTypeExistsException(String string) {
            super(string);
        }
    }
}

