/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.ArrayList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pms.generic.CounterBasedScanner;
import se.ericsson.cello.pms.generic.MeasurementStatus;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.ObservedEntity;
import se.ericsson.cello.transaction.Coordinator;

class ObservedObject
extends ObservedEntity {
    private static final long serialVersionUID = 3207076451562579096L;
    private ObservationObject observationObject;
    private String moDn;
    private transient ManagedObject moRef;

    ObservedObject(ObservationObject observationObject, String string) {
        this.observationObject = observationObject;
        this.moDn = string;
    }

    public String[] getAttributes() {
        return this.observationObject.instance_attribute_list;
    }

    public void setAttributes(String[] stringArray) {
        this.observationObject.instance_attribute_list = stringArray;
    }

    public void clear() {
        this.createMeasuredData();
        this.moRef = MoRepository.instance().lookup(this.moDn);
    }

    public boolean measure(Coordinator coordinator, CounterBasedScanner counterBasedScanner) {
        if (this.getMeasuredData().isSampled(this.moDn)) {
            return true;
        }
        ArrayList arrayList = new ArrayList();
        MeasurementStatus measurementStatus = this.fetch(this.moRef, arrayList, coordinator, counterBasedScanner);
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        if (measurementStatus == MeasurementStatus.UNAVAILABLE) {
            return false;
        }
        this.getMeasuredData().addMeasuredValues(this.moDn, objectArray, measurementStatus != MeasurementStatus.OK);
        return true;
    }
}

