/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.productinventory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.omg.CORBA.NO_PERMISSION;
import se.ericsson.cello.ProductInventory.InventoryResponse;
import se.ericsson.cello.ProductInventory.Message;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.productinventory.XmlFormatter;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

abstract class Collector
implements Runnable {
    private int requestId;
    private InventoryResponse objRef;
    private Control ctrl;
    private int timeout;
    private String ipAddress;
    protected XmlFormatter xmlStorage;
    protected Coordinator context;
    private boolean trani = true;

    Collector(int n, InventoryResponse inventoryResponse, int n2) {
        this.requestId = n;
        this.objRef = inventoryResponse;
        this.timeout = n2;
        this.ipAddress = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Message message = new Message();
        try {
            this.ipAddress = InetAddress.getLocalHost().getHostAddress();
            this.initiate();
            this.collect();
            String string = this.xmlStorage.closeXmlFile();
            if (this.trani) {
                this.ctrl.getTerminator().rollback();
            }
            this.objRef.ready(this.requestId, this.ipAddress, string);
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            message.tag = "PI Error";
            message.variable = nO_PERMISSION.getMessage() + " " + nO_PERMISSION.toString();
            try {
                if (this.trani) {
                    this.ctrl.getTerminator().rollback();
                }
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                // empty catch block
            }
            try {
                this.xmlStorage.removeXmlFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MessageLog.traceError((Class)Collector.class, (String)"Callback couldn't be done due to security problems", (Throwable)nO_PERMISSION);
            this.objRef.operation_failed(this.requestId, this.ipAddress, message);
        }
        catch (UnknownHostException unknownHostException) {
            try {
                message.tag = "Unable to retrieve server IP address";
                message.variable = unknownHostException.getMessage();
                this.xmlStorage.removeXmlFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MessageLog.traceError((Class)Collector.class, (String)"Error during product inventory: ", (Throwable)unknownHostException);
            this.objRef.operation_failed(this.requestId, this.ipAddress, message);
        }
        catch (MoAccessException moAccessException) {
            message.tag = moAccessException.getReasonTag();
            message.variable = moAccessException.getVariablesAsString();
            try {
                if (this.trani) {
                    this.ctrl.getTerminator().rollback();
                }
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                // empty catch block
            }
            try {
                this.xmlStorage.removeXmlFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MessageLog.traceError((Class)Collector.class, (String)"Error during product inventory: ", (Throwable)moAccessException);
            this.objRef.operation_failed(this.requestId, this.ipAddress, message);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            message.tag = "Transaction";
            message.variable = inactiveTransactionException.getMessage();
            try {
                this.xmlStorage.removeXmlFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MessageLog.traceError((Class)Collector.class, (String)"Error during product inventory: ", (Throwable)inactiveTransactionException);
            this.objRef.operation_failed(this.requestId, this.ipAddress, message);
        }
        catch (Exception exception) {
            message.tag = "PI Error";
            message.variable = exception.getMessage() + " " + exception.toString();
            try {
                if (this.trani) {
                    this.ctrl.getTerminator().rollback();
                }
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                // empty catch block
            }
            try {
                this.xmlStorage.removeXmlFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MessageLog.traceError((Class)Collector.class, (String)"Error during product inventory: ", (Throwable)exception);
            this.objRef.operation_failed(this.requestId, this.ipAddress, message);
        }
        catch (Error error) {
            message.tag = "PI Error";
            message.variable = error.getMessage() + " " + error.toString();
            try {
                if (this.trani) {
                    this.ctrl.getTerminator().rollback();
                }
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                // empty catch block
            }
            try {
                this.xmlStorage.removeXmlFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
            this.objRef.operation_failed(this.requestId, this.ipAddress, message);
        }
        finally {
            this.objRef._release();
        }
    }

    private void initiate() throws IOException, TransactionRolledBackException {
        this.xmlStorage = new XmlFormatter(this.requestId);
        if (this.trani) {
            this.ctrl = TransactionServiceImpl.instance().getTransactionFactory().create(this.timeout);
            this.context = this.ctrl.getCoordinator();
            MessageLog.trace((int)5, this.getClass(), (String)("Cello_OMS txId = " + this.context.getTransactionID() + ", timeout = " + this.timeout));
        } else {
            this.context = null;
        }
    }

    abstract void collect() throws MoAccessException, IOException;
}

