/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.productinventory;

import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.BlockingQueue;

class RequestScheduler
implements Runnable {
    private Thread thread;
    private BlockingQueue queue;

    RequestScheduler(BlockingQueue blockingQueue) {
        this.queue = blockingQueue;
    }

    void start() {
        this.thread = new Thread((Runnable)this, "RequestScheduler");
        this.thread.start();
    }

    void stop() {
        this.thread.interrupt();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.thread.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    Object object = this.queue.dequeue();
                    if (object instanceof Runnable) {
                        ((Runnable)object).run();
                        continue;
                    }
                    MessageLog.traceError(this.getClass(), (String)("run,  dequeued a non-runnable object: " + object));
                }
            }
            catch (InterruptedException interruptedException) {
                MessageLog.traceError((Class)RequestScheduler.class, (String)"run: ", (Throwable)interruptedException);
                return;
            }
            catch (RuntimeException runtimeException) {
                MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)runtimeException);
                continue;
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
                continue;
            }
            break;
        }
    }
}

