/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.productinventory;

import java.io.IOException;
import java.util.Vector;
import se.ericsson.cello.ProductInventory.InventoryResponse;
import se.ericsson.cello.ProductInventory.ProductType;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.productinventory.BasedOnData;
import se.ericsson.cello.productinventory.Collector;
import se.ericsson.cello.productinventory.CustomerProductInfoData;
import se.ericsson.cello.productinventory.FirmwareProductData;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.LicenseCapacityData;
import se.ericsson.cello.productinventory.LicenseFeatureData;
import se.ericsson.cello.productinventory.LicenseProductData;
import se.ericsson.cello.productinventory.NodeProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.productinventory.SoftwareProductData;
import se.ericsson.cello.productinventory.SwltData;
import se.ericsson.cello.productinventory.UpSwData;
import se.ericsson.cello.productinventory.UpgradePackageProductData;
import se.ericsson.cello.support.debug.MessageLog;

class TypeCollector
extends Collector {
    private ProductType[] productTypes;
    private Vector nodeList;
    private Vector swList;
    private Vector hwList;
    private Vector fwList;
    private Vector cpiList;
    private Vector upList;
    private Vector licenseList;
    private static final String DEFAULT_DATE = "00000000";
    private static final String DEFAULT_DATE_TIME = "00000000000000";
    static /* synthetic */ Class class$se$ericsson$cello$productinventory$TypeCollector;

    TypeCollector(ProductType[] productTypeArray, int n, InventoryResponse inventoryResponse, int n2) {
        super(n, inventoryResponse, n2);
        this.productTypes = productTypeArray;
    }

    void collect() throws MoAccessException, IOException {
        this.sortProductList();
        this.collectLists();
        this.fetchAndStoreData();
    }

    private void sortProductList() {
        ProductType productType;
        int n;
        int n2;
        for (n2 = n = 0; n2 < this.productTypes.length; ++n2) {
            if (this.productTypes[n2] != ProductType.NODE) continue;
            productType = this.productTypes[n];
            this.productTypes[n] = this.productTypes[n2];
            this.productTypes[n2] = productType;
            ++n;
        }
        for (n2 = n; n2 < this.productTypes.length; ++n2) {
            if (this.productTypes[n2] != ProductType.LICENSE) continue;
            productType = this.productTypes[n];
            this.productTypes[n] = this.productTypes[n2];
            this.productTypes[n2] = productType;
            ++n;
        }
        for (n2 = n; n2 < this.productTypes.length; ++n2) {
            if (this.productTypes[n2] != ProductType.HW) continue;
            productType = this.productTypes[n];
            this.productTypes[n] = this.productTypes[n2];
            this.productTypes[n2] = productType;
            ++n;
        }
        for (n2 = n; n2 < this.productTypes.length; ++n2) {
            if (this.productTypes[n2] != ProductType.SW) continue;
            productType = this.productTypes[n];
            this.productTypes[n] = this.productTypes[n2];
            this.productTypes[n2] = productType;
            ++n;
        }
        for (n2 = n; n2 < this.productTypes.length; ++n2) {
            if (this.productTypes[n2] != ProductType.FW) continue;
            productType = this.productTypes[n];
            this.productTypes[n] = this.productTypes[n2];
            this.productTypes[n2] = productType;
            ++n;
        }
        for (n2 = n; n2 < this.productTypes.length; ++n2) {
            if (this.productTypes[n2] != ProductType.UP) continue;
            productType = this.productTypes[n];
            this.productTypes[n] = this.productTypes[n2];
            this.productTypes[n2] = productType;
            ++n;
        }
        for (n2 = n; n2 < this.productTypes.length; ++n2) {
            if (this.productTypes[n2] != ProductType.CPI) continue;
            productType = this.productTypes[n];
            this.productTypes[n] = this.productTypes[n2];
            this.productTypes[n2] = productType;
            ++n;
        }
    }

    private void collectLists() {
        ProductRepository productRepository = ProductRepository.instance();
        for (int i = 0; i < this.productTypes.length; ++i) {
            if (this.productTypes[i] == ProductType.NODE) {
                this.nodeList = productRepository.getAllRegisteredNode();
                continue;
            }
            if (this.productTypes[i] == ProductType.LICENSE) {
                this.licenseList = productRepository.getAllRegisteredLicense();
                continue;
            }
            if (this.productTypes[i] == ProductType.HW) {
                this.hwList = productRepository.getAllRegisteredHw();
                continue;
            }
            if (this.productTypes[i] == ProductType.SW) {
                this.swList = productRepository.getAllRegisteredSw();
                continue;
            }
            if (this.productTypes[i] == ProductType.FW) {
                this.fwList = productRepository.getAllRegisteredFw();
                continue;
            }
            if (this.productTypes[i] == ProductType.UP) {
                this.upList = productRepository.getAllRegisteredUp();
                continue;
            }
            if (this.productTypes[i] != ProductType.CPI) continue;
            this.cpiList = productRepository.getAllRegisteredCpi();
        }
    }

    private void fetchAndStoreData() throws MoAccessException, IOException {
        for (int i = 0; i < this.productTypes.length; ++i) {
            Object object;
            Object object2;
            String string;
            String string2;
            Object object3;
            if (this.productTypes[i] == ProductType.NODE) {
                for (int j = 0; j < this.nodeList.size(); ++j) {
                    NodeProductData nodeProductData = (NodeProductData)this.nodeList.elementAt(j);
                    object3 = nodeProductData.getSite(this.context);
                    string2 = nodeProductData.getLogicalName(this.context);
                    string = nodeProductData.getProductName(this.context);
                    object2 = nodeProductData.getProductNumber(this.context);
                    object = nodeProductData.getRState(this.context);
                    this.xmlStorage.storeNode((String)object3, string2, string, (String)object2, (String)object);
                }
                continue;
            }
            if (this.productTypes[i] == ProductType.LICENSE) {
                for (int j = 0; j < this.licenseList.size(); ++j) {
                    LicenseProductData licenseProductData = (LicenseProductData)this.licenseList.elementAt(j);
                    object3 = licenseProductData.getSwlt(this.context);
                    string2 = licenseProductData.getFingerprint(this.context);
                    string = licenseProductData.getInstallationSeqNumber(this.context);
                    object2 = licenseProductData.getInstallationTime(this.context);
                    object = licenseProductData.getLicenseFeatureList(this.context);
                    LicenseCapacityData[] licenseCapacityDataArray = licenseProductData.getLicenseCapacityList(this.context);
                    if (!this.isDateTimeOk((String)object2)) {
                        MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$TypeCollector == null ? TypeCollector.class$("se.ericsson.cello.productinventory.TypeCollector") : class$se$ericsson$cello$productinventory$TypeCollector), (String)("Invalid date format (" + (String)object2 + ") from License product: " + string2), null);
                        object2 = DEFAULT_DATE_TIME;
                    }
                    this.xmlStorage.storeLicense((SwltData)object3, string2, string, (String)object2, (LicenseFeatureData[])object, licenseCapacityDataArray);
                }
                continue;
            }
            if (this.productTypes[i] == ProductType.HW) {
                for (int j = 0; j < this.hwList.size(); ++j) {
                    HardwareProductData hardwareProductData = (HardwareProductData)this.hwList.elementAt(j);
                    object3 = hardwareProductData.getProductName(this.context);
                    string2 = hardwareProductData.getProductNumber(this.context);
                    string = hardwareProductData.getRState(this.context);
                    object2 = hardwareProductData.getProductionDate(this.context);
                    object = hardwareProductData.getSerialNumber(this.context);
                    String string3 = hardwareProductData.getSubrackId(this.context);
                    int n = hardwareProductData.getSlotPosition(this.context);
                    if (!this.isDateOk((String)object2)) {
                        MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$TypeCollector == null ? TypeCollector.class$("se.ericsson.cello.productinventory.TypeCollector") : class$se$ericsson$cello$productinventory$TypeCollector), (String)("Invalid date format (" + (String)object2 + ") from HW product: " + string2 + "/" + string + " slotPos" + n), null);
                        object2 = DEFAULT_DATE;
                    }
                    this.xmlStorage.storeHardware((String)object3, string2, string, (String)object2, (String)object, string3, n);
                }
                continue;
            }
            if (this.productTypes[i] == ProductType.SW) {
                for (int j = 0; j < this.swList.size(); ++j) {
                    SoftwareProductData softwareProductData = (SoftwareProductData)this.swList.elementAt(j);
                    object3 = softwareProductData.getProductName(this.context);
                    string2 = softwareProductData.getProductNumber(this.context);
                    string = softwareProductData.getRState(this.context);
                    object2 = softwareProductData.getProductionDate(this.context);
                    object = softwareProductData.getFilePath(this.context);
                    if (!this.isDateOk((String)object2)) {
                        MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$TypeCollector == null ? TypeCollector.class$("se.ericsson.cello.productinventory.TypeCollector") : class$se$ericsson$cello$productinventory$TypeCollector), (String)("Invalid date format (" + (String)object2 + ") from SW product: " + string2 + "/" + string), null);
                        object2 = DEFAULT_DATE;
                    }
                    this.xmlStorage.storeSoftware((String)object3, string2, string, (String)object2, (String)object);
                }
                ProductRepository productRepository = ProductRepository.instance();
                this.upList = productRepository.getAllRegisteredUp();
                for (int j = 0; j < this.upList.size(); ++j) {
                    object3 = (UpgradePackageProductData)this.upList.elementAt(j);
                    string2 = object3.getDocumentNumber(this.context);
                    string = object3.getDocumentRevision(this.context);
                    try {
                        object2 = object3.getUpSwList(this.context);
                        this.xmlStorage.storeUpSwList(string2, string, (UpSwData[])object2);
                        continue;
                    }
                    catch (Exception exception) {
                        MessageLog.info((Class)(class$se$ericsson$cello$productinventory$TypeCollector == null ? TypeCollector.class$("se.ericsson.cello.productinventory.TypeCollector") : class$se$ericsson$cello$productinventory$TypeCollector), (String)("Inventory data in UpSwList missing for UP with document number " + string2 + " and revision " + string + " due to " + exception));
                    }
                }
                continue;
            }
            if (this.productTypes[i] == ProductType.FW) {
                for (int j = 0; j < this.fwList.size(); ++j) {
                    FirmwareProductData firmwareProductData = (FirmwareProductData)this.fwList.elementAt(j);
                    object3 = firmwareProductData.getProductName(this.context);
                    string2 = firmwareProductData.getProductNumber(this.context);
                    string = firmwareProductData.getRState(this.context);
                    object2 = firmwareProductData.getProductionDate(this.context);
                    object = firmwareProductData.getSubrackId(this.context);
                    int n = firmwareProductData.getSlotPosition(this.context);
                    if (!this.isDateOk((String)object2)) {
                        MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$TypeCollector == null ? TypeCollector.class$("se.ericsson.cello.productinventory.TypeCollector") : class$se$ericsson$cello$productinventory$TypeCollector), (String)("Invalid date format (" + (String)object2 + ") from FW product: " + string2 + "/" + string + " slotPos=" + n), null);
                        object2 = DEFAULT_DATE;
                    }
                    this.xmlStorage.storeFirmware((String)object3, string2, string, (String)object2, (String)object, n);
                }
                continue;
            }
            if (this.productTypes[i] == ProductType.UP) {
                for (int j = 0; j < this.upList.size(); ++j) {
                    UpgradePackageProductData upgradePackageProductData = (UpgradePackageProductData)this.upList.elementAt(j);
                    object3 = upgradePackageProductData.getDocumentNumber(this.context);
                    string2 = upgradePackageProductData.getDocumentRevision(this.context);
                    string = upgradePackageProductData.getProductionDate(this.context);
                    object2 = upgradePackageProductData.getFilePath(this.context);
                    object = upgradePackageProductData.getUpStatus(this.context);
                    BasedOnData basedOnData = upgradePackageProductData.getBasedOnData(this.context);
                    if (!this.isDateOk(string)) {
                        MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$TypeCollector == null ? TypeCollector.class$("se.ericsson.cello.productinventory.TypeCollector") : class$se$ericsson$cello$productinventory$TypeCollector), (String)("Invalid date format (" + string + ") from UP product: " + (String)object3 + "/" + string2), null);
                        string = DEFAULT_DATE;
                    }
                    this.xmlStorage.storeUpgradePackage((String)object3, string2, string, (String)object2, (UpgradePackageProductData.UpStatus)object, basedOnData);
                }
                continue;
            }
            if (this.productTypes[i] != ProductType.CPI) continue;
            for (int j = 0; j < this.cpiList.size(); ++j) {
                CustomerProductInfoData customerProductInfoData = (CustomerProductInfoData)this.cpiList.elementAt(j);
                object3 = customerProductInfoData.getProductName(this.context);
                string2 = customerProductInfoData.getProductNumber(this.context);
                string = customerProductInfoData.getRState(this.context);
                object2 = customerProductInfoData.getProductionDate(this.context);
                object = customerProductInfoData.getFilePath(this.context);
                if (!this.isDateOk((String)object2)) {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$TypeCollector == null ? TypeCollector.class$("se.ericsson.cello.productinventory.TypeCollector") : class$se$ericsson$cello$productinventory$TypeCollector), (String)("Invalid date format (" + (String)object2 + ") from CPI product: " + string2 + "/" + string), null);
                    object2 = DEFAULT_DATE;
                }
                this.xmlStorage.storeCustomerProductInfo((String)object3, string2, string, (String)object2, (String)object);
            }
        }
    }

    private boolean isDateOk(String string) {
        return string != null && string.length() == 8;
    }

    private boolean isDateTimeOk(String string) {
        return string != null && string.length() == 14;
    }
}

