/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba;

import java.security.Principal;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.corba.MibAccessControl;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.vls.VLS;
import se.ericsson.cello.vls.VLSAccess;
import se.ericsson.cello.vls.VLSException;
import se.ericsson.security.corba.AccessControlEnabler;

public class AccessControlEnablerImpl
extends LocalObject
implements AccessControlEnabler,
ORBInitializer,
MibAccessControl {
    private static final long serialVersionUID = -2859315962864397616L;
    private VLSAccess vlsAccess = VLS.instance();

    public boolean isAuthorized(String string, String string2, String string3, String string4) {
        try {
            return this.vlsAccess.isAuthorized(string, string2, string3, string4);
        }
        catch (VLSException vLSException) {
            MessageLog.info(this.getClass(), (String)vLSException.toString());
            return false;
        }
    }

    public boolean isAuthorizedInMib(String string, int n, String string2) {
        CelloOrb celloOrb = CelloOrb.instance();
        boolean bl = false;
        if (celloOrb.securityActivated()) {
            String string3 = null;
            String string4 = null;
            Principal principal = celloOrb.getCurrent().getActingPrincipal();
            if (principal == null) {
                MessageLog.info((Class)MibAccessControl.class, (String)"No acting principal");
            } else {
                string3 = celloOrb.getCurrent().getUniqueID(principal);
                if (string3 == null) {
                    string4 = principal.getName();
                }
                if (string3 == null && string4 == null) {
                    MessageLog.info(this.getClass(), (String)"Both userName and userDN are null");
                } else {
                    try {
                        MessageLog.trace((int)5, this.getClass(), (String)("isAuthorizedInMib(" + string3 + ", " + string + ", " + n + ", " + string2));
                        bl = this.vlsAccess.isAuthorizedInMib(string3, string4, string, n, string2);
                    }
                    catch (VLSException vLSException) {
                        MessageLog.info(this.getClass(), (String)vLSException.toString());
                    }
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
        try {
            oRBInitInfo.register_initial_reference("AccessControlEnabler", (Object)this);
            MessageLog.info(this.getClass(), (String)"AccessControlEnabler published.");
            ServiceLocatorFacade.getRepository().addService(this, MibAccessControl.class, null);
        }
        catch (InvalidName invalidName) {
            MessageLog.traceError(this.getClass(), (String)"Failed to publish access control enabler.", (Throwable)invalidName);
        }
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
    }
}

