/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.FailedLoginException;
import javax.swing.JOptionPane;
import se.ericsson.security.login.Log;
import se.ericsson.security.login.LoginException;
import se.ericsson.security.login.LoginServices;
import se.ericsson.security.login.SSULocalizer;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.login.creds.CredentialsValidator;
import se.ericsson.security.login.gui.LoginHandler;
import se.ericsson.security.login.login.SLSProxy;
import se.ericsson.security.login.login.SlsConfiguration;
import se.ericsson.security.login.textmode.LoginHandlerTextMode;
import se.ericsson.security.securityreader.CorbaSecurityReader;
import se.ericsson.security.sls.SLSAddressReader;

public class LoginContext
implements LoginServices {
    private static final String SAM_PBE = "sam.pbe";
    private static final String ONAPPLICATIONSERVER_PROPERTY = "se.ericsson.security.onapplicationserver";
    private static final String SSUCREDENTIALS_XML = "ssucredentials.xml";
    public static final String SSU_USER_NAME = "ssu.user.name";
    private static LoginContext instance;
    private static final Log log;
    private boolean isJaasInitialized = false;
    private static final char[] ssuPwd;
    private static final String DEFAULT_CREDENTIALS_DIRECTORY;
    private static final String SSU_CREDENTIALS_FILEPATH_PROPERTY = "se.ericsson.security.ssu.ssucredentialfile";
    private static final String SSU_CREDS_DIR_PROPERTY = "se.ericsson.security.ssu.credsdir";
    private Map options;
    private boolean isLoggedIn = false;
    private Credentials credentials;
    private javax.security.auth.login.LoginContext jaasContext;
    private static final int THREAD_SLEEP_TIME = 300000;
    private File cdbFile = null;
    private int noOfApps = 0;
    private Vector applications = new Vector();
    private static CredentialsRecord loginRecord;
    TouchCdbFileThread touchCdbFileThread = null;
    private static final String CDB_DIRECTORY;
    public static final int SAM = 0;
    public static final int SSU = 1;
    private static boolean firstTimeLogin;
    static /* synthetic */ Class class$se$ericsson$security$login$LoginContext;
    static /* synthetic */ Class class$se$ericsson$security$login$creds$Credentials;

    LoginContext() {
        firstTimeLogin = true;
        loginRecord = null;
    }

    public static LoginContext getInstance(boolean bl) {
        if (bl) {
            return new LoginContext();
        }
        return LoginContext.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginContext getInstance() {
        if (instance == null) {
            Class clazz = class$se$ericsson$security$login$LoginContext == null ? (class$se$ericsson$security$login$LoginContext = LoginContext.class$("se.ericsson.security.login.LoginContext")) : class$se$ericsson$security$login$LoginContext;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new LoginContext();
                }
            }
        }
        return instance;
    }

    public static boolean isFirstTimeLogin() {
        return firstTimeLogin;
    }

    public static int getLoginMode() {
        if (loginRecord == null) {
            return 1;
        }
        return loginRecord.getLoginMode();
    }

    public void clearCredentialsFile() {
        String string = System.getProperty(SSU_CREDS_DIR_PROPERTY);
        if (string == null) {
            string = DEFAULT_CREDENTIALS_DIRECTORY;
        }
        File file = new File(string, SSUCREDENTIALS_XML);
        file.delete();
    }

    private void loginTextMode(boolean bl, String string, String string2) throws LoginException {
        LoginHandlerTextMode loginHandlerTextMode;
        if (bl) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " Creating a login handler for uname+password: " + string + " " + string2);
            }
            loginHandlerTextMode = string != null ? new LoginHandlerTextMode(string, string2) : new LoginHandlerTextMode(string2);
        } else {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " Creating a login handler for file based login");
            }
            loginHandlerTextMode = new LoginHandlerTextMode();
        }
        try {
            javax.security.auth.login.LoginContext loginContext = new javax.security.auth.login.LoginContext("ssu", loginHandlerTextMode);
            loginContext.login();
            Subject subject = loginContext.getSubject();
            if (subject == null) {
                if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                    System.out.println(new Date().toString() + " Throw login exception because no subject");
                }
                throw new LoginException("No subject available");
            }
            this.credentials = this.getSubjCredentials(subject);
            this.jaasContext = loginContext;
            if (Boolean.getBoolean(ONAPPLICATIONSERVER_PROPERTY)) {
                this.cdbFile = this.createCdbFile();
                this.touchCdbFileThread = new TouchCdbFileThread();
                Thread thread = new Thread(this.touchCdbFileThread);
                thread.start();
            }
        }
        catch (FailedLoginException failedLoginException) {
            log.warning("Failed to login", failedLoginException);
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " Login failed");
            }
            throw new LoginException("Login failed", failedLoginException);
        }
        catch (javax.security.auth.login.LoginException loginException) {
            log.error("Exception in login !!!", loginException);
            throw new LoginException("Login failed", loginException);
        }
    }

    private void autoLogin() throws LoginException {
        Object object;
        boolean bl = true;
        String string = System.getProperty(SSU_CREDENTIALS_FILEPATH_PROPERTY);
        if (string != null) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " The user has given a credentials file used for login " + string);
            }
            if (((File)(object = new File(string))).exists()) {
                bl = false;
                if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                    System.out.println(new Date().toString() + " The credentials file " + string + " exists and will be used for login");
                }
                this.loginTextModeGivenFile((File)object);
            } else if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " The credentials file " + string + " does not exist");
            }
        }
        if (bl) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " No credentialsFile specified; try to login using username and password");
            }
            object = System.getProperty("se.ericsson.security.ssu.slsusername");
            String string2 = System.getProperty("se.ericsson.security.ssu.slspassword");
            if (object != null && string2 != null) {
                if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                    System.out.println(new Date().toString() + " Try to login using username " + (String)object + " and password " + string2);
                }
                this.loginTextModeGivenDataNoRetry((String)object, string2);
            } else {
                if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                    System.out.println(new Date().toString() + " Login failed because no file and no username/password was specified");
                }
                throw new LoginException("Login failed because no file and no username/password was specified");
            }
        }
    }

    private void setupCdbFile() {
        if (this.cdbFile == null) {
            this.cdbFile = this.createCdbFile();
            this.touchCdbFileThread = new TouchCdbFileThread();
            Thread thread = new Thread(this.touchCdbFileThread);
            thread.start();
        }
    }

    public void loginTextModeGivenDataNoRetry(String string, String string2) throws LoginException {
        if (this.isLoggedIn) {
            throw new LoginException("Already logged in");
        }
        this.clearCredentialsFile();
        if (!this.isJaasInitialized) {
            this.setJAASConfiguration(null);
            this.isJaasInitialized = true;
        }
        this.loginTextMode(true, string, string2);
        if (firstTimeLogin) {
            firstTimeLogin = false;
        }
        this.isLoggedIn = true;
    }

    public void loginTextModeGivenFile(File file) throws LoginException {
        if (this.isLoggedIn) {
            throw new LoginException("Already logged in");
        }
        if (!this.isJaasInitialized) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " JAAS is not initialized");
            }
            this.setJAASConfiguration(file);
            this.isJaasInitialized = true;
        }
        this.loginTextMode(false, null, null);
        if (firstTimeLogin) {
            firstTimeLogin = false;
        }
        this.isLoggedIn = true;
    }

    public void loginTextModeSAM(String string) throws LoginException {
        if (this.isLoggedIn) {
            throw new LoginException("Already logged in");
        }
        if (!this.isJaasInitialized) {
            this.setJAASConfiguration(null);
            this.isJaasInitialized = true;
        }
        this.loginTextMode(true, null, string);
        if (firstTimeLogin) {
            firstTimeLogin = false;
        }
        this.isLoggedIn = true;
    }

    public void setLoginRecord(int n, long l) {
        loginRecord = new CredentialsRecord(n, l);
    }

    public long getModificationTime() {
        return loginRecord.getModificationTime();
    }

    public void setTitle(String string) {
        SSULocalizer.setTitle(string);
    }

    public void login(String string) throws LoginException {
        String string2 = SLSAddressReader.getSLSAddresses(string);
        if (string2 == null) {
            throw new LoginException("Could not fetch SLS addresse from the node.");
        }
        System.setProperty("se.ericsson.security.ssu.slsurls", string2);
        log.info("Setting SLS URLs to " + string2);
        this.login();
    }

    public void login() throws LoginException {
        if (this.isLoggedIn) {
            this.checkCurrentLogin();
        }
        if (this.isAutoLoginEnabled()) {
            this.autoLogin();
        } else {
            this.defaultLogin();
        }
        if (firstTimeLogin) {
            firstTimeLogin = false;
        }
        this.isLoggedIn = true;
    }

    private void checkCurrentLogin() throws LoginException {
        boolean bl = this.checkCredentials();
        if (bl) {
            throw new LoginException("Already logged in");
        }
        if (!bl && loginRecord.getLoginMode() == 0) {
            JOptionPane.showMessageDialog(null, SSULocalizer.getString("sam_creds_expired") + ". " + SSULocalizer.getString("fetch_new_sam_or_close_appl") + ".", null, -1);
            throw new LoginException("Login failed because SAM credentials are expired");
        }
        this.isLoggedIn = false;
    }

    private boolean isAutoLoginEnabled() {
        return Boolean.getBoolean("se.ericsson.security.ssu.autologin");
    }

    private void defaultLogin() throws LoginException {
        if (!this.isJaasInitialized) {
            this.setJAASConfiguration(null);
            this.isJaasInitialized = true;
        }
        try {
            LoginHandler loginHandler = new LoginHandler();
            javax.security.auth.login.LoginContext loginContext = new javax.security.auth.login.LoginContext("ssu", loginHandler);
            while (true) {
                try {
                    loginContext.login();
                    Subject subject = loginContext.getSubject();
                    if (subject == null) {
                        throw new LoginException("No subject available");
                    }
                    this.credentials = this.getSubjCredentials(subject);
                    this.jaasContext = loginContext;
                    if (Boolean.getBoolean(ONAPPLICATIONSERVER_PROPERTY)) {
                        this.setupCdbFile();
                    }
                }
                catch (FailedLoginException failedLoginException) {
                    log.warning("Failed to login", failedLoginException);
                    JOptionPane.showMessageDialog(null, failedLoginException.getMessage(), null, 0);
                    continue;
                }
                break;
            }
        }
        catch (javax.security.auth.login.LoginException loginException) {
            log.error("Exception in login !!!", loginException);
            throw new LoginException("Login failed", loginException);
        }
    }

    public boolean isLoggedIn() {
        if (!this.checkCredentials()) {
            this.isLoggedIn = false;
        }
        return this.isLoggedIn;
    }

    private boolean checkCredentials() {
        File file;
        boolean bl = false;
        String string = System.getProperty(SSU_CREDS_DIR_PROPERTY);
        if (string == null) {
            string = DEFAULT_CREDENTIALS_DIRECTORY;
        }
        if (loginRecord != null && (!(file = loginRecord.getLoginMode() == 0 ? new File(string, SAM_PBE) : new File(string, SSUCREDENTIALS_XML)).exists() || file.exists() && file.lastModified() <= loginRecord.getModificationTime())) {
            try {
                CredentialsValidator.checkValidity(this.credentials);
                bl = true;
                if (Boolean.getBoolean(ONAPPLICATIONSERVER_PROPERTY)) {
                    this.setupCdbFile();
                }
            }
            catch (CredentialsException credentialsException) {
                log.info("Credentials are invalid: " + credentialsException.getMessage());
            }
        }
        return bl;
    }

    public Credentials getCredentials() throws IllegalStateException, CredentialsException {
        if (!this.isLoggedIn) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " The user is not logged in when CSU tries to get the credentials");
            }
            if (this.isAutoLoginEnabled()) {
                if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                    System.out.println(new Date().toString() + " MOShell will perform auto login!");
                }
                try {
                    this.autoLogin();
                }
                catch (LoginException loginException) {
                    if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                        System.out.println(new Date().toString() + " An exception when autologin attempted");
                        loginException.printStackTrace();
                    }
                    throw new IllegalStateException("Not logged in");
                }
            } else {
                throw new IllegalStateException("Not logged in");
            }
        }
        return this.credentials;
    }

    public Credentials getCredentials(String string) throws IllegalStateException, CredentialsException {
        if (!this.isLoggedIn) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " The user is not logged in when CSU tries to get the credentials");
            }
            if (this.isAutoLoginEnabled()) {
                if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                    System.out.println(new Date().toString() + " MOShell will perform auto login!");
                }
                try {
                    this.autoLogin();
                }
                catch (LoginException loginException) {
                    if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                        System.out.println(new Date().toString() + " An exception when autologin attempted");
                        loginException.printStackTrace();
                    }
                    throw new IllegalStateException("Not logged in");
                }
            } else {
                throw new IllegalStateException("Not logged in");
            }
        }
        this.updateCdbFile(string);
        return this.credentials;
    }

    public void releaseCredentials(String string) throws IllegalStateException {
        if (!this.isLoggedIn) {
            throw new IllegalStateException("Not logged in");
        }
        if (this.cdbFile != null) {
            Properties properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(this.cdbFile);
                properties.load(fileInputStream);
                fileInputStream.close();
                int n = -1;
                for (int i = 0; i < this.applications.size(); ++i) {
                    ApplicationData applicationData = (ApplicationData)this.applications.get(i);
                    if (!applicationData.getName().equals(string)) continue;
                    n = applicationData.getNumber();
                    this.applications.remove(i);
                    break;
                }
                if (n != -1) {
                    properties.remove("appname" + n);
                    properties.remove("expirytime" + n);
                    properties.remove("starttime" + n);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.cdbFile);
                    properties.store(fileOutputStream, "cdbfile version 1.0");
                    fileOutputStream.close();
                } else {
                    log.debug("Error updating cdb-file! Application entry not found!");
                }
            }
            catch (IOException iOException) {
                log.debug("Error updating cdb-file!", iOException);
            }
        }
    }

    private File createCdbFile() {
        String string;
        Object object;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        object = "";
        Properties properties = new Properties();
        properties.put("hostname", string);
        properties.put("pid", object);
        Long l = new Long(System.currentTimeMillis());
        File file = new File(CDB_DIRECTORY + File.separator + l.toString() + ".cdb");
        try {
            File file2 = new File(CDB_DIRECTORY);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "cdbfile version 1.0");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            log.debug("Error updating cdb-file!", iOException);
        }
        return file;
    }

    private void updateCdbFile(String string) {
        ++this.noOfApps;
        Properties properties = new Properties();
        try {
            Certificate[] certificateArray = this.credentials.getCertificateChain();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            Long l = new Long(x509Certificate.getNotAfter().getTime());
            Long l2 = new Long(System.currentTimeMillis());
            FileInputStream fileInputStream = new FileInputStream(this.cdbFile);
            properties.load(fileInputStream);
            fileInputStream.close();
            properties.setProperty("appname" + this.noOfApps, string.toString());
            properties.setProperty("expirytime" + this.noOfApps, l.toString());
            properties.setProperty("starttime" + this.noOfApps, l2.toString());
            this.applications.add(new ApplicationData(string, this.noOfApps));
            FileOutputStream fileOutputStream = new FileOutputStream(this.cdbFile);
            properties.store(fileOutputStream, "cdbfile version 1.0");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            log.debug("Error updating cdb-file!", iOException);
        }
    }

    public String getUniqueID() throws IllegalStateException {
        if (!this.isLoggedIn) {
            throw new IllegalStateException("Not logged in");
        }
        return System.getProperty("user.name");
    }

    public void logout() throws LoginException {
        if (!this.isLoggedIn) {
            throw new IllegalStateException("Not logged in");
        }
        if (Boolean.getBoolean(ONAPPLICATIONSERVER_PROPERTY)) {
            if (this.touchCdbFileThread != null) {
                this.touchCdbFileThread.shutdown();
            }
            if (this.cdbFile != null) {
                this.cdbFile.delete();
            }
            this.noOfApps = 0;
        }
        if (this.jaasContext != null) {
            this.isJaasInitialized = false;
            try {
                this.jaasContext.logout();
                this.jaasContext = null;
            }
            catch (javax.security.auth.login.LoginException loginException) {
                throw new LoginException("Logout failed", loginException);
            }
        }
        this.isLoggedIn = false;
        firstTimeLogin = true;
    }

    private void setJAASConfiguration(File file) throws LoginException {
        Object object;
        File file2;
        String string = System.getProperty(SSU_CREDS_DIR_PROPERTY);
        if (string == null) {
            string = DEFAULT_CREDENTIALS_DIRECTORY;
        }
        if (file == null) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " No credentials file specified; using credentials directory and ssucredentials.xml");
            }
            file2 = new File(string, SSUCREDENTIALS_XML);
        } else {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " Using the specified credentials file " + file.getAbsolutePath());
            }
            file2 = file;
        }
        this.options = new HashMap();
        String string2 = System.getProperty("se.ericsson.security.ssu.slstimeout", "10");
        Integer n = new Integer(string2);
        log.config("SLS Timeout set to " + n);
        URL[] uRLArray = new URL[]{};
        String string3 = System.getProperty("se.ericsson.security.ssu.slsurls");
        if (string3 != null) {
            object = new StringTokenizer(string3, ",");
            uRLArray = new URL[((StringTokenizer)object).countTokens()];
            int n2 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    uRLArray[n2++] = new URL(((StringTokenizer)object).nextToken());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new LoginException("Malformed SLS URL format specified: " + string3, malformedURLException);
                }
            }
            this.options.put("SLSURLs", uRLArray);
            this.options.put("SLSTimeout", n);
        }
        if (((File)(object = new File(string, SAM_PBE))).exists()) {
            this.options.put("SAMFile", object);
        }
        this.options.put("NMFile", file2);
        Configuration.setConfiguration(new SlsConfiguration(this.options));
    }

    private Credentials getSubjCredentials(Subject subject) throws LoginException {
        Set set = subject.getPrivateCredentials(class$se$ericsson$security$login$creds$Credentials == null ? (class$se$ericsson$security$login$creds$Credentials = LoginContext.class$("se.ericsson.security.login.creds.Credentials")) : class$se$ericsson$security$login$creds$Credentials);
        if (set.size() != 1) {
            throw new LoginException("Wrong number of private credentials for " + subject);
        }
        Iterator iterator = set.iterator();
        return (Credentials)iterator.next();
    }

    public String getLoggedInUser() throws IllegalStateException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Not logged in!");
        }
        return System.getProperty(SSU_USER_NAME);
    }

    public boolean checkPassword(String string, String string2) throws LoginException, IllegalStateException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("User is not logged in!");
        }
        if (!string.equalsIgnoreCase(this.getLoggedInUser())) {
            throw new LoginException("Username is not the same as the logged in user");
        }
        if (!this.isJaasInitialized) {
            this.setJAASConfiguration(null);
            this.isJaasInitialized = true;
        }
        File file = (File)this.options.get("NMFile");
        URL[] uRLArray = (URL[])this.options.get("SLSURLs");
        SLSProxy sLSProxy = new SLSProxy(uRLArray, file, ssuPwd);
        try {
            return sLSProxy.authenticateUser(string, string2.toCharArray());
        }
        catch (javax.security.auth.login.LoginException loginException) {
            return false;
        }
    }

    public boolean isNodeSecure(String string) {
        return CorbaSecurityReader.isNodeSecure(string);
    }

    public boolean isSAMLogin() throws IllegalStateException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("No user logged in yet!");
        }
        return LoginContext.getLoginMode() != 1;
    }

    public List getCredentialsFilePaths() {
        String string;
        File file;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.getProperty(SSU_CREDENTIALS_FILEPATH_PROPERTY);
        if (string2 != null && (file = new File(string2)).exists()) {
            arrayList.add(string2);
        }
        if ((file = new File(string = this.getCredentialsFileDir(), SSUCREDENTIALS_XML)).exists() && !arrayList.contains(file.getAbsoluteFile())) {
            arrayList.add(file.getAbsolutePath());
        }
        if ((file = new File(string, SAM_PBE)).exists()) {
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    String getCredentialsFileDir() {
        String string = System.getProperty(SSU_CREDS_DIR_PROPERTY);
        if (string == null) {
            return DEFAULT_CREDENTIALS_DIRECTORY;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = Log.getInstance();
        ssuPwd = "secmgmt".toCharArray();
        DEFAULT_CREDENTIALS_DIRECTORY = System.getProperty("user.home") + File.separator + "Ericsson" + File.separator + "OMSec";
        loginRecord = null;
        CDB_DIRECTORY = DEFAULT_CREDENTIALS_DIRECTORY + File.separator + "sessions";
        firstTimeLogin = true;
    }

    private class CredentialsRecord {
        private int loginMode;
        private long modificationTime;

        CredentialsRecord(int n, long l) {
            this.loginMode = n;
            this.modificationTime = l;
        }

        int getLoginMode() {
            return this.loginMode;
        }

        long getModificationTime() {
            return this.modificationTime;
        }
    }

    class TouchCdbFileThread
    implements Runnable {
        private boolean stopped = false;

        TouchCdbFileThread() {
        }

        public void run() {
            while (!this.stopped) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (LoginContext.this.cdbFile == null) continue;
                LoginContext.this.cdbFile.setLastModified(System.currentTimeMillis());
            }
        }

        synchronized void shutdown() {
            this.stopped = true;
            this.notify();
        }
    }

    class ApplicationData {
        private String appname;
        private int number;

        ApplicationData(String string, int n) {
            this.appname = string;
            this.number = n;
        }

        String getName() {
            return this.appname;
        }

        int getNumber() {
            return this.number;
        }
    }
}

