/*
 * Decompiled with CFR 0.152.
 */
package com.jtheory.jdring;

import com.jtheory.jdring.AlarmManager;

public class AlarmWaiter
implements Runnable {
    protected AlarmManager mgr;
    protected Thread thread;
    private long sleepUntil = -1L;
    private boolean debug = false;
    private boolean shutdown = false;

    private void debug(String string) {
        if (this.debug) {
            System.out.println("[" + Thread.currentThread().getName() + "] AlarmWaiter: " + string);
        }
    }

    public AlarmWaiter(AlarmManager alarmManager, boolean bl, String string) {
        this.mgr = alarmManager;
        this.thread = new Thread((Runnable)this, string);
        this.thread.setPriority(1);
        this.thread.setDaemon(bl);
        this.thread.start();
    }

    public synchronized void update(long l) {
        this.sleepUntil = l;
        this.debug("Update for " + l);
        this.debug("calling notify() to update thread wait timeout");
        this.notify();
    }

    public synchronized void restart(long l) {
        this.sleepUntil = l;
        this.notify();
    }

    public synchronized void stop() {
        this.shutdown = true;
        this.notify();
    }

    public synchronized void run() {
        this.debug("running");
        while (!this.shutdown) {
            try {
                if (this.sleepUntil <= 0L) {
                    this.wait();
                } else {
                    long l = this.sleepUntil - System.currentTimeMillis();
                    if (l > 0L) {
                        this.wait(l);
                    }
                }
                if (this.sleepUntil < 0L || this.sleepUntil - System.currentTimeMillis() >= 0L) continue;
                this.sleepUntil = -1L;
                this.debug("notifying manager to ring next alarm");
                this.mgr.ringNextAlarm();
            }
            catch (InterruptedException interruptedException) {
                this.debug("interrupted");
            }
        }
        this.debug("stopping");
    }
}

