/*
 * Decompiled with CFR 0.152.
 */
package enea.ose.system;

import enea.ose.system.InSignal;
import enea.ose.system.OutSignal;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import enea.ose.system.UnregisteredSignal;

public class OseProcess {
    private static boolean isAttachIdLong = false;
    private static final String attachIdNotSupported = "attach id of type int is not supported on this platform";
    int pid;

    OseProcess(int n) {
        this.pid = n;
    }

    public static OseProcess hunt(String string) {
        int n = OseProcess.hunt(string, 0L);
        if (n == 0) {
            return null;
        }
        return new OseProcess(n);
    }

    public static void hunt(String string, Signal signal) {
        OseProcess.hunt(string, signal.javaToOse());
    }

    public static OseProcess getProcess(int n) throws IllegalArgumentException {
        if (OseProcess.isValidPID(n)) {
            return new OseProcess(n);
        }
        throw new IllegalArgumentException("Invalid process ID: " + n);
    }

    public void post(OutSignal outSignal) {
        OseProcess.send(outSignal.javaToOse(), this.pid);
    }

    public void post(OutSignal outSignal, OseProcess oseProcess) {
        OseProcess.sendWS(outSignal.javaToOse(), this.pid, oseProcess.pid);
    }

    public int attach() {
        if (isAttachIdLong) {
            throw new RuntimeException(attachIdNotSupported);
        }
        return (int)OseProcess.attach(0L, this.pid);
    }

    public long attach2() {
        return OseProcess.attach(0L, this.pid);
    }

    public int attach(Signal signal) {
        if (isAttachIdLong) {
            throw new RuntimeException(attachIdNotSupported);
        }
        return (int)OseProcess.attach(signal.javaToOse(), this.pid);
    }

    public long attach2(Signal signal) {
        return OseProcess.attach(signal.javaToOse(), this.pid);
    }

    public static void detach(int n) {
        if (isAttachIdLong) {
            throw new RuntimeException(attachIdNotSupported);
        }
        OseProcess.detach2(n);
    }

    public static void detach2(long l) {
        OseProcess.detach(l);
    }

    public static native void detach(long var0);

    public int getPID() {
        return this.pid;
    }

    public int hashCode() {
        return this.pid;
    }

    public boolean equals(Object object) {
        return object instanceof OseProcess && ((OseProcess)object).pid == this.pid;
    }

    static InSignal createJavaSignal(long l, SignalRegistry signalRegistry) {
        InSignal inSignal = null;
        if (l == 0L) {
            return null;
        }
        int n = OseProcess.getSigNo(l);
        Class clazz = signalRegistry.getSignalClass(n);
        if (clazz != null) {
            try {
                inSignal = (InSignal)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                OseProcess.freeBuf(l);
                throw new RuntimeException("Default constructor missing in " + clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                OseProcess.freeBuf(l);
                throw new RuntimeException("Default constructor not public in " + clazz.getName());
            }
            catch (ClassCastException classCastException) {
                OseProcess.freeBuf(l);
                throw new RuntimeException(clazz.getName() + " do not extend enea.ose.system.InSignal");
            }
            catch (Error error) {
                OseProcess.freeBuf(l);
                error.printStackTrace();
                throw error;
            }
        } else {
            inSignal = new UnregisteredSignal(n);
        }
        inSignal.sender = OseProcess.getSender(l);
        inSignal.addressee = OseProcess.getAddressee(l);
        inSignal.oseToJava(l);
        return inSignal;
    }

    private static native int hunt(String var0, long var1);

    private static native void send(long var0, int var2);

    private static native void sendWS(long var0, int var2, int var3);

    private static native long attach(long var0, int var2);

    private static native boolean isValidPID(int var0);

    private static native int getSigNo(long var0);

    private static native int getSender(long var0);

    private static native int getAddressee(long var0);

    private static native void freeBuf(long var0);
}

