/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.support.debug.trace.ObjectCache;
import se.ericsson.cello.support.debug.trace.PackageFilter;
import se.ericsson.cello.support.debug.trace.VariableFilter;

final class CachedPackageFilter
extends PackageFilter {
    ObjectCache cache = new ObjectCache(CLASSES_CACHED);
    PackageFilter packageFilter;
    public static int CLASSES_CACHED = 32;

    public CachedPackageFilter(PackageFilter packageFilter) {
        this.packageFilter = packageFilter;
    }

    private final void printClassEntries() {
        Iterator iterator = this.cache.entrySet().iterator();
        String string = "[";
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            VariableFilter variableFilter = (VariableFilter)entry.getValue();
            string = string + string2 + " ";
        }
        System.out.println(string + "]");
    }

    final VariableFilter getVF(String string) {
        VariableFilter variableFilter = (VariableFilter)this.cache.get(string);
        if (variableFilter == null) {
            variableFilter = new VariableFilter(string, this.packageFilter);
            this.cache.put(string, variableFilter);
        }
        return variableFilter;
    }

    public final boolean filterInfo(String string) {
        return this.getVF((String)string).info;
    }

    public final boolean filterError(String string) {
        return this.getVF((String)string).error;
    }

    public final boolean filterEnter(String string) {
        return this.getVF((String)string).enter;
    }

    public final boolean filterReturn(String string) {
        return this.getVF((String)string).ret;
    }

    public final boolean filterState(String string) {
        return this.getVF((String)string).state;
    }

    public final boolean filterParam(String string) {
        return this.getVF((String)string).param;
    }

    public final boolean filterSendSig(String string) {
        return this.getVF((String)string).send_sig;
    }

    public final boolean filterRecSig(String string) {
        return this.getVF((String)string).rec_sig;
    }

    public final boolean filterGroup(int n, String string) {
        return this.getVF((String)string).group[n];
    }

    private synchronized void updateFilters() {
        Iterator iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            entry.setValue(new VariableFilter(string, this.packageFilter));
        }
    }

    public final VariableFilter getAlwaysFilter() {
        return this.packageFilter.getAlwaysFilter();
    }

    public final void modifyFilter(String string, long l, int n) {
        this.packageFilter.modifyFilter(string, l, n);
        this.updateFilters();
    }

    public final long getFilterMask(String string) {
        return this.packageFilter.getFilterMask(string);
    }

    public final void setDefaultFilter(String string) {
        this.packageFilter.setDefaultFilter(string);
        this.updateFilters();
    }

    public String toString() {
        return this.packageFilter.toString();
    }
}

