/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import se.ericsson.cello.support.debug.CsHuntSig;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.debug.signals_lnx.OsaJavaTraceGroupMaskInd;
import se.ericsson.cello.support.debug.signals_lnx.OsaJavaTraceRegisterReq;
import se.ericsson.cello.support.debug.signals_lnx.OsaJavaTraceStatusReq;
import se.ericsson.cello.support.debug.trace.ThreadsContainerForLinux;

class ExternalCommunicatorForLinux
implements Runnable {
    SignalRegistry reg;
    OseProcess javaTraceServer;
    ThreadsContainerForLinux threadsContainer;
    boolean isInitialized = false;
    static final int OSE_HUNT_TIMEOUT = 5000;
    static final int ERROR_SLEEP_TIME = 10000;

    public ExternalCommunicatorForLinux(ThreadsContainerForLinux threadsContainerForLinux) {
        this.threadsContainer = threadsContainerForLinux;
        Thread thread = new Thread((Runnable)this, "Osa_debug_thread");
        thread.setPriority(thread.getThreadGroup().getMaxPriority());
        thread.setDaemon(true);
        thread.start();
    }

    private final void logSignal(String string) {
    }

    private OseProcess hunt(String string) {
        OseProcess.hunt(string, new CsHuntSig());
        SignalRegistry signalRegistry = new SignalRegistry();
        signalRegistry.add(CsHuntSig.class);
        InSignal inSignal = ThisProcess.receive(signalRegistry, 5000);
        if (inSignal != null && inSignal instanceof CsHuntSig) {
            return inSignal.getSender();
        }
        throw new IllegalArgumentException("Tried to hunt the process " + string + ", but it was not found.");
    }

    private void initLoop() {
        while (true) {
            try {
                this.init();
                return;
            }
            catch (Throwable throwable) {
                this.setInitialized();
                MessageLog.traceError(this.getClass(), "Could not init the external communication.", throwable);
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError(this.getClass(), "Unexpected exception.", interruptedException);
                    continue;
                }
            }
            break;
        }
    }

    private synchronized void init() {
        this.reg = new SignalRegistry();
        this.reg.add(OsaJavaTraceStatusReq.class);
        this.reg.add(OsaJavaTraceGroupMaskInd.class);
        this.javaTraceServer = this.hunt("JavaTraceServer");
        this.javaTraceServer.post(new OsaJavaTraceRegisterReq());
        this.setInitialized();
    }

    private final synchronized void setInitialized() {
        this.isInitialized = true;
        this.notifyAll();
    }

    private synchronized void waitForExternalCommunicatorProcess() {
        while (!this.isInitialized) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void run() {
        this.initLoop();
        while (true) {
            try {
                while (true) {
                    this.receiveSignal();
                }
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), "Error while handling signal from Java Trace Server", throwable);
                continue;
            }
            break;
        }
    }

    public void receiveSignal() {
        InSignal inSignal = ThisProcess.receive(this.reg);
        this.logSignal("Signal " + inSignal.getSigNo() + " received by Java Trace");
        if (inSignal instanceof OsaJavaTraceGroupMaskInd) {
            OsaJavaTraceGroupMaskInd osaJavaTraceGroupMaskInd = (OsaJavaTraceGroupMaskInd)inSignal;
            this.logSignal("Received group mask ind for " + osaJavaTraceGroupMaskInd.traceItem + ", mask = " + osaJavaTraceGroupMaskInd.groupMask);
            this.threadsContainer.modifyFilter(osaJavaTraceGroupMaskInd.traceItem, osaJavaTraceGroupMaskInd.groupMask, -1);
            this.threadsContainer.updateConfiguration(osaJavaTraceGroupMaskInd.traceItem, osaJavaTraceGroupMaskInd.groupMask);
        } else if (inSignal instanceof OsaJavaTraceStatusReq) {
            OsaJavaTraceStatusReq osaJavaTraceStatusReq = (OsaJavaTraceStatusReq)inSignal;
            this.threadsContainer.sendStatusInd(osaJavaTraceStatusReq.getSender(), osaJavaTraceStatusReq.traceItem);
        }
    }
}

