/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

public final class PackageEntry
implements Cloneable {
    String packageName;
    int packageNameLength;
    PackageEntry next;
    boolean isOn;

    public PackageEntry(String string) {
        this(string, false);
    }

    public PackageEntry(String string, boolean bl) {
        this(string, bl, null);
    }

    public PackageEntry(String string, boolean bl, PackageEntry packageEntry) {
        this.packageName = string;
        this.packageNameLength = this.packageName.indexOf(":");
        if (this.packageNameLength == -1) {
            this.packageNameLength = this.packageName.length();
        }
        this.isOn = bl;
        this.next = packageEntry;
        if (this.next != null) {
            this.next = this.next.removeRedundantEntries(this);
        }
    }

    final boolean isRedundantEntry(PackageEntry packageEntry) {
        if (this.packageName.length() == 0 || packageEntry.packageName.length() > 0 && this.isSubpackage(packageEntry.packageName)) {
            return packageEntry.isOn == this.isOn;
        }
        if (this.next == null) {
            return false;
        }
        return this.next.isRedundantEntry(packageEntry);
    }

    private final PackageEntry removeRedundantEntries(PackageEntry packageEntry) {
        if (packageEntry.packageName.length() == 0 || this.packageName.length() > 0 && packageEntry.isSubpackage(this.packageName)) {
            if (this.next == null) {
                return null;
            }
            return this.next.removeRedundantEntries(packageEntry);
        }
        if (this.next != null) {
            this.next = this.next.removeRedundantEntries(packageEntry);
        }
        return this;
    }

    public final PackageEntry removeEqualEntry(String string) {
        if (this.next != null) {
            if (this.packageName.equals(string)) {
                return this.next;
            }
            this.next = this.next.removeEqualEntry(string);
        }
        return this;
    }

    public final boolean isSubpackage(String string) {
        int n;
        if (this.packageNameLength > string.length()) {
            return false;
        }
        for (n = 0; n < this.packageNameLength; ++n) {
            if (this.packageName.charAt(n) == string.charAt(n)) continue;
            return false;
        }
        return this.packageNameLength == string.length() || string.charAt(n) == '.' || this.packageNameLength == 0;
    }

    public final boolean isFilterOn(String string) {
        if (this.isSubpackage(string) || this.packageName.length() == 0) {
            return this.isOn;
        }
        if (this.next == null) {
            throw new InternalError("Did not find a matching entry, when looking for a PackageEntry that matches name " + string);
        }
        return this.next.isFilterOn(string);
    }

    public boolean isFilterAlwaysOn() {
        if (this.packageName == null) {
            return false;
        }
        return this.packageName.equals("") && this.next == null && this.isOn;
    }

    public String toString() {
        String string = "{'" + this.packageName + "' " + (this.isOn ? "on" : "off") + "}";
        if (this.next != null) {
            string = string + ", " + this.next.toString();
        }
        return string;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        PackageEntry packageEntry = (PackageEntry)super.clone();
        packageEntry.packageName = this.packageName;
        if (this.next != null) {
            packageEntry.next = (PackageEntry)this.next.clone();
        }
        packageEntry.packageNameLength = this.packageNameLength;
        packageEntry.isOn = this.isOn;
        return packageEntry;
    }
}

