/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.log.FileElementDir;
import se.ericsson.cello.support.log.ObjectLog;

public class ObjectLogFactory {
    private File rootdir;
    private Hashtable logsdata;
    private static ObjectLogFactory instance;
    private static final String LOGS_DATA_FILENAME = "logs.metadata";

    public synchronized ObjectLog createFileLog(String string, int n, boolean bl) throws IOException {
        FileElementDir fileElementDir = null;
        try {
            File file;
            if (n < 10000) {
                n = 10000;
            }
            if (!(file = new File(this.rootdir, string)).isDirectory()) {
                file.mkdir();
            }
            if (!file.isDirectory()) {
                throw new IOException("Invalid directory " + file.getName());
            }
            int n2 = this.calcNoOfFiles(n);
            fileElementDir = FileElementDir.create(file, n, n2, bl);
            if (fileElementDir != null) {
                if (this.logsdata == null) {
                    this.logsdata = new Hashtable();
                }
            } else {
                throw new IOException("log is null");
            }
            this.logsdata.put(string, file);
            this.store();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            MessageLog.traceError(ObjectLogFactory.class, "Could not create log =\"" + string + "\"", exception);
            throw new IOException("ObjectLogFactory: Log could not be created. (" + exception.toString() + ")");
        }
        return fileElementDir;
    }

    public synchronized ObjectLog findFileLog(String string) {
        FileElementDir fileElementDir = null;
        if (this.logsdata != null && this.logsdata.containsKey(string)) {
            try {
                File file = (File)this.logsdata.get(string);
                if (file.isDirectory()) {
                    fileElementDir = FileElementDir.load(file);
                }
            }
            catch (IOException iOException) {
                MessageLog.traceError(ObjectLogFactory.class, "Could not find log =\"" + string + "\"", iOException);
                this.logsdata.remove(string);
                this.store();
            }
        }
        return fileElementDir;
    }

    public synchronized boolean deleteFileLog(String string) {
        FileElementDir fileElementDir = null;
        if (this.logsdata != null && this.logsdata.containsKey(string)) {
            try {
                File file = (File)this.logsdata.get(string);
                if (file.isDirectory()) {
                    fileElementDir = FileElementDir.load(file);
                    fileElementDir.delete();
                    this.logsdata.remove(string);
                    this.store();
                    return true;
                }
            }
            catch (IOException iOException) {
                MessageLog.traceError(ObjectLogFactory.class, "Could not delete log =\"" + string + "\"", iOException);
                this.logsdata.remove(string);
                this.store();
                return false;
            }
        }
        return false;
    }

    protected int calcNoOfFiles(int n) {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void store() {
        block8: {
            File file = new File(this.rootdir, LOGS_DATA_FILENAME);
            ObjectOutputStream objectOutputStream = null;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.logsdata);
            objectOutputStream.flush();
            Object var5_5 = null;
            try {
                objectOutputStream.close();
            }
            catch (Exception exception) {
                MessageLog.traceError(ObjectLogFactory.class, "Could not close.", exception);
            }
            break block8;
            {
                catch (Exception exception) {
                    MessageLog.traceError(ObjectLogFactory.class, "Could not store meta data object.", exception);
                    Object var5_6 = null;
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception2) {
                        MessageLog.traceError(ObjectLogFactory.class, "Could not close.", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    MessageLog.traceError(ObjectLogFactory.class, "Could not close.", exception);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void load() {
        block12: {
            this.logsdata = new Hashtable();
            ObjectInputStream objectInputStream = null;
            File file = new File(this.rootdir, LOGS_DATA_FILENAME);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(fileInputStream);
                this.logsdata = (Hashtable)objectInputStream.readObject();
                Object var5_5 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    break block12;
                }
                catch (Exception exception) {
                    MessageLog.traceError(ObjectLogFactory.class, "Could not close.", exception);
                }
                break block12;
                {
                    catch (Exception exception) {
                        MessageLog.traceError(ObjectLogFactory.class, "Could not read log data object", exception);
                        Object var5_6 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            break block12;
                        }
                        catch (Exception exception2) {
                            MessageLog.traceError(ObjectLogFactory.class, "Could not close.", exception2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        MessageLog.traceError(ObjectLogFactory.class, "Could not close.", exception);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static synchronized ObjectLogFactory instance() {
        if (instance == null) {
            instance = new ObjectLogFactory();
        }
        return instance;
    }

    private ObjectLogFactory() {
        String string = null;
        if (System.getProperty("SPARC") == null && System.getProperty("SPARC_OLD") == null) {
            string = "/c/logs/obj_logs/";
        } else {
            string = System.getProperty("objectlog.rootdirectory") != null ? System.getProperty("objectlog.rootdirectory") : System.getProperty("user.dir");
            if (!string.endsWith(System.getProperty("file.separator"))) {
                string = string + System.getProperty("file.separator");
            }
            string = string + "objlogs" + System.getProperty("file.separator");
        }
        MessageLog.info(ObjectLogFactory.class, "Objectlog root directory = " + string);
        this.rootdir = new File(string);
        this.rootdir.mkdirs();
        Assert.cppAssert(this.rootdir.isDirectory(), "Invalid objectlog root directory: " + string + "\n");
        this.load();
    }
}

