/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.transaction;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import se.ericsson.cello.transaction.AdvisoryLock;
import se.ericsson.cello.transaction.AdvisoryLockInfo;

class AdvisoryLockImpl
implements AdvisoryLock {
    private static AdvisoryLockImpl uniqueInstance = new AdvisoryLockImpl();
    private String operatorName = new String();
    private boolean lockSet = false;
    private GregorianCalendar calendar = new GregorianCalendar();
    private Date date = new Date();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd GG 'at' HH:mm:ss zzz");

    public static AdvisoryLockImpl instance() {
        return uniqueInstance;
    }

    public synchronized boolean setAdvisoryLock(String string) {
        if (this.lockSet) {
            return false;
        }
        this.lockSet = true;
        this.operatorName = string;
        this.date = this.calendar.getTime();
        return true;
    }

    public synchronized AdvisoryLockInfo getAdvisoryLock() {
        if (this.lockSet) {
            return new AdvisoryLockInfo(this.operatorName, this.formatter.format(this.date));
        }
        return null;
    }

    public synchronized void resetAdvisoryLock() {
        if (this.lockSet) {
            this.lockSet = false;
            this.operatorName = null;
            this.date = null;
        }
    }

    private AdvisoryLockImpl() {
    }
}

