/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.transaction;

import java.util.Enumeration;
import java.util.Hashtable;
import se.ericsson.cello.pri.LongSystemParameter;
import se.ericsson.cello.pri.PriJavaProxy;
import se.ericsson.cello.pri.PriJavaProxyFactory;
import se.ericsson.cello.pri.PriProcessNotFoundException;
import se.ericsson.cello.pri.SystemParameterNotFoundException;
import se.ericsson.cello.pri.WrongSystemParameterTypeException;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.ControlImpl;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionManager;
import se.ericsson.cello.transaction.TransactionResult;
import se.ericsson.cello.transaction.TransactionRolledBackException;

class CHandler
implements Runnable {
    private static CHandler instance = new CHandler();
    private Hashtable registerResponses = new Hashtable();
    private boolean isInitialized = false;
    private static boolean isRNC = false;
    private static final long timeOut = 1000L;

    public static CHandler instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.initiateService();
        this.isInitialized = true;
        if (System.getProperty("os.name").toLowerCase().indexOf("inux") < 0) {
            this.setIsRNC();
        }
        CHandler cHandler = this;
        synchronized (cHandler) {
            this.notifyAll();
        }
        while (true) {
            this.oseSignalHandler();
        }
    }

    private void rollback(int n, int n2) {
        ControlImpl controlImpl = TransactionManager.instance().getTransaction(n);
        if (controlImpl != null) {
            try {
                controlImpl.rollback(false, n2);
                MessageLog.info(this.getClass(), "Transaction " + n + " has been rolled back, cause: " + controlImpl.getTerminationCause());
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                // empty catch block
            }
        }
    }

    private void rollbackAllTransactions() {
        Enumeration enumeration = TransactionManager.instance().getAllTransactions();
        while (enumeration.hasMoreElements()) {
            ControlImpl controlImpl = (ControlImpl)enumeration.nextElement();
            try {
                controlImpl.rollback(false, 10000);
            }
            catch (InactiveTransactionException inactiveTransactionException) {}
        }
        MessageLog.info(this.getClass(), "The Transaction Server has terminated. Rollback all transactions");
    }

    public synchronized void waitForRegisterResponse(int n) throws TransactionRolledBackException {
        Integer n2 = new Integer(n);
        try {
            while (this.registerResponses.get(n2) == null) {
                this.wait(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            MessageLog.traceError(this.getClass(), interruptedException.toString());
            Assert.cppAssert(false);
        }
        TransactionResult transactionResult = (TransactionResult)this.registerResponses.remove(n2);
        if (transactionResult.value != 0) {
            throw new TransactionRolledBackException("Cannot register transaction " + n);
        }
    }

    private synchronized void registerResponseReceived(int n, int n2) {
        Integer n3 = new Integer(n);
        TransactionResult transactionResult = new TransactionResult(n2);
        this.registerResponses.put(n3, transactionResult);
        this.notifyAll();
    }

    private long checkNodeType() {
        long l = 1L;
        try {
            PriJavaProxy priJavaProxy = PriJavaProxyFactory.createPriJavaProxy();
            if (priJavaProxy != null) {
                LongSystemParameter longSystemParameter = priJavaProxy.getLongSystemParameter(l);
                if (longSystemParameter != null && longSystemParameter.isValid()) {
                    MessageLog.info(this.getClass(), "System parameter " + l + " = " + longSystemParameter.getValue());
                    return longSystemParameter.getValue();
                }
                MessageLog.traceError(this.getClass(), "Invalid system parameter.");
            } else {
                MessageLog.traceError(this.getClass(), "No PriJavaProxy available.");
            }
        }
        catch (WrongSystemParameterTypeException wrongSystemParameterTypeException) {
            MessageLog.traceError(this.getClass(), "Parameter " + l + " has wrong type");
        }
        catch (SystemParameterNotFoundException systemParameterNotFoundException) {
            MessageLog.traceError(this.getClass(), "Parameter " + l + " not found");
        }
        catch (PriProcessNotFoundException priProcessNotFoundException) {
            MessageLog.traceError(this.getClass(), "Parameter " + l + " not found");
        }
        return 0L;
    }

    private void setIsRNC() {
        isRNC = this.checkNodeType() == 1L;
    }

    public static boolean getIsRNC() {
        return isRNC;
    }

    static native int create(int var0, TransactionResult var1);

    static native void register(int var0, TransactionResult var1);

    static native void commit(int var0, TransactionResult var1);

    static native void rollback(int var0, TransactionResult var1);

    static native void update(int var0, String var1, TransactionResult var2);

    static native int getTransactionSize(int var0, TransactionResult var1);

    private native int initiateService();

    private native void oseSignalHandler();

    synchronized void waitUntilInitialized() {
        if (!this.isInitialized) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static native void initJNI();

    private CHandler() {
    }

    static {
        CHandler.initJNI();
    }
}

