/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueCableInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RfCableMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoImpl;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class SetCableDataAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "11/109 26-CRH 109 042/1-5";
    private static final int CONN_A_RX_A1 = 6;
    private static final int CONN_B_RX_A1 = 18;
    private static final int CONN_A_RXA_IO = 12;
    private static final int CONN_A_RXB_IO = 14;
    private static final int CONN_B_RXA_IO = 20;
    private static final int CONN_B_RXB_IO = 22;
    public static final int LOW_VERSION = 7000000;
    private static final int HIGH_VERSION = 8011999;
    public static final String BOAM_DATA_REVISION = "boamDataRevision";
    private static final int WIONA_FP_WITH_NEW_FORMAT = 7091000;
    private static final int LOWEST_P8_VERSION = 8000000;
    private static final SetCableDataAue INSTANCE = new SetCableDataAue();

    private SetCableDataAue() {
        super(SetCableDataAue.class);
    }

    public static SetCableDataAue instance() {
        return INSTANCE;
    }

    public int getLowVersion() {
        return 7000000;
    }

    public int getHighVersion() {
        return 8011999;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerConvert(List commands) throws Exception {
        this.traceEnter("triggerConvert(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        this.conditionallyExecute(tw.getCoordinator());
        return true;
    }

    private void conditionallyExecute(Coordinator context) throws Exception {
        int boamDataRev = this.getBoamDataRev(context);
        if (boamDataRev < 7091000) {
            this.trace("BOAM data revision is: " + boamDataRev + ", WionaFP, cable data is in old format, proceed");
            this.doExecute(context);
        } else if (boamDataRev >= 8000000) {
            this.trace("BOAM data revision is: " + boamDataRev + ", P8, cable data is in old format, proceed");
            this.doExecute(context);
        } else {
            this.trace("BOAM data revision is: " + boamDataRev + ", WionaFP, cable data already in new format, nothing to do");
        }
    }

    private void doExecute(Coordinator context) throws Exception {
        this.traceEnter("doExecute()");
        ArrayList<MpswTaAueCableInfoT> cableDataToChange = new ArrayList<MpswTaAueCableInfoT>();
        MoIterator iter = BoamHelper.findMOs((String)"RfCable");
        while (iter.hasMoreElements()) {
            RfCableMo cable = (RfCableMo)iter.nextMo();
            ManagedObject aRef = cable.getConnectedToObjectARef(context);
            ManagedObject bRef = cable.getConnectedToObjectBRef(context);
            boolean isARefRRUWOrRUW = this.isRRUWOrRUW(aRef, context);
            boolean isBRefRRUWOrRUW = this.isRRUWOrRUW(bRef, context);
            if (!isARefRRUWOrRUW && !isBRefRRUWOrRUW) continue;
            int objAConnId = this.getObjAConnValue(cable, isARefRRUWOrRUW, context);
            int objBConnId = this.getObjBConnValue(cable, isBRefRRUWOrRUW, context);
            cableDataToChange.add(new MpswTaAueCableInfoT(cable.getFroId(context), objAConnId, objBConnId));
        }
        AueProxy.instance().setCableData(cableDataToChange.toArray(new MpswTaAueCableInfoT[0]));
    }

    private boolean isRRUWOrRUW(ManagedObject mo, Coordinator context) throws MoAccessException {
        int auType;
        this.traceEnter("isRRUWOrRUW()");
        return mo instanceof AuxPlugInUnitMo && ((auType = ((AuxPlugInUnitMo)mo).getAuType(context)) == 19 || auType == 20);
    }

    private int getObjAConnValue(RfCableMo cable, boolean isRefRRUWOrRUW, Coordinator context) throws MoAccessException {
        this.traceEnter("getObjAConnValue()");
        int objAConnValue = cable.getObjectAConnector(context);
        if (isRefRRUWOrRUW) {
            if (objAConnValue == 6) {
                return 12;
            }
            return 14;
        }
        return objAConnValue;
    }

    private int getObjBConnValue(RfCableMo cable, boolean isRefRRUWOrRUW, Coordinator context) throws MoAccessException {
        this.traceEnter("getObjBConnValue()");
        int objBConnValue = cable.getObjectBConnector(context);
        if (isRefRRUWOrRUW) {
            if (objBConnValue == 18) {
                return 20;
            }
            return 22;
        }
        return objBConnValue;
    }

    private int getBoamDataRev(Coordinator context) throws MoAccessException {
        this.traceEnter("getBoamDataRev()");
        MoIterator iter = BoamHelper.findMOs((String)"NodeBFunction");
        if (iter.size() == 0) {
            this.traceError("Cannot find NodeBFunction MO");
            throw new SoftwareErrorException();
        }
        NodeBFunctionMoImpl nodeBFunctionMo = (NodeBFunctionMoImpl)iter.nextMo();
        Attribute attr = nodeBFunctionMo.getMyMoData().getAttribute(BOAM_DATA_REVISION);
        if (attr == null) {
            this.traceError("Cannot find NodeBFunction attribute named boamDataRevision");
            throw new SoftwareErrorException();
        }
        if (!(attr instanceof IntegerAttribute)) {
            this.traceError("Cannot find NodeBFunction integer attribute named boamDataRevision");
            throw new SoftwareErrorException();
        }
        return ((IntegerAttribute)attr).getValue(context);
    }
}

