/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue.impl;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;

public abstract class RepertoireHelper {
    private static final Class SELF = RepertoireHelper.class;
    private static final String SW_MANAGEMENT = "SwManagement";
    private static final String ROLE = "role";
    private static final String REPERTOIRE = "Repertoire";
    private static final String SW_ALLOCATION = "SwAllocation";

    public static void addRepertoire(SwAllocationMo swAllocation, ManagedObject repToAdd, Coordinator context) throws MoAccessException {
        swAllocation.actionAddRepertoire(repToAdd, context);
        MessageLog.traceEnter((Class)SELF, (String)("Repertoire " + repToAdd.getFullDistinguishedName() + " added to " + swAllocation.getFullDistinguishedName()));
    }

    public static void addRepertoire(SwAllocationMo swAllocation, String repIdToAdd, Coordinator context, boolean ingoreNotExisting) throws Exception {
        ManagedObject repToAdd = RepertoireHelper.getMo(REPERTOIRE, repIdToAdd);
        if (repToAdd != null) {
            RepertoireHelper.addRepertoire(swAllocation, repToAdd, context);
        } else if (ingoreNotExisting) {
            MessageLog.traceEnter((Class)SELF, (String)("Cannot find MO Repertoire=" + repToAdd));
        } else {
            throw new Exception("The Repertoire " + repIdToAdd + " does not exist");
        }
    }

    public static ManagedObject getMo(String typeName, String id) {
        MessageLog.traceEnter((Class)SELF, (String)("getMo(" + typeName + ", " + id + ")"));
        MoIterator moList = BoamHelper.findMOs((String)typeName, (String)id);
        if (moList.hasMoreElements()) {
            return (ManagedObject)moList.nextElement();
        }
        return null;
    }

    public static SwAllocationMo createSwAllocationIfNeeded(Coordinator context, String RBS_ROLE) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"createSwAllocationIfNeeded()");
        SwAllocationMo swAllocation = (SwAllocationMo)RepertoireHelper.getMo(SW_ALLOCATION, RBS_ROLE);
        if (swAllocation == null) {
            MessageLog.traceEnter((Class)SELF, (String)("SwAllocation=" + RBS_ROLE + " can not be found, create needed"));
            MoFactory swAllocationFactory = MoFactoryMgr.instance().lookup(SW_ALLOCATION);
            if (swAllocationFactory == null) {
                throw new Exception("Can't find factory for MO SwAllocation");
            }
            ManagedObject swManagement = RepertoireHelper.getMo(SW_MANAGEMENT);
            if (swManagement == null) {
                throw new Exception("Can't find MO SwManagement");
            }
            AttrListImpl attrs = new AttrListImpl();
            attrs.insert(ROLE, (Object)RBS_ROLE);
            swAllocation = (SwAllocationMo)swAllocationFactory.createMo(swManagement, (AttrList)attrs, RBS_ROLE, null, context);
            MessageLog.traceEnter((Class)SELF, (String)("MO " + swAllocation.getFullDistinguishedName() + " created"));
        } else {
            MessageLog.traceEnter((Class)SELF, (String)("MO " + swAllocation.getFullDistinguishedName() + " already exists, no new instance will be created"));
        }
        return swAllocation;
    }

    public static ManagedObject getMo(String nametype) {
        MessageLog.traceEnter((Class)SELF, (String)("getMo(" + nametype + ")"));
        MoIterator moList = BoamHelper.findMOs((String)nametype);
        if (moList.hasMoreElements()) {
            return (ManagedObject)moList.nextElement();
        }
        return null;
    }

    public static ManagedObject getSwAllocationMo(String typeName, String role, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)("getMo(" + typeName + ", " + role + ")"));
        MoIterator moList = BoamHelper.findMOs((String)typeName);
        while (moList.hasMoreElements()) {
            SwAllocationMo swAlloc = (SwAllocationMo)moList.nextElement();
            if (!swAlloc.getRole(context).equalsIgnoreCase(role)) continue;
            return swAlloc;
        }
        return null;
    }
}

