/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC13080698To13080699
extends DataConverterBase {
    private static final Class SELF = DC13080698To13080699.class;
    protected static final int fromConverterRev = 13080698;
    protected static final int toConverterRev = 13080699;
    private static final DC13080698To13080699 INSTANCE = new DC13080698To13080699();
    private static final char DELIM_CHAR = '-';
    private static final int MIN_NO_SECTORS = 1;
    private static final int MAX_NO_SECTORS = 12;
    private static final String INTERNAL_SECTOR_ANTENNA_NO = "1";

    private DC13080698To13080699() {
        super(13080698, 13080699);
    }

    public static DC13080698To13080699 instance() {
        return INSTANCE;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        List candidates = this.getUpdateCandidates();
        if (candidates.isEmpty()) {
            this.trace("No update is needed, no candidates found");
        } else {
            this.updateNamingAttributeValues(candidates);
        }
    }

    private void updateNamingAttributeValues(List candidates) throws Exception {
        this.traceEnter("updateNamingAttributeValues()");
        TopologyMgr mgr = new TopologyMgr(this.workingMoData);
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            MoData sectorAntenna = (MoData)iter.next();
            String saLdn = sectorAntenna.getLocalDistinguishedName();
            if (!this.isIdConverted(saLdn)) {
                this.validateId(saLdn);
                this.trace("Found SectorAntenna that needs to be updated: " + sectorAntenna.getLocalDistinguishedName());
                mgr.changeLdnTopology(sectorAntenna, this.getNewSaLdn(saLdn));
                continue;
            }
            this.trace("SectorAntenna " + sectorAntenna.getLocalDistinguishedName() + " has already correct RDN, no update needed");
        }
        this.trace(mgr.getModificationInfo());
    }

    private List getUpdateCandidates() throws Exception {
        this.traceEnter("getUpdateCandidates()");
        ArrayList<MoData> candidates = new ArrayList<MoData>();
        Collection sectorAntennas = this.workingMoData.getMoData("SectorAntenna");
        Iterator iter = sectorAntennas.iterator();
        while (iter.hasNext()) {
            MoData sectorAntenna = (MoData)iter.next();
            String saLdn = sectorAntenna.getLocalDistinguishedName();
            if (!this.isIdConverted(saLdn)) {
                this.validateId(saLdn);
                this.trace("Found SectorAntenna that needs to be updated: " + sectorAntenna.getLocalDistinguishedName());
                candidates.add(sectorAntenna);
                continue;
            }
            this.trace("SectorAntenna " + sectorAntenna.getLocalDistinguishedName() + " has already correct RDN, no update needed");
        }
        return candidates;
    }

    private boolean isIdConverted(String saLdn) {
        this.traceEnter("isIdConverted()");
        String saId = LDNHelper.getNamingAttributeValue(saLdn);
        int indexOfDelim = saId.indexOf(45);
        return indexOfDelim != -1;
    }

    private void validateId(String ldn) throws Exception {
        this.traceEnter("validateId()");
        String saId = LDNHelper.getNamingAttributeValue(ldn);
        if (saId.length() < 0 || saId.length() > 2) {
            String msg = "Id of SectorAntenna " + ldn + " is malformated, expecting to " + "be n, where n is the sector no, but was " + saId;
            MessageLog.traceError((Class)SELF, (String)msg);
            throw new Exception(msg);
        }
        try {
            int saNo = Integer.valueOf(saId);
            if (saNo < 1 || saNo > 12) {
                String msg = "The id of sectorAntenna " + ldn + " is not within range, must be within " + 1 + " and " + 12 + ", but was " + saId;
                MessageLog.traceError((Class)SELF, (String)msg);
                throw new Exception(msg);
            }
        }
        catch (NumberFormatException e) {
            String msg = "The id of SectorAntenna " + ldn + " is malformated, expecting to be n, " + "where n is the sector no, but was " + saId;
            MessageLog.traceError((Class)SELF, (String)msg);
            throw new Exception(msg);
        }
    }

    private String getNewSaLdn(String saLdn) {
        this.traceEnter("getNewSaLdn()");
        String oldSaRdn = LDNHelper.getRelativeDistinguishedName(saLdn);
        String newSaRdn = oldSaRdn + '-' + INTERNAL_SECTOR_ANTENNA_NO;
        return LDNHelper.replaceFirst(saLdn, oldSaRdn, newSaRdn);
    }
}

