/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC26060999To26061000
extends DataConverterBase {
    private static final DC26060999To26061000 instance = new DC26060999To26061000();
    protected static final int fromConverterRev = 26060999;
    protected static final int toConverterRev = 26061000;
    private final int OLD_IDENTUTY_FORMAT_SEPARATOR_NUMBER = 1;
    private final int UPDATED_IDENTUTY_FORMAT_SEPARATOR_NUMBER = 2;

    protected DC26060999To26061000() {
        super(26060999, 26061000);
    }

    public static DC26060999To26061000 instance() {
        return instance;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        List updateDatas = this.getUpdateCandidates();
        if (null == updateDatas || updateDatas.isEmpty()) {
            this.trace("No upgrade is necessary.");
            return;
        }
        this.updateLdn(updateDatas);
    }

    private void updateLdn(List updateDatas) throws Exception {
        Iterator eaIterator = updateDatas.iterator();
        while (eaIterator.hasNext()) {
            UpdateCandidate object = (UpdateCandidate)eaIterator.next();
            TopologyMgr mgr = new TopologyMgr(this.workingMoData);
            mgr.changeLdnTopology(object.moData, object.ldn);
            this.trace("ldn information : " + object.moData.getLocalDistinguishedName() + ", has new LDN : " + object.ldn);
            this.trace(mgr.getModificationInfo());
        }
    }

    private List getUpdateCandidates() {
        ArrayList<UpdateCandidate> result = new ArrayList<UpdateCandidate>();
        Collection eaCollection = this.workingMoData.getMoData("ExternalAntenna");
        if (eaCollection.isEmpty()) {
            return result;
        }
        Iterator eaIterator = eaCollection.iterator();
        while (eaIterator.hasNext()) {
            MoData moData = (MoData)eaIterator.next();
            String oldLdn = moData.getLocalDistinguishedName();
            this.trace("before invoke doDC() the oldLdn : " + oldLdn);
            String oldId = LDNHelper.getNamingAttributeValue(oldLdn);
            if (DC26060999To26061000.checkIfUpdatedIdFormat(oldId, 2)) {
                this.trace("not need to update ldn : " + oldId);
                continue;
            }
            if (!BoamHelper.checkIfIdentityFormatCorrect((String)oldId, (int)1)) {
                this.info("The RDN of ExternalAntenna to update is incorrect:" + oldId + ", it should follow the rule: {sectorIndex}-{sequence number}, such as:1-2.");
                continue;
            }
            String newLdn = oldLdn.substring(0, oldLdn.lastIndexOf("=") + 1).concat(this.generateNewId(oldId));
            result.add(new UpdateCandidate(moData, newLdn));
        }
        return result;
    }

    private static boolean checkIfUpdatedIdFormat(String oldId, int separatorNo) {
        if (null == oldId) {
            return true;
        }
        char[] chars = oldId.toCharArray();
        int count = 0;
        int index = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '-') continue;
            if (i != index + 1) {
                ++count;
                index = i;
                continue;
            }
            return false;
        }
        return index != chars.length - 1 && count == separatorNo;
    }

    private String generateNewId(String oldId) {
        this.trace("old id: " + oldId);
        StringBuffer sBuffer = new StringBuffer();
        char[] temp = oldId.toCharArray();
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i] == '-') {
                sBuffer.append("-1-");
                continue;
            }
            sBuffer.append(temp[i]);
        }
        this.trace("new id: " + sBuffer.toString());
        return sBuffer.toString();
    }

    private class UpdateCandidate {
        private final MoData moData;
        private final String ldn;

        public UpdateCandidate(MoData moData, String ldn) {
            this.moData = moData;
            this.ldn = ldn;
        }
    }
}

