/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.impl.CreateMoHelper;
import se.ericsson.wcdma.rbs.boam.conv.operations.CreateDeviceOp;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Macro;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoConverterUtility;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.UpdateReferenceAttributeOp;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;

public class DC40130500To40130501
extends DataConverterBase {
    private static final Class SELF = DC40130500To40130501.class;
    public static final int FROM_BOAM_REV = 40130500;
    public static final int TO_BOAM_REV = 40130501;
    private static final String RESERVED_BY = "persistentReservers";
    private static DC40130500To40130501 instance = new DC40130500To40130501(40130500, 40130501);
    private final Macro macro = new Macro();

    private DC40130500To40130501(int fromRev, int toRev) {
        super(fromRev, toRev);
    }

    public static DC40130500To40130501 instance() {
        return instance;
    }

    protected void initDC(Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"initDC(), TMA Device Cardinality from 2 to 4");
        this.macro.add(new CreateDeviceOp(this.workingMoData, context, "TmaDevice", "TmaDeviceSet", "DeviceGroup", "ATMAU", 40130501, 4));
        this.macro.add(new CreateDeviceOp(this.workingMoData, context, "TmaDevice", "TmaDeviceSet", "DeviceGroup", "TMF", 40130501, 4));
        this.macro.add(new CreateDeviceOp(this.workingMoData, context, "TmaDevice", "TmaDeviceSet", "AscDeviceGroup", 40130501, 4, false));
        MoData[] tmaDevSetMoData = MoConverterUtility.getMoDataByType(this.workingMoData, context, "TmaDeviceSet");
        if (null != tmaDevSetMoData && tmaDevSetMoData.length > 0) {
            MessageLog.trace((int)9, (Class)SELF, (String)("Found " + tmaDevSetMoData.length + " TmaDeviceSet MOs"));
            for (int i = 0; i < tmaDevSetMoData.length; ++i) {
                if (!tmaDevSetMoData[i].getMoTypeName().equalsIgnoreCase("TmaDeviceSet")) continue;
                String tmaDevSetLdn = tmaDevSetMoData[i].getLocalDistinguishedName();
                MessageLog.trace((int)9, (Class)SELF, (String)("TmaDeviceSet ldn = " + tmaDevSetLdn));
                Collection tmaDevs = FindMo.getChildren("TmaDevice", tmaDevSetLdn, this.workingMoData);
                String sectorLdn = null;
                boolean gotReservedBySector = false;
                Iterator iter = tmaDevs.iterator();
                while (iter.hasNext()) {
                    MoData tmaDev = (MoData)iter.next();
                    SequenceAttribute tmaReservedBySectors = (SequenceAttribute)tmaDev.getAttribute(RESERVED_BY);
                    if (null == tmaReservedBySectors) continue;
                    Attribute[] sectors = tmaReservedBySectors.getValue(context);
                    for (int j = 0; j < sectors.length; ++j) {
                        ReferenceAttribute sector = (ReferenceAttribute)sectors[j];
                        sectorLdn = sector.getReferenceAsLDN();
                        MessageLog.trace((int)9, (Class)SELF, (String)("Found rervered Sector MO ldn = " + sectorLdn + " in TmaDevice MO " + tmaDev.getLocalDistinguishedName()));
                        if (null == sectorLdn || "".equals(sectorLdn)) continue;
                        gotReservedBySector = true;
                        break;
                    }
                    if (!gotReservedBySector) continue;
                    break;
                }
                Vector tmaDevCMoData = CreateMoHelper.getCMoData("TmaDevice", tmaDevSetLdn);
                if (!gotReservedBySector || null == tmaDevCMoData || tmaDevCMoData.toArray() == null) continue;
                Object[] collectedData = tmaDevCMoData.toArray();
                MessageLog.trace((int)9, (Class)SELF, (String)("Found " + collectedData.length + " CMoData under TmaDeviceSet " + tmaDevSetLdn));
                for (int k = 0; k < collectedData.length; ++k) {
                    CMoData cMoData = (CMoData)collectedData[k];
                    String tmaLdn = cMoData.getLocalDistinguishedName();
                    MessageLog.trace((int)9, (Class)SELF, (String)("Found TmaDevice MO " + tmaLdn));
                    this.macro.add(new UpdateReferenceAttributeOp(this.workingMoData, sectorLdn, "Sector", 40130501, "tmaDeviceRef", tmaLdn, false, context));
                }
            }
        }
    }

    protected void doDC() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"doDC(), TMA Device Cardinality from 2 to 4");
        CommandHandler.execute(this.macro, 1);
    }
}

