/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.FroDataConverter;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Database;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DbAccessException;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Sql;
import se.ericsson.wcdma.rbs.boam.upfwk.frodata.TablePrinter;

public abstract class CommonSupportSystemFroDataConverter
extends FroDataConverter
implements Command {
    protected static final ManagedObject ignored = null;
    public static final String FRO_ID = "froId";
    private static final String FRO_ID_KEY = "froid";
    public static final int COMMON_SUPPORT_MAGIC_REV = 8010001;
    private static final String APC_FRO_ATTRIBUTES = "apc_fro_attributes";
    private static final String FROTYPE = "frotype";
    private static final String FROTYPENAME = "frotypename";
    private static final String FRODATATABLENAME = "frodatatablename";
    private static final String ATTRNAME = "attrname";
    public static final String ATTRTYPE = "attrtype";
    protected static final int SAU = 21;
    protected static final int SCU = 22;
    protected static final int SUP = 23;
    protected static final String SUP_AU_TYPE = "SUP";
    protected static final String SAU_AU_TYPE = "SAU";
    protected static final String SCU_AU_TYPE = "SCU";
    protected static final String BFU_AU_TYPE = "BFU";
    protected static final String PSU_AU_TYPE = "PSU";
    private static final Map FRO_TYPES = new HashMap();
    private int nextFroId = -1;

    protected CommonSupportSystemFroDataConverter(String aueName) {
        super(aueName);
    }

    public final int getLowVersion() {
        return 7000000;
    }

    public final int getHighVersion() {
        return 8051799;
    }

    protected void triggerBoamSoamConvert(List commands) throws Exception {
        this.trace("triggerBoamSoamConvert(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected abstract ColumnData[] getColumnData();

    protected abstract String getTypeName();

    protected abstract Object[] getTableData(ManagedObject var1, Coordinator var2) throws MoAccessException;

    protected abstract void createNewMoData(MoData var1, String var2, int var3, Coordinator var4) throws MoAccessException;

    protected abstract ApcFroAttributes[] getApcFroAttributesData();

    protected abstract String getNewTypeName();

    public void execute() throws Exception {
        this.info("\nStart to execute ");
        TransactionWrapper tx = this.createTransactionWrapper();
        try {
            this.doExecute(tx.getCoordinator());
            tx.commit();
            this.info("\nAue finished successfully!!");
        }
        catch (Exception e) {
            this.rollback(tx);
            this.traceError(" Interrupting the system upgrade!! Exception thrown during AUE execution", e);
            throw e;
        }
    }

    private TransactionWrapper createTransactionWrapper() throws TransactionRolledBackException {
        try {
            return new TransactionWrapper();
        }
        catch (TransactionRolledBackException e) {
            this.traceError("Interrupting the system upgrade!! Failed to create transaction", e);
            throw e;
        }
    }

    private void rollback(TransactionWrapper tx) {
        this.trace("\nrollback()");
        try {
            tx.rollback();
            this.trace("transaction rolled back: " + tx);
        }
        catch (InactiveTransactionException e) {
            this.traceError("failed to roll back transaction " + tx, e);
        }
    }

    private void doExecute(Coordinator contxt) throws DbAccessException, MoAccessException {
        this.traceEnter("doExecute()");
        if (this.cabinetExist()) {
            this.createApcFroVersionTable();
            this.createApcFroAttributesTable();
            this.createAndPopulateTables(contxt);
        }
    }

    private void createApcFroVersionTable() throws DbAccessException {
        this.traceEnter("createApcFroVersionTable()");
        Database db = DatabaseMgr.getDatabase();
        Sql sql = DatabaseMgr.getSql();
        if (!db.tableExists("apc_fro_versions")) {
            Sql.CreateTable create = sql.createTable("apc_fro_versions");
            create.addPrimaryKey(FROTYPE, "INTEGER", "NOT NULL");
            create.addColumn(FROTYPENAME, sql.varcharType(50), "NOT NULL");
            create.addColumn(FRODATATABLENAME, sql.varcharType(50), "NOT NULL");
            this.info("Executing sql: " + create.toString());
            db.executeSql(create);
            db.commit();
        }
    }

    private void createApcFroAttributesTable() throws DbAccessException {
        this.traceEnter("createApcFroAttributesTable()");
        Database db = DatabaseMgr.getDatabase();
        Sql sql = DatabaseMgr.getSql();
        if (!db.tableExists(APC_FRO_ATTRIBUTES)) {
            Sql.CreateTable create = sql.createTable(APC_FRO_ATTRIBUTES);
            create.addPrimaryKey(FROTYPE, "INTEGER", "NOT NULL");
            create.addPrimaryKey(ATTRNAME, sql.varcharType(50), "NOT NULL");
            create.addColumn(ATTRTYPE, sql.varcharType(10), "NOT NULL");
            db.executeSql(create);
            db.commit();
        }
    }

    private void createAndPopulateTables(Coordinator contxt) throws DbAccessException, MoAccessException {
        String typeName;
        this.traceEnter("createAndPopulateTables()");
        Database db = DatabaseMgr.getDatabase();
        Sql sql = DatabaseMgr.getSql();
        String tableName = this.getTableName();
        db.getTables();
        if (!this.getNewTypeName().equals("SupportSystemConfiguration") && !db.tableExists(tableName)) {
            Sql.CreateTable create = sql.createTable(tableName);
            create.addPrimaryKey(FRO_ID_KEY, "INTEGER", "NOT NULL");
            ColumnData[] columnData = this.getColumnData();
            for (int i = 0; i < columnData.length; ++i) {
                create.addColumn(columnData[i].getColumnName(), columnData[i].getColumnType(), "NOT NULL");
            }
            db.executeSql(create);
        }
        if ((typeName = this.getTypeName()) != null) {
            boolean hasSup = false;
            MoIterator it = FindMo.findMOs(this.getTypeName());
            while (it.hasMoreElements()) {
                ManagedObject mo = it.nextMo();
                if (typeName.equals("AuxPlugInUnit") && !hasSup) {
                    hasSup = ((AuxPlugInUnitMo)mo).getAuType(contxt) == 23;
                }
                this.trace("Processing mo with ldn: " + mo.getLocalDistinguishedName());
                this.persistFroAndMo(mo, db, sql, tableName, true, contxt);
            }
            if (this.getAueName().equals("HwUnitFroDataConverter") && !hasSup) {
                this.persistFroAndMo(null, db, sql, tableName, false, contxt);
            }
        } else if (this.getAueName().equals("EcPortFroDataConverter")) {
            boolean hasSup = false;
            MoIterator it = FindMo.findMOs("AuxPlugInUnit");
            while (it.hasMoreElements()) {
                AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)it.nextElement();
                int auType = auxPiu.getAuType(contxt);
                if (auType != 15 && auType != 14 && auType != 21 && auType != 22 && auType != 23) continue;
                if (!hasSup) {
                    hasSup = auType == 23;
                }
                this.persistFroAndMo((ManagedObject)auxPiu, db, sql, tableName, false, contxt);
            }
            it = FindMo.findMOs("PlugInUnit");
            while (it.hasMoreElements()) {
                PlugInUnitMo piu = (PlugInUnitMo)it.nextElement();
                String unitType = piu.getUnitType(contxt);
                if (!unitType.startsWith("CBU") && !unitType.startsWith("DUW")) continue;
                this.persistFroAndMo((ManagedObject)piu, db, sql, tableName, false, contxt);
            }
            if (!hasSup) {
                this.persistFroAndMo(null, db, sql, tableName, false, contxt);
            }
        } else if (this.getAueName().equals("EquipmentSuppportFunctionFroDataConverter")) {
            this.persistFroAndMo(ignored, db, sql, tableName, false, contxt);
        } else if (this.getAueName().equals("SupportSystemConfigurationFroDataConverter")) {
            this.persistFroAndMo(null, null, null, null, false, contxt);
        } else if (this.getAueName().equals("ExternalNodeFroDataConverter")) {
            this.info("converter for ExternalNode is not yet supported");
        } else {
            this.info("converter " + this.getAueName() + " is not supported!");
        }
        ApcFroAttributes[] apcFroAttributes = this.getApcFroAttributesData();
        for (int i = 0; i < apcFroAttributes.length; ++i) {
            Object[] objects = apcFroAttributes[i].getAttributeArray();
            if (objects == null) continue;
            db.executeSql(sql.insert(APC_FRO_ATTRIBUTES, objects));
        }
        if (apcFroAttributes.length > 0) {
            db.executeSql(sql.insert("apc_fro_versions", new Object[]{new Integer(apcFroAttributes[0].getFroType()), this.getNewTypeName(), this.getTableName()}));
        }
        db.commit();
    }

    protected boolean cabinetExist() {
        MoIterator it = FindMo.findMOs("Cabinet");
        return it.hasMoreElements();
    }

    private void persistFroAndMo(ManagedObject mo, Database db, Sql sql, String tableName, boolean useMoData, Coordinator context) throws MoAccessException, DbAccessException {
        Object[] tableData = this.getTableData(mo, context);
        if (tableData != null) {
            this.validateTableData(tableData);
            if (db != null) {
                db.executeSql(sql.insert(tableName, tableData));
            }
            this.createNewMoData(useMoData ? this.getMoData(mo) : null, (String)tableData[1], (Integer)tableData[0], context);
        }
    }

    private void validateTableData(Object[] tableData) throws SoftwareErrorException {
        if (tableData.length < 2) {
            this.traceError("Object[].length must be at least 2; actual: " + tableData.length);
            throw new SoftwareErrorException();
        }
        if (!(tableData[1] instanceof String)) {
            this.traceError("Object[1] must be a LDN (a String); found: " + tableData[1]);
            throw new SoftwareErrorException();
        }
        if (!(tableData[0] instanceof Integer)) {
            this.traceError("Object[0] must be an Integer; found: " + tableData[0]);
            throw new SoftwareErrorException();
        }
        int froId = (Integer)tableData[0];
        if (froId < 0) {
            this.traceError("Object[0] must be a non-negative Integer; found: " + tableData[1]);
            throw new SoftwareErrorException();
        }
    }

    public static void printOutTables() throws DbAccessException {
        TablePrinter printer = new TablePrinter();
        printer.setPrintToMessageLog();
        printer.printTable("apc_frodata_cabinet_INITIAL");
        printer.printTable("apc_frodata_fangroup_INITIAL");
        printer.printTable(APC_FRO_ATTRIBUTES);
        printer.printTable("apc_fro_versions");
    }

    protected static String getAuType(ManagedObject mo, Coordinator context) throws MoAccessException {
        switch (((AuxPlugInUnitMo)mo).getAuType(context)) {
            case 15: {
                return BFU_AU_TYPE;
            }
            case 14: {
                return PSU_AU_TYPE;
            }
            case 21: {
                return SAU_AU_TYPE;
            }
            case 22: {
                return SCU_AU_TYPE;
            }
            case 23: {
                return SUP_AU_TYPE;
            }
        }
        return null;
    }

    public void setFroId(MoData moData, int value, Coordinator context) throws MoAccessException {
        this.info("setFroId(), setting value: " + value);
        moData.handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute intAttr = (IntegerAttribute)moData.getAttribute(FRO_ID);
        if (intAttr == null) {
            intAttr = new IntegerAttribute(FRO_ID, false);
            moData.registerPersistentAttr((Attribute)intAttr);
        }
        intAttr.setValue(value);
    }

    /*
     * WARNING - void declaration
     */
    private MoData getMoData(ManagedObject mo) throws SoftwareErrorException {
        void var2_2;
        MoData result;
        if (mo instanceof BoamManagedObject) {
            result = ((BoamManagedObject)mo).getMyMoData();
        } else if (mo.getClass().getName().equals("se.ericsson.wcdma.rbs.boam.mao.emo.power.tb.mock.MockPowerSupplySystem")) {
            result = this.getMoData(mo, "getMyMoData");
        } else if (mo.getClass().getName().equals("se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.tb.mock.MockCabinet")) {
            result = this.getMoData(mo, "getMyMoData");
        } else if (mo.getClass().getName().equals("se.ericsson.wcdma.rbs.boam.mao.dmo.climate.tb.mock.MockFanGroup")) {
            result = this.getMoData(mo, "getMyMoData");
        } else if (mo.getClass().getName().equals("se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.tb.mock.MockAuxPlugInUnit")) {
            result = this.getMoData(mo, "getMyMoData");
        } else if (mo.getClass().getName().equals("se.ericsson.wcdma.rbs.boam.mao.emo.power.tb.mock.MockBattery")) {
            result = this.getMoData(mo, "getMyMoData");
        } else {
            this.traceError("cannot retrieve MoData from object of type: " + mo.getClass().getName());
            throw new SoftwareErrorException();
        }
        if (var2_2 == null) {
            this.traceError("no MoData found for MO: " + mo + " of type: " + mo.getClass().getName());
            throw new SoftwareErrorException();
        }
        return var2_2;
    }

    private MoData getMoData(ManagedObject mo, String getterName) throws SoftwareErrorException {
        try {
            return (MoData)mo.getClass().getMethod(getterName, new Class[0]).invoke((Object)mo, new Object[0]);
        }
        catch (Exception e) {
            this.traceError("cannot retrieve MoData", e);
            throw new SoftwareErrorException((Throwable)e);
        }
    }

    public static String convertIntArrayToString(int[] intArray, String arrayName) {
        StringBuffer result = new StringBuffer("<array name=\"" + arrayName + "\">");
        for (int i = 0; i < intArray.length; ++i) {
            result.append("<attr type=\"S32\" value=\"");
            result.append(intArray[i]);
            result.append("\" />");
        }
        return result.append("</array>").toString();
    }

    protected void traceError(String message) {
        MessageLog.traceError(this.getClass(), (String)message);
    }

    protected void traceError(String message, Throwable e) {
        MessageLog.traceError(this.getClass(), (String)message, (Throwable)e);
    }

    protected void traceEnter(String message) {
        MessageLog.traceEnter(this.getClass(), (String)message);
    }

    protected void info(String message) {
        MessageLog.info(this.getClass(), (String)message);
    }

    protected void trace(String message) {
        MessageLog.trace((int)9, this.getClass(), (String)message);
    }

    private String getTableName() {
        return "apc_frodata_" + this.getNewTypeName() + "_INITIAL";
    }

    protected int getFroType() {
        String key = this.getNewTypeName();
        Object x = FRO_TYPES.get(key);
        if (x == null) {
            throw new RuntimeException("the FRO_TYPES map must support: " + key);
        }
        return (Integer)x;
    }

    protected int nextFroId() {
        ++this.nextFroId;
        return this.nextFroId;
    }

    protected String getSupHwUnitId(String auxId) throws MoAccessException {
        this.traceEnter("getSupHwUnitId( " + auxId + " )");
        String newId = LDNHelper.convertAuxPIUIdToHwUnitId(auxId);
        if (newId == null) {
            throw new ConfigurationNotSupportedException("Not possible to convert Id for SUP. Configuration is not according to RBS_Configuration_Data.xls before the upgrade, AuxPlugInUnitId: " + auxId + ", " + "should be SUP_<number>");
        }
        return newId;
    }

    static {
        FRO_TYPES.put("AlarmPort", new Integer(117702659));
        FRO_TYPES.put("BatteryBackup", new Integer(117702661));
        FRO_TYPES.put("Cabinet", new Integer(0x7040000));
        FRO_TYPES.put("ControlPort", new Integer(0x7040004));
        FRO_TYPES.put("EcPort", new Integer(117702662));
        FRO_TYPES.put("ExternalNode", new Integer(0x7040007));
        FRO_TYPES.put("FanGroup", new Integer(117702657));
        FRO_TYPES.put("HwUnit", new Integer(117702658));
        FRO_TYPES.put("PowerDistribution", new Integer(117702664));
        FRO_TYPES.put("PowerSupply", new Integer(117702665));
        FRO_TYPES.put("EquipmentSupportFunction", new Integer(117702666));
    }
}

