/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.frodataconv.CommonSupportSystemFroDataConverter;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySystemMo;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;

public class PowerSupplyFroDataConverter
extends CommonSupportSystemFroDataConverter {
    private static final PowerSupplyFroDataConverter INSTANCE = new PowerSupplyFroDataConverter();
    private final ColumnData[] columnData = new ColumnData[]{new ColumnData("ldn", DatabaseMgr.getSql().varcharType(100)), new ColumnData("nominalVoltage", "INTEGER"), new ColumnData("systemOvervoltageAlarmCeaseOffset", "INTEGER"), new ColumnData("systemOvervoltageAlarmLevel", "INTEGER"), new ColumnData("systemUndervoltageAlarmCeaseOffset", "INTEGER"), new ColumnData("systemUndervoltageAlarmLevel", "INTEGER")};

    protected PowerSupplyFroDataConverter() {
        super("PowerSupplyFroDataConverter");
    }

    public static CommonSupportSystemFroDataConverter instance() {
        return INSTANCE;
    }

    protected ColumnData[] getColumnData() {
        return this.columnData;
    }

    protected String getTypeName() {
        return "PowerSupplySystem";
    }

    protected Object[] getTableData(ManagedObject nextMo, Coordinator c) throws MoAccessException {
        PowerSupplySystemMo pss = (PowerSupplySystemMo)nextMo;
        String ldn = "ManagedElement=1,EquipmentSupportFunction=1,PowerSupply=" + pss.getNamingAttributeValue();
        return new Object[]{new Integer(this.nextFroId()), ldn, new Integer(-545), new Integer(pss.getSystemOvervoltageAlarmCeaseOffset(c)), new Integer(pss.getSystemOvervoltageAlarmLevel(c)), new Integer(pss.getSystemUndervoltageAlarmCeaseOffset(c)), new Integer(pss.getSystemUndervoltageAlarmLevel(c))};
    }

    protected void createNewMoData(MoData ignored, String ldn, int froId, Coordinator c) throws MoAccessException {
        MoData newModata = new MoData(ldn, this.getNewTypeName(), true, c);
        newModata.handleTransaction(c, MoData.WRITE_ACCESS);
        newModata.registerPersistentAttr((Attribute)new StringAttribute("userLabel", false, ""));
        newModata.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, froId));
        newModata.setRevision(8010001);
    }

    protected ApcFroAttributes[] getApcFroAttributesData() {
        int froType = this.getFroType();
        return new ApcFroAttributes[]{new ApcFroAttributes(froType, "nominalVoltage", "S32"), new ApcFroAttributes(froType, "systemOvervoltageAlarmCeaseOffset", "S32"), new ApcFroAttributes(froType, "systemOvervoltageAlarmLevel", "S32"), new ApcFroAttributes(froType, "systemUndervoltageAlarmCeaseOffset", "S32"), new ApcFroAttributes(froType, "systemUndervoltageAlarmLevel", "S32")};
    }

    protected String getNewTypeName() {
        return "PowerSupply";
    }
}

