/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.AttributeHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class RenameAttributeOp
implements Command {
    private final Coordinator context;
    private final WorkingMoData workingMoData;
    private final String moTypeName;
    private final int newRev;
    private final String oldAttrName;
    private final String newAttrName;

    public RenameAttributeOp(WorkingMoData workingMoData, String moTypeName, int newRev, String oldAttrName, String newAttrName, Coordinator context) {
        this.workingMoData = workingMoData;
        this.moTypeName = moTypeName;
        this.newRev = newRev;
        this.oldAttrName = oldAttrName;
        this.newAttrName = newAttrName;
        this.context = context;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.moTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, this.getClass(), (String)(this.moTypeName + " MO not found in Working Data."));
            return;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            MoDataHelper.activateWriteAccess(this.context, tmpMoData);
            Attribute oldAttr = tmpMoData.getAttribute(this.oldAttrName);
            Attribute newAttr = tmpMoData.getAttribute(this.newAttrName);
            if (oldAttr == null) {
                if (newAttr == null) {
                    MessageLog.traceError(this.getClass(), (String)("None of the attributes " + this.oldAttrName + " and " + this.newAttrName + " exist in the  Mo:" + tmpMoData.getLocalDistinguishedName()));
                    throw new MoDataConversionException("None of the attributes " + this.oldAttrName + " and " + this.newAttrName + " exist in the  Mo:" + tmpMoData.getLocalDistinguishedName());
                }
                MessageLog.trace((int)9, this.getClass(), (String)("Attribute " + this.oldAttrName + " not found. It may " + "already have been renamed. Mo:" + tmpMoData.getLocalDistinguishedName()));
                continue;
            }
            newAttr = AttributeHelper.renameAttribute(oldAttr, this.newAttrName);
            if (newAttr != null) {
                tmpMoData.deregisterAttribute(oldAttr);
                tmpMoData.registerPersistentAttr(newAttr);
                tmpMoData.setRevision(this.newRev);
                continue;
            }
            MessageLog.traceError(this.getClass(), (String)("Unsupported attribute type: " + oldAttr.getClass().getName()));
            throw new MoDataConversionException("Unsupported attribute type: " + oldAttr.getClass().getName());
        }
    }
}

