/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.Serializable;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;

public class FloatAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 0L;
    private transient float myBackup;
    private float myValue;
    private transient boolean myIsTransactionActive = false;

    public FloatAttribute(String name, boolean isAttrValueChangeNotifier) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = 0.0f;
    }

    public FloatAttribute(String name, String attrData) {
        super(name, attrData.charAt(1));
        this.myValue = Float.valueOf(attrData.substring(2)).floatValue();
    }

    public FloatAttribute(String name, boolean isAttrValueChangeNotifier, float initialValue) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = initialValue;
    }

    public synchronized float getValue(Coordinator c) {
        if (c == null && this.myIsTransactionActive) {
            return this.myBackup;
        }
        return this.myValue;
    }

    public synchronized void setValue(float aValue) {
        this.myValue = aValue;
    }

    public synchronized void setValue(Float aValue) {
        this.myValue = aValue.floatValue();
    }

    synchronized void rollback() {
        this.myValue = this.myBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
        this.myIsTransactionActive = true;
    }

    Object getValueAsObject(Coordinator c) {
        return new Float(this.getValue(c));
    }

    boolean isModified() {
        return this.myValue != this.myBackup;
    }

    public String buildString() {
        String avc = "";
        avc = this.isAVCNotifier() ? "T" : "F";
        return this.getName() + "^f" + avc + Float.toString(this.myValue);
    }
}

