/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.Serializable;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.Const;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;

public class StringAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 0L;
    private String myValue;
    private transient String myBackup;

    public StringAttribute(String name, boolean isAttrValueChangeNotifier) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = "";
    }

    public StringAttribute(String name, boolean isAttrValueChangeNotifier, String initialValue) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = initialValue;
    }

    public StringAttribute(String name, String attrData) {
        super(name, attrData.charAt(1));
        this.myValue = attrData.substring(2);
    }

    public synchronized String getValue(Coordinator c) {
        if (c == null && this.myBackup != null) {
            return this.myBackup;
        }
        return this.myValue;
    }

    public synchronized void setValue(String aValue) {
        Const.callAssert(aValue);
        this.myValue = aValue;
    }

    synchronized void rollback() {
        this.myValue = this.myBackup == null ? "" : this.myBackup;
    }

    synchronized void commit() {
        this.myBackup = null;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
    }

    Object getValueAsObject(Coordinator c) {
        return this.getValue(c);
    }

    boolean isModified() {
        if (this.myBackup != null) {
            return !this.myValue.equals(this.myBackup);
        }
        return false;
    }

    public String buildString() {
        String avc = "";
        avc = this.isAVCNotifier() ? "T" : "F";
        return this.getName() + "^s" + avc + this.myValue;
    }
}

