/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.ecbus;

import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;

public class EcBusMaoImpl
extends GenericMao {
    private static final String EMPTY_STRING = "";
    private static final String AUX = "AUX";
    private static final String EC = "EC";
    private static final String MO_TYPE_AUX_PLUG_IN_UNIT = "AuxPlugInUnit";
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    private static final String MO_TYPE_PLUG_IN_UNIT = "PlugInUnit";
    private static final String MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String MO_TYPE_ECPORT = "EcPort";
    private static final String MO_TYPE_HW_UNIT = "HwUnit";
    private static final String MO_TYPE_EXTERNAL_NODE = "ExternalNode";
    private static final String ATTRIBUTE_CONNECTION_TYPE = "connectionType";
    private static final String ATTRIBUTE_EC_BUS_CONNECTOR_REF = "ecBusConnectorRef";
    private static final String ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF = "equipmentSupportFunctionRef";
    private static final String ATTRIBUTE_POSITION_REF = "positionRef";
    private static final String ATTRIBUTE_SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final Class THIS_CLASS = EcBusMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "EcBus";

    public EcBusMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EcBusMaoImpl() - constructor");
        int n2 = attrList.indexOf(ATTRIBUTE_EC_BUS_CONNECTOR_REF);
        this.validateEcBusConnectorRef((ManagedObject)attrList.getValue(n2));
        int n3 = attrList.indexOf(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF);
        ManagedObject managedObject2 = (ManagedObject)attrList.getValue(n3);
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        if (managedObject2 != null) {
            this.validateEquipmentSupportFunctionRef(managedObject2, coordinator);
        } else if (managedObject2 == null && moIterator.size() == 1) {
            this.setAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, moIterator.nextMo(), coordinator);
        } else {
            throw new SupportSystemConfigurationFailedException("EquipmentSupportFunctionRef is empty", "System is unable to determine which equipmentSupportFunctionRef.");
        }
        logger.traceReturn(THIS_CLASS, "EcBusMaoImpl() - constructor");
    }

    public EcBusMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "Constructor used at restore");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSet() -- " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_CONNECTION_TYPE)) {
            this.preSetConnectionType((String)object);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_EC_BUS_CONNECTOR_REF)) {
            this.preSetEcBusConnectorRef((ManagedObject)object);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF)) {
            object = this.preSetEquipmentSupportFunctionRef((ManagedObject)object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void preSetConnectionType(String string) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetConnectionType()");
        this.validateConnectionType(string);
        logger.traceReturn(THIS_CLASS, "preSetConnectionType()");
    }

    private void preSetEcBusConnectorRef(ManagedObject managedObject) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetEcBusConnectorRef()");
        this.validateEcBusConnectorRef(managedObject);
        logger.traceReturn(THIS_CLASS, "preSetEcBusConnectorRef()");
    }

    private Object preSetEquipmentSupportFunctionRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetEquipmentSupportFunctionRef()");
        managedObject = this.validateEquipmentSupportFunctionRef(managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "preSetEquipmentSupportFunctionRef()");
        return managedObject;
    }

    private void validateEcBusConnectorRef(ManagedObject managedObject) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateEcBusConnectorRef()");
        if (!managedObject.getType().equals(MO_TYPE_PLUG_IN_UNIT) && !managedObject.getType().equals(MO_TYPE_AUX_PLUG_IN_UNIT)) {
            logger.traceGeneral(THIS_CLASS, "Attribute ecBusConnectorRef can only refer to MO of type PlugInUnit or AuxPlugInUnit.");
            throw new ValueOutOfRangeException(ATTRIBUTE_EC_BUS_CONNECTOR_REF, MO_TYPE, "Attribute ecBusConnectorRef can only refer to MO of type PlugInUnit or AuxPlugInUnit.");
        }
        logger.traceReturn(THIS_CLASS, "validateEcBusConnectorRef()");
    }

    private void validateConnectionType(String string) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateConnectionType()");
        if (!(string.equals(EC) || string.equals(AUX) || string.equals(EMPTY_STRING))) {
            logger.traceGeneral(THIS_CLASS, "Only values \"EC\" \"AUX\" and \"\" are currently allowed.");
            throw new ValueOutOfRangeException(ATTRIBUTE_CONNECTION_TYPE, MO_TYPE, "Only values \"EC\" \"AUX\" and \"\" are currently allowed.");
        }
        logger.traceReturn(THIS_CLASS, "validateConnectionType()");
    }

    private ManagedObject validateEquipmentSupportFunctionRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateEquipmentSupportFunctionRef()");
        ManagedObject managedObject2 = this.getEsfRefByChain(coordinator);
        if (managedObject != null) {
            if (!managedObject.getType().equals(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION)) {
                logger.traceGeneral(THIS_CLASS, "Attribute equipmentSupportFunctionRef can only refer to MO of type EquipmentSupportFunction.");
                throw new ValueOutOfRangeException(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, MO_TYPE, "Attribute equipmentSupportFunctionRef can only refer to MO of type EquipmentSupportFunction.");
            }
            ManagedObject[] managedObjectArray = (ManagedObject[])this.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                Boolean bl;
                if (!managedObjectArray[i].getType().equals(MO_TYPE_ECPORT) || !managedObjectArray[i].getParent().getType().equals(MO_TYPE_AUX_PLUG_IN_UNIT) || !(bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator)).equals(Boolean.TRUE)) continue;
                throw new SupportSystemConfigurationFailedException("Faulty EquipmentSupportFunction ref to AuxPlugInUnit ", "EcPort under AuxPlugInUnit should refer an EquipmentSupportFunction with supportSystemControl false");
            }
            if (managedObject2 != null && managedObject != managedObject2) {
                throw new SupportSystemConfigurationFailedException("Faulty equipmentSupportFunctionRef", "No valid reference chain to EquipmentSupportFunction.");
            }
        } else {
            if (managedObject2 == null) {
                throw new SupportSystemConfigurationFailedException("Faulty EquipmentSupportFunctionRef", "EquipmentSupportFunctionRef is empty.");
            }
            return managedObject2;
        }
        logger.traceReturn(THIS_CLASS, "validateEquipmentSupportFunctionRef()");
        return managedObject;
    }

    private ManagedObject getEsfRefByChain(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getEsfRefByChain()");
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        if (moIterator.size() == 1) {
            return moIterator.nextMo();
        }
        if (moIterator.size() == 2) {
            ManagedObject[] managedObjectArray = (ManagedObject[])this.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ManagedObject managedObject;
                if (managedObjectArray[i].getType().equals(MO_TYPE_ECPORT) && managedObjectArray[i].getParent().getType().equals(MO_TYPE_HW_UNIT) && managedObjectArray[i].getParent().getAttribute(ATTRIBUTE_POSITION_REF, coordinator) != null) {
                    managedObject = (ManagedObject)managedObjectArray[i].getParent().getAttribute(ATTRIBUTE_POSITION_REF, coordinator);
                    ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObject.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
                    for (int j = 0; j < managedObjectArray2.length; ++j) {
                        if (!managedObjectArray2[j].getParent().getType().equals(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION)) continue;
                        return managedObjectArray2[j].getParent();
                    }
                    continue;
                }
                if (!managedObjectArray[i].getType().equals(MO_TYPE_ECPORT) || !managedObjectArray[i].getParent().getType().equals(MO_TYPE_EXTERNAL_NODE)) continue;
                managedObject = (ManagedObject)managedObjectArray[i].getParent().getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator);
                return managedObject;
            }
        }
        logger.traceReturn(THIS_CLASS, "getEsfRefByChain()");
        return null;
    }
}

