/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omfapplication;

import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;

public class PmAttributeHandler
implements PmAttribute {
    private static final Class THIS_CLASS = PmAttributeHandler.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public int[][] getCounterValues(String string, String[] stringArray) throws ResourceUnavailableException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "getCounterValues()");
        int[][] nArray = null;
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        PmAttribute pmAttribute = (PmAttribute)serviceRepository.getService(PmAttribute.class);
        if (pmAttribute == null) {
            throw new ResourceUnavailableException("PmAttribute", "Service not available");
        }
        try {
            logger.traceDebug(this.getClass(), "Fetch instant counters for MO: " + string);
            nArray = pmAttribute.getCounterValues(string, stringArray);
        }
        catch (ProcessingFailureException processingFailureException) {
            throw new ProcessingFailureException(processingFailureException.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "getCounterValues()");
        return nArray;
    }
}

