/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure;

import java.io.IOException;

public class PowerSystemData {
    public final transient String batteryInstallationDate;
    public final transient int batteryType;
    public final transient boolean sharedBattery;
    public final transient int minimumBackupTime;
    public final transient int minimumStateOfHealth;
    public final transient int testMode;
    public final transient int testStartDay;
    public final transient String testStartTime;
    public final transient int[] testStartMonths;
    public final transient boolean multiplePowerSystem;
    public final transient int noOfPsu;
    public final transient int noOfPdu;
    public final transient int noOfBfu;
    public final transient int noOfBpa;
    public final transient String controlDomainRef;
    public final transient String powerSystemId;
    public final transient String parentEsf;

    public PowerSystemData(String string, String string2, boolean bl, int n, int n2, String string3, int n3, String string4, String[] stringArray, boolean bl2, int n4, int n5, int n6, int n7, String string5) throws IOException {
        this.batteryInstallationDate = string;
        this.batteryType = this.convertBatteryType(string2);
        this.sharedBattery = bl;
        this.minimumBackupTime = n;
        this.minimumStateOfHealth = n2;
        this.testMode = this.convertTestMode(string3);
        this.testStartDay = n3;
        this.testStartTime = string4;
        this.testStartMonths = this.getStartMonths(stringArray);
        this.multiplePowerSystem = bl2;
        this.noOfPsu = n4;
        this.noOfPdu = n5;
        this.noOfBfu = n6;
        this.noOfBpa = n7;
        this.parentEsf = string5;
        this.controlDomainRef = null;
        this.powerSystemId = null;
    }

    public PowerSystemData(String string, String string2, boolean bl, int n, int n2, String string3, int n3, String string4, String[] stringArray, boolean bl2, String string5, String string6, String string7) throws IOException {
        this.batteryInstallationDate = string;
        this.batteryType = this.convertBatteryType(string2);
        this.sharedBattery = bl;
        this.minimumBackupTime = n;
        this.minimumStateOfHealth = n2;
        this.testMode = this.convertTestMode(string3);
        this.testStartDay = n3;
        this.testStartTime = string4;
        this.testStartMonths = this.getStartMonths(stringArray);
        this.multiplePowerSystem = bl2;
        this.noOfPsu = 1;
        this.noOfPdu = 1;
        this.noOfBfu = 1;
        this.noOfBpa = 0;
        this.controlDomainRef = string5;
        this.powerSystemId = string6;
        this.parentEsf = string7;
    }

    public final int[] getStartMonths(String[] stringArray) throws IOException {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.convertMonth(stringArray[i]);
        }
        return nArray;
    }

    protected final int convertMonth(String string) throws IOException {
        int n = 3;
        if ("JANUARY".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("FEBRUARY".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("MARCH".equalsIgnoreCase(string)) {
            n = 3;
        } else if ("APRIL".equalsIgnoreCase(string)) {
            n = 4;
        } else if ("MAY".equalsIgnoreCase(string)) {
            n = 5;
        } else if ("JUNE".equalsIgnoreCase(string)) {
            n = 6;
        } else if ("JULY".equalsIgnoreCase(string)) {
            n = 7;
        } else if ("AUGUST".equalsIgnoreCase(string)) {
            n = 8;
        } else if ("SEPTEMBER".equalsIgnoreCase(string)) {
            n = 9;
        } else if ("OCTOBER".equalsIgnoreCase(string)) {
            n = 10;
        } else if ("NOVEMBER".equalsIgnoreCase(string)) {
            n = 11;
        } else if ("DECEMBER".equalsIgnoreCase(string)) {
            n = 12;
        } else {
            String string2 = "Invalid NPC Configuration file: The PowerSystem attribute testStartMonths was not recognized. (Input was " + string + ")";
            throw new IOException(string2);
        }
        return n;
    }

    protected final int convertBatteryType(String string) throws IOException {
        int n = 0;
        if ("TYPE01".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("TYPE02".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("UNKNOWN".equalsIgnoreCase(string) || "UNDEFINED".equalsIgnoreCase(string)) {
            n = 0;
        } else {
            String string2 = "Invalid NPC Configuration file: The PowerSystem attribute batteryType was not recognized. (Input was " + string + ")";
            throw new IOException(string2);
        }
        return n;
    }

    protected final int convertTestMode(String string) throws IOException {
        int n = 2;
        if ("AUTOMATIC".equalsIgnoreCase(string)) {
            n = 0;
        } else if ("CONFIGURED".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("DISABLED".equalsIgnoreCase(string)) {
            n = 2;
        } else {
            String string2 = "Invalid NPC Configuration file: The PowerSystem attribute testMode was not recognized. (Input was " + string + ")";
            throw new IOException(string2);
        }
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "PowerSystemData: " + string;
        string2 = string2 + "batteryInstallationDate = " + this.batteryInstallationDate + string;
        string2 = string2 + "batteryType = " + this.batteryType + string;
        string2 = string2 + "sharedBattery = " + this.sharedBattery + string;
        string2 = string2 + "minimumBackupTime = " + this.minimumBackupTime + string;
        string2 = string2 + "minimumStateOfHealth = " + this.minimumStateOfHealth + string;
        string2 = string2 + "testMode = " + this.testMode + string;
        string2 = string2 + "testStartDay = " + this.testStartDay + string;
        string2 = string2 + "testStartTime = " + this.testStartTime + string;
        string2 = string2 + "multiplePowerSystem = " + this.multiplePowerSystem + string;
        string2 = string2 + "testStartMonths[]: " + string;
        for (int i = 0; i < this.testStartMonths.length; ++i) {
            string2 = string2 + this.testStartMonths[i] + " ";
        }
        string2 = string2 + string;
        string2 = string2 + "noOfPsu = " + this.noOfPsu + string;
        string2 = string2 + "noOfPdu = " + this.noOfPdu + string;
        string2 = string2 + "noOfBfu = " + this.noOfBfu + string;
        string2 = string2 + "noOfBpa = " + this.noOfBpa + string;
        string2 = string2 + "controlDomainRef = " + this.controlDomainRef + string;
        string2 = string2 + "parentEsf = " + this.parentEsf + string;
        string2 = string2 + "~PowerSystemData" + string;
        return string2;
    }
}

