/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class BatteryBackupHelper {
    private static final Class THIS_CLASS = BatteryBackupHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient MoRepositoryWrapper aMoRepository;
    private final transient MoFactoryMgrWrapper aFactoryMgr;
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";

    public BatteryBackupHelper(GenericMaoContext genericMaoContext) {
        logger.traceEnter(THIS_CLASS, "BatteryBackupHelper() - Constructor");
        this.aMoRepository = genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = genericMaoContext.getMoFactoryMgrWrapper();
        logger.traceReturn(THIS_CLASS, "BatteryBackupHelper() - Constructor");
    }

    public ManagedObject getBatteryBackupCorrespondingPowerDistribution(ManagedObject managedObject, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "getBatteryBackupCorrespondingPowerDistribution()");
        MoIterator moIterator = this.aMoRepository.lookupType("Cabinet");
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            try {
                ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    if (!managedObjectArray[i].getLocalDistinguishedName().equalsIgnoreCase(managedObject.getLocalDistinguishedName())) continue;
                    for (int j = 0; j < managedObjectArray.length; ++j) {
                        if (managedObjectArray[j].getLocalDistinguishedName().toLowerCase().indexOf(",powerdistribution=") <= 0) continue;
                        MoIterator moIterator2 = this.aMoRepository.lookupType("PowerDistribution");
                        ManagedObject managedObject3 = null;
                        while (moIterator2 != null && moIterator2.hasMoreElements()) {
                            managedObject3 = moIterator2.nextMo();
                            if (!managedObject3.getLocalDistinguishedName().equalsIgnoreCase(managedObjectArray[j].getLocalDistinguishedName())) continue;
                            logger.traceReturn(THIS_CLASS, "getBatteryBackupCorrespondingPowerDistribution() returning powerDistributionMO");
                            return managedObject3;
                        }
                    }
                }
            }
            catch (MoAccessException moAccessException) {
                logger.traceDebug(THIS_CLASS, "Problem (1) to get attribute controlDomainRef, " + moAccessException.getMessage());
            }
            catch (Exception exception) {
                logger.traceDebug(THIS_CLASS, "Problem (2) to get attribute controlDomainRef, " + exception.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "getBatteryBackupCorrespondingPowerDistribution() returning null");
        return null;
    }
}

