/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.security.SecurityMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.security.cppsec.esa.NodeSecurityHandler;
import se.ericsson.security.cppsec.esa.SecmodeExecutor;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.logger.EsaMessageSender;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.IpAddress;
import se.ericsson.security.cppsec.esa.model.Level2Data;
import se.ericsson.security.cppsec.esa.model.Level3Data;
import se.ericsson.security.cppsec.esa.model.LogonServerAddress;
import se.ericsson.security.cppsec.esa.model.SecurityData;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;
import se.ericsson.security.cppsec.esa.wrapper.MoRepositoryWrapperFactory;
import se.ericsson.security.cppsec.esa.wrapper.TransactionHelper;

public class NodeSecurityHandlerImpl
implements NodeSecurityHandler {
    private final int DEFAULT_RETRY_COUNT;
    private final int DEFAULT_SLEEP_TIME;
    protected int enrollmentTimeLimit = 120000;
    protected int installLocalAADTimeout = 300000;
    protected int installTrustedCertsTimeout = 300000;
    private static final String SECURITY_MO_LDN = "ManagedElement=1,SystemFunctions=1,Security=1";
    private static final String MANAGED_ELEMENT_DATA_MO_LDN = "ManagedElement=1,ManagedElementData=1";
    private final SecurityMo securityMo;
    private final ManagedElementDataMo managedElementDataMo;
    private final MessageLogWrapper logger = MessageLogWrapperFactory.getLogger(this.getClass());
    protected final EsaReportLogger reportLogger = EsaReportLogger.getInstance();
    protected String username = "";
    private static final String NODE_PASSWORD = "x";
    private final EsaMessageSender messageSender;

    protected NodeSecurityHandlerImpl(EsaMessageSender esaMessageSender) {
        this.securityMo = (SecurityMo)MoRepositoryWrapperFactory.getMoRepositoryWrapper().lookup(SECURITY_MO_LDN);
        this.managedElementDataMo = (ManagedElementDataMo)MoRepositoryWrapperFactory.getMoRepositoryWrapper().lookup(MANAGED_ELEMENT_DATA_MO_LDN);
        this.messageSender = esaMessageSender;
        this.DEFAULT_SLEEP_TIME = EsaConstantsFactory.getEsaConstants().getDefaultSleepTime();
        this.DEFAULT_RETRY_COUNT = EsaConstantsFactory.getEsaConstants().getDefaultRetryCount();
    }

    public void activateSecurityLevel2() throws SecurityActivationException {
        int n;
        this.messageSender.sendMessage("Activating security level 2.");
        this.reportLogger.logMessage("SEC: Activating security level 2.");
        try {
            n = this.securityMo.getOperationalSecurityLevel(null);
            int n2 = this.securityMo.getRequestedSecurityLevel(null);
            if (n != n2 && n < 3) {
                SecmodeExecutor.adaptSecurityLevel();
            }
            this.reportLogger.closeLog();
            SecmodeExecutor.executeLevel(2);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("Could not activate security level 2.", moAccessException);
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("Could not activate security level 2.", securityActivationException);
        }
        n = this.adaptAndGetCurrentSecurityLevel();
        if (n != 2) {
            throw new SecurityActivationException("Could not activate security level 2.");
        }
        this.messageSender.sendMessage("Activated security level 2.");
        this.reportLogger.logMessage("SEC: Activated security level 2.");
    }

    public void activateSecurityLevel3(int n) throws SecurityActivationException {
        this.messageSender.sendMessage("Activating security level 3.");
        this.reportLogger.logMessage("SEC: Activating security level 3.");
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        try {
            this.securityMo.actionSetSecurityLevel3(n, coordinator);
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Could not activate security level 3.", moAccessException);
        }
        this.messageSender.sendMessage("Activated security level 3.");
        this.reportLogger.logMessage("SEC: Activated security level 3.");
    }

    public void clearPreviousSecurityConfiguration() throws SecurityActivationException {
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        try {
            this.reportLogger.logMessage("SEC: Cancelling actions");
            this.securityMo.actionCancelInstallTrustedCertificates(coordinator);
            this.securityMo.actionCancelInstallLocalAADatabase(coordinator);
            TransactionHelper.commit(control);
            this.reportLogger.logMessage("SEC: Removing installed certificates and AA servers");
            this.clearPreviousTrustedCertificates();
            control = TransactionHelper.create();
            coordinator = control.getCoordinator();
            this.clearPreviousAaServers(coordinator);
            this.reportLogger.logMessage("SEC: Setting default values.");
            this.setDefaultValues(coordinator);
            TransactionHelper.commit(control);
        }
        catch (SecurityActivationException securityActivationException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Unable to clear already existing security configuration.", securityActivationException);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Unable to clear already existing security configuration.", moAccessException);
        }
    }

    private void clearPreviousTrustedCertificates() throws SecurityActivationException {
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        try {
            Struct[] structArray = this.securityMo.getInstalledTrustedCertificates(coordinator);
            TransactionHelper.commit(control);
            if (structArray.length != 0) {
                this.reportLogger.logMessage("SEC: Removing previously installed trusted certificates");
                for (int i = 0; i < structArray.length; ++i) {
                    if ((Integer)structArray[i].getValue("category") == 3 || (Integer)structArray[i].getValue("category") == 6) continue;
                    String string = (String)structArray[i].getValue("serialNumber");
                    String string2 = (String)structArray[i].getValue("issuer");
                    int n = (Integer)structArray[i].getValue("category");
                    this.reportLogger.logMessage("SEC: Removing cert with serial: " + string + " and category: " + n + " by issuer: " + string2);
                    control = TransactionHelper.create();
                    coordinator = control.getCoordinator();
                    this.securityMo.actionRemoveTrustedCert(string, string2, n, coordinator);
                    TransactionHelper.commit(control);
                }
            }
            control = TransactionHelper.create();
            coordinator = control.getCoordinator();
            Struct[] structArray2 = this.securityMo.getInstalledTrustedCertificates(coordinator);
            int n = 0;
            while (structArray2.length > 7) {
                try {
                    Thread.sleep(this.DEFAULT_SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {
                    TransactionHelper.rollback(control);
                    this.reportLogger.logMessage("SEC: Interrupted while waiting for installed trusted certs to be removed.");
                }
                if (n++ > this.DEFAULT_RETRY_COUNT) {
                    throw new SecurityActivationException("Unable to remove previously installed trusted certificates!");
                }
                structArray2 = this.securityMo.getInstalledTrustedCertificates(coordinator);
            }
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Unable to remove previously installed trusted certificates!", moAccessException);
        }
    }

    void clearPreviousAaServers(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = this.getAndFilterAaServers(coordinator);
        if (stringArray.length != 0) {
            this.reportLogger.logMessage("Removing previously configured AA servers");
            String string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + ", " + stringArray[i];
            }
            this.reportLogger.logMessage("Removing old AA servers: " + string);
            this.securityMo.actionRemoveAAServerAddresses(stringArray, coordinator);
        }
    }

    private String[] getAndFilterAaServers(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = this.securityMo.getAAServerIPAddressList(coordinator);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if ("0.0.0.0".equals(stringArray[i]) || "".equals(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    protected void setDefaultValues(Coordinator coordinator) throws MoAccessException {
        this.managedElementDataMo.setLogonServerAddress("", coordinator);
        this.securityMo.setAuthorizationCacheTimeOut(60, coordinator);
        this.securityMo.setCertExpirWarnTime(90, coordinator);
        this.securityMo.setLocalAADatabaseInstallationFailure(false, coordinator);
        this.securityMo.setTrustedCertificateInstallationFailure(false, coordinator);
        this.securityMo.setUserLabel("", coordinator);
        this.securityMo.setAutoUpdateCertEnrollmentServer("", coordinator);
    }

    public int adaptAndGetCurrentSecurityLevel() throws SecurityActivationException {
        int n = 1;
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        try {
            n = this.adaptAndGetCurrentSecurityLevel(coordinator);
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Unable to clear already existing security configuration.", moAccessException);
        }
        return n;
    }

    protected int adaptAndGetCurrentSecurityLevel(Coordinator coordinator) throws MoAccessException {
        this.securityMo.actionAdaptSecurityLevel(coordinator);
        return this.securityMo.getOperationalSecurityLevel(coordinator);
    }

    public void setSecurityLevel1() throws SecurityActivationException {
        int n;
        this.messageSender.sendMessage("Setting security Level 1.");
        try {
            n = this.securityMo.getOperationalSecurityLevel(null);
            int n2 = this.securityMo.getRequestedSecurityLevel(null);
            if (n != n2 && n < 3) {
                SecmodeExecutor.adaptSecurityLevel();
            }
            SecmodeExecutor.executeLevel(1);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("Failed to set security Level 1. This needs to be externally corrected!", moAccessException);
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("Failed to set security Level 1. This needs to be externally corrected!", securityActivationException);
        }
        n = this.adaptAndGetCurrentSecurityLevel();
        if (n != 1) {
            throw new SecurityActivationException("Failed to set security Level 1. This needs to be externally corrected!");
        }
        this.messageSender.sendMessage("Security level 1 has been set.");
    }

    public void initiateCertificateEnrollment(Struct struct) throws SecurityActivationException {
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        this.reportLogger.logMessage("calling action 'InitCertEnrollment' on Security MO");
        try {
            this.securityMo.actionInitCertEnrollment(struct, coordinator);
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            try {
                this.securityMo.actionCancelCertEnrollment(coordinator);
                TransactionHelper.commit(control);
            }
            catch (MoAccessException moAccessException2) {
                TransactionHelper.rollback(control);
                throw new SecurityActivationException("Action InitCertEnrollment failed.", moAccessException2);
            }
            throw new SecurityActivationException("Action InitCertEnrollment failed.", moAccessException);
        }
    }

    public void installLocalAADatabase(String string, String string2, String string3, int n, Struct[] structArray) throws SecurityActivationException {
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        try {
            this.reportLogger.logMessage("Calling the action 'InstallLocalAADatabase' on the Security MO with authenticationFileName: " + string + " authorizationFileName: " + string2);
            this.securityMo.actionInstallLocalAADatabase(string, string2, string3, n, structArray, coordinator);
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Action 'InstallLocalAADatabase' failed.", moAccessException);
        }
    }

    public void installTrustedCertificates(Struct[] structArray, String string, int n, Struct[] structArray2) throws SecurityActivationException {
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        try {
            this.reportLogger.logMessage("Calling the action 'InstallTrustedCertificates' on the Security MO");
            this.securityMo.actionInstallTrustedCertificates(structArray, string, n, structArray2, coordinator);
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Action 'InstallTrustedCertificates' failed.", moAccessException);
        }
    }

    public void waitForCertEnrollment() throws SecurityActivationException {
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        boolean bl = true;
        int n = 0;
        try {
            int n2 = this.securityMo.getCertEnrollState(coordinator);
            this.reportLogger.logMessage("SEC: !!!!!! Waiting for Enrollment. Current state is: " + Integer.toString(n2) + "!!!!!!");
            while (0 != n2) {
                if (n > this.enrollmentTimeLimit) {
                    this.securityMo.actionCancelCertEnrollment(coordinator);
                    TransactionHelper.commit(control);
                    throw new SecurityActivationException("Certificate enrollment failed: The request timed out");
                }
                if (bl) {
                    this.messageSender.sendMessage("Waiting for the certificate enrollment to complete.");
                    this.reportLogger.logMessage("SEC: Waiting for the certificate enrollment to complete.");
                    bl = false;
                }
                if (4 == n2) {
                    String string = this.securityMo.getCertEnrollErrorMsg(coordinator);
                    this.messageSender.sendMessage("Cancelling certificate enrollment due to failure.");
                    this.securityMo.actionCancelCertEnrollment(coordinator);
                    TransactionHelper.commit(control);
                    throw new SecurityActivationException("Certificate enrollment failed: " + string);
                }
                try {
                    Thread.sleep(this.DEFAULT_SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n += this.DEFAULT_SLEEP_TIME;
                n2 = this.securityMo.getCertEnrollState(coordinator);
                this.reportLogger.logMessage("SEC: Waiting for CertificateEnrollment to finish, current state: " + n2);
            }
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Failed to verify successful certificate enrollment", moAccessException);
        }
    }

    public void waitForInstallLocalAADatabase() throws SecurityActivationException {
        this.messageSender.sendMessage("Waiting for installation of Local AA Database to complete.");
        this.reportLogger.logMessage("SEC: Waiting for installation of Local AA Database to complete.");
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        int n = 0;
        try {
            boolean bl = true;
            while ("".equals(this.securityMo.getLocalAuthenticationFileVersion(coordinator)) || "".equals(this.securityMo.getLocalAuthorizationFileVersion(coordinator))) {
                if (n > this.installLocalAADTimeout) {
                    this.messageSender.sendMessage("Cancelling installation of Local AA Database due to failure.");
                    this.securityMo.actionCancelInstallLocalAADatabase(coordinator);
                    TransactionHelper.commit(control);
                    throw new SecurityActivationException("Action 'InstallLocalAADatabase' failed.The request timed out");
                }
                if (bl) {
                    this.reportLogger.logMessage("Waiting for LAAD installation to finish.");
                    bl = false;
                }
                if (this.securityMo.getLocalAADatabaseInstallationFailure(coordinator)) {
                    this.messageSender.sendMessage("Cancelling installation of Local AA Database due to failure.");
                    this.securityMo.actionCancelInstallLocalAADatabase(coordinator);
                    TransactionHelper.commit(control);
                    throw new SecurityActivationException("Action 'InstallLocalAADatabase' failed.");
                }
                try {
                    Thread.sleep(this.DEFAULT_SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n += this.DEFAULT_SLEEP_TIME;
            }
            if (this.securityMo.getLocalAADatabaseInstallationFailure(coordinator)) {
                this.messageSender.sendMessage("Cancelling installation of Local AA Database due to failure.");
                this.securityMo.actionCancelInstallLocalAADatabase(coordinator);
                TransactionHelper.commit(control);
                throw new SecurityActivationException("Action 'InstallLocalAADatabase' failed.");
            }
            this.messageSender.sendMessage("Local AA Database successfully installed.");
            this.reportLogger.logMessage("SEC: Local AA Database successfully installed.");
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Action 'InstallLocalAADatabase' failed.", moAccessException);
        }
    }

    public void waitForInstallTrustedCerts(int n) throws SecurityActivationException {
        this.messageSender.sendMessage("Waiting for installation of trusted certificates to complete.");
        this.reportLogger.logMessage("SEC: Waiting for installation of trusted certificates to complete.");
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        int n2 = 0;
        try {
            Struct[] structArray = this.securityMo.getInstalledTrustedCertificates(coordinator);
            boolean bl = true;
            while (structArray.length < n) {
                if (n2 > this.installTrustedCertsTimeout) {
                    this.messageSender.sendMessage("Cancelling installation of trusted certificates due to failure.");
                    this.securityMo.actionCancelInstallTrustedCertificates(coordinator);
                    TransactionHelper.commit(control);
                    throw new SecurityActivationException("Action 'InstallTrustedCertificates' failed.The request timed out");
                }
                if (bl) {
                    this.reportLogger.logMessage("SEC: Waiting for installation of trusted certificates to finish. Expecting " + n + " certs and have " + structArray.length);
                    bl = false;
                }
                if (this.securityMo.getTrustedCertificateInstallationFailure(coordinator)) {
                    this.messageSender.sendMessage("Cancelling installation of trusted certificates due to failure.");
                    this.securityMo.actionCancelInstallTrustedCertificates(coordinator);
                    TransactionHelper.commit(control);
                    throw new SecurityActivationException("Action 'InstallTrustedCertificates' failed.");
                }
                try {
                    Thread.sleep(this.DEFAULT_SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n2 += this.DEFAULT_SLEEP_TIME;
                structArray = this.securityMo.getInstalledTrustedCertificates(coordinator);
            }
            if (this.securityMo.getTrustedCertificateInstallationFailure(coordinator)) {
                this.messageSender.sendMessage("Cancelling installation of trusted certificates due to failure.");
                this.securityMo.actionCancelInstallTrustedCertificates(coordinator);
                TransactionHelper.commit(control);
                throw new SecurityActivationException("Action 'InstallTrustedCertificates' failed.");
            }
            this.messageSender.sendMessage("Trusted Certs succesfully installed");
            this.reportLogger.logMessage("SEC: Trusted Certs succesfully installed");
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("Action 'InstallTrustedCertificates' failed.", moAccessException);
        }
    }

    public void setSecurityMoAttributes(SecurityData securityData) throws SecurityActivationException, SecurityActivationInputException {
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        try {
            Object object;
            this.setSecMoUserLabel(securityData.getUserLabel(), coordinator);
            Level2Data level2Data = securityData.getLevel2Data();
            Level3Data level3Data = securityData.getLevel3Data();
            if (level2Data != null) {
                object = level2Data.getLevel2Configuration();
                this.setSlsUrlList(object.getLogonServerAddresses(), coordinator);
                this.setSecMoCertExpirWarnTime(object.getCertExpirWarnTime(), coordinator);
                this.setSecMoAutoUpdateCertEnrollmentData(object.getAutoUpdateCertEnrollmentServer(), coordinator);
            }
            if (level3Data != null) {
                object = level3Data.getLevel3Configuration();
                this.setSecMoAuthorizationCacheTimeout(object.getAuthorizationCacheTimeout(), coordinator);
                this.setSecMoAaServerIpAddressList(object.getAAServerIpAddressList(), coordinator);
            }
            TransactionHelper.commit(control);
        }
        catch (SecurityActivationException securityActivationException) {
            TransactionHelper.rollback(control);
            throw securityActivationException;
        }
        catch (SecurityActivationInputException securityActivationInputException) {
            TransactionHelper.rollback(control);
            throw securityActivationInputException;
        }
    }

    protected void setSlsUrlList(List list, Coordinator coordinator) throws SecurityActivationException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(((LogonServerAddress)iterator.next()).getLogonServerAddress());
                while (iterator.hasNext()) {
                    stringBuffer.append(',').append(((LogonServerAddress)iterator.next()).getLogonServerAddress());
                }
            }
            this.messageSender.sendMessage("Setting attribute 'logonServerAddress' on ManagedElementData MO: " + stringBuffer.toString());
            this.managedElementDataMo.setLogonServerAddress(stringBuffer.toString(), coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("The attribute 'logonServerAddress' om MO ManagedElementData could not be set", moAccessException);
        }
    }

    public void setSecModeFileTransferClient(String string) throws SecurityActivationException {
        try {
            int n = this.securityMo.getFileTransferClientMode(null);
            if (n == 0 && "Secure".equalsIgnoreCase(string) || n == 1 && "Unsecure".equalsIgnoreCase(string)) {
                SecmodeExecutor.executeFileTransferClient(string);
            }
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("Unable to set mode of File Transfere Client.", moAccessException);
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("Unable to set mode of File Transfere Client.", securityActivationException);
        }
    }

    protected void setSecMoAaServerIpAddressList(List list, Coordinator coordinator) throws SecurityActivationInputException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            arrayList.add(((IpAddress)iterator.next()).getIpAddress());
            while (iterator.hasNext()) {
                arrayList.add(((IpAddress)iterator.next()).getIpAddress());
            }
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.messageSender.sendMessage("Setting attribute 'aAServerIPAddressList' on Security MO: " + arrayList.toString());
        try {
            this.securityMo.actionAddAAServerAddresses(stringArray, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationInputException("Could not set addresses to AA servers.", moAccessException);
        }
    }

    protected void setSecMoAuthorizationCacheTimeout(int n, Coordinator coordinator) throws SecurityActivationInputException, SecurityActivationException {
        this.messageSender.sendMessage("Setting attribute 'authorizationCacheTimeOut' on Security MO: " + n);
        try {
            this.securityMo.setAuthorizationCacheTimeOut(n, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("The attribute 'authorizationCacheTimeOut' could not be set on the Security MO.", moAccessException);
        }
    }

    protected void setSecMoCertExpirWarnTime(int n, Coordinator coordinator) throws SecurityActivationInputException, SecurityActivationException {
        this.messageSender.sendMessage("Setting attribute 'certExpirWarnTime' on Security MO: " + n);
        try {
            try {
                this.securityMo.setCertExpirWarnTime(n, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new SecurityActivationException("The attribute 'certExpirWarnTime' could not be set on the Security MO.", moAccessException);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SecurityActivationInputException("The attribute 'certExpirWarnTime' could not be set on the Security MO due to invalid input.", numberFormatException);
        }
    }

    void setSecMoCertExpirWarnTime(String string, Coordinator coordinator) throws SecurityActivationInputException, SecurityActivationException {
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                this.setSecMoCertExpirWarnTime(n, coordinator);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SecurityActivationInputException("The attribute 'certExpirWarnTime' could not be set on the Security MO due to invalid input.", numberFormatException);
            }
        }
    }

    protected void setSecMoUserLabel(String string, Coordinator coordinator) throws SecurityActivationException {
        if (string != null) {
            this.messageSender.sendMessage("Setting attribute 'userLabel' on Security MO: " + string);
            try {
                this.securityMo.setUserLabel(string, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new SecurityActivationException("The attribute 'userLabel' could not be set on the Security MO", moAccessException);
            }
        }
    }

    protected void setSecMoAutoUpdateCertEnrollmentData(String string, Coordinator coordinator) throws SecurityActivationException {
        if (string != null) {
            this.messageSender.sendMessage("Setting attribute 'autoUpdateCertEnrollmentServer' on Security MO: " + string);
            try {
                this.securityMo.setAutoUpdateCertEnrollmentServer(string, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new SecurityActivationException("The attribute 'autoUpdateCertEnrollmentServer' could not be set on the Security MO", moAccessException);
            }
        }
    }

    public void shutdownFtpAndTelnet() throws SecurityActivationException {
        try {
            if (this.securityMo.getTelnetAndFTPServersActive(null)) {
                SecmodeExecutor.executeShutdownFtpAndTelnet();
                this.messageSender.sendMessage("Setting 'telnetAndFTPServersActive' to false on Security MO.");
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("Shutdown of Telnet and Ftp server failed.", securityActivationException);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("Shutdown of Telnet and Ftp server failed.", moAccessException);
        }
    }

    public void startFtpAndTelnet() throws SecurityActivationException {
        try {
            if (!this.securityMo.getTelnetAndFTPServersActive(null)) {
                SecmodeExecutor.executeStartFtpAndTelnet();
                this.messageSender.sendMessage("Setting 'telnetAndFTPServersActive' to true on Security MO.");
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("Start of Telnet and Ftp server failed.", securityActivationException);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("Start of Telnet and Ftp server failed.", moAccessException);
        }
    }

    public void startTargetMonitor() throws SecurityActivationException {
        try {
            if (!this.securityMo.getTargetMonitorPortActive(null)) {
                SecmodeExecutor.executeStartTargetMonitor();
                this.messageSender.sendMessage("Setting 'targetMonitorPortActive' to true on Security MO.");
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("Start of Target monitor failed.", securityActivationException);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("Start of Target monitor failed.", moAccessException);
        }
    }

    public void startDebugAndUDP() throws SecurityActivationException {
        try {
            if (!this.securityMo.getDebugPortsActive(null)) {
                SecmodeExecutor.executeStartDebugAndUDP();
                this.messageSender.sendMessage("Setting 'debugPortsActive' to true on Security MO.");
            }
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("Start of Debug and UDP failed.", securityActivationException);
        }
        catch (MoAccessException moAccessException) {
            throw new SecurityActivationException("Start of Debug and UDP failed.", moAccessException);
        }
    }

    public void verifyPreconditions() throws SecurityActivationException {
        if (this.securityMo == null) {
            throw new SecurityActivationException("The Security MO could not be found, activation not possible.");
        }
        if (this.managedElementDataMo == null) {
            throw new SecurityActivationException("The ManagedElementData MO could not be found, activation not possible.");
        }
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public void setEnrollmentTimeLimit(int n) {
        this.enrollmentTimeLimit = n * 1000;
    }

    public Struct getNodeCertInfo() throws SecurityActivationException {
        Struct struct;
        Control control = TransactionHelper.create();
        Coordinator coordinator = control.getCoordinator();
        try {
            struct = this.securityMo.getNodeCertificate(coordinator);
            TransactionHelper.commit(control);
        }
        catch (MoAccessException moAccessException) {
            TransactionHelper.rollback(control);
            throw new SecurityActivationException("could not fetch security Node certificate", moAccessException);
        }
        return struct;
    }
}

