/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.DataChallengePassword;
import se.ericsson.security.cppsec.esa.model.SecEnrollmentData;
import se.ericsson.security.cppsec.esa.model.elements.EnrollmentDataElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class SecEnrollmentDataElement
extends StackElement
implements SecEnrollmentData {
    private static final String ROLLBACK_TIMEOUT = "rollbackTimeout";
    public static final String SECENROLLMENTDATA = "secEnrollmentData";
    private String rollbackTimeout;
    private EnrollmentDataElement enrollmentData = null;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        EnrollmentDataElement enrollmentDataElement = null;
        if ("enrollmentData".equalsIgnoreCase(string2)) {
            enrollmentDataElement = new EnrollmentDataElement();
        }
        this.enrollmentData = enrollmentDataElement;
        return enrollmentDataElement;
    }

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.rollbackTimeout = super.getOptionalAttribute(attributes, ROLLBACK_TIMEOUT, "10");
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        try {
            int n = Integer.parseInt(this.rollbackTimeout);
            if (n < 0 || n > 240) {
                throw new SecurityActivationInputException("SecEnrollmentData attribute rollbackTimeout invalid value - " + this.rollbackTimeout);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SecurityActivationInputException("SecEnrollmentData attribute rollbackTimeout invalid value - " + this.rollbackTimeout, numberFormatException);
        }
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.enrollmentData == null) {
            throw new SecurityActivationInputException("The SecEnrollmentData element is not consistent - it must contain an EnrollmentData element");
        }
        this.enrollmentData.checkConsistency();
    }

    public Integer getRollbackTimeout() {
        return Integer.valueOf("0");
    }

    public String getCAFingerprint() {
        return this.enrollmentData.getCAFingerprint();
    }

    public DataChallengePassword getDataChallengePassword() {
        return this.enrollmentData.getDataChallengePassword();
    }

    public String getDistinguishedName() {
        return this.enrollmentData.getDistinguishedName();
    }

    public String getEnrollmentServerURL() {
        return this.enrollmentData.getEnrollmentServerURL();
    }

    public Integer getKeyLength() {
        return this.enrollmentData.getKeyLength();
    }

    public Integer getEnrollmentTimeLimit() {
        return this.enrollmentData.getEnrollmentTimeLimit();
    }

    public Integer getEnrollmentMode() {
        return this.enrollmentData.getEnrollmentMode();
    }

    public String getCertificateAuthorityDn() {
        return this.enrollmentData.getCertificateAuthorityDn();
    }
}

