/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class EsaDateHelper {
    private static String getCurrentDate() {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public static boolean isLaterThanNow(String string) {
        String string2 = EsaDateHelper.getCurrentDate();
        return string.compareTo(string2) < 0;
    }

    public static boolean checkDateAndTime(String string) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        if (string.length() == 1) {
            return false;
        }
        if (string.length() != 14) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6));
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = Integer.parseInt(string.substring(8, 10));
        int n5 = Integer.parseInt(string.substring(10, 12));
        int n6 = Integer.parseInt(string.substring(12, 14));
        if (n < 2009) {
            return false;
        }
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        if (n3 > 31 || n3 < 1) {
            return false;
        }
        if ((n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) && n3 > 30) {
            return false;
        }
        if (n2 == 2 && (gregorianCalendar.isLeapYear(n) ? n3 > 29 : n3 > 28)) {
            return false;
        }
        if (n4 > 23) {
            return false;
        }
        if (n5 > 59) {
            return false;
        }
        return n6 <= 59;
    }
}

