/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import [Lse.ericsson.cello.moframework.ManagedObject;;
import [Lse.ericsson.cello.moframework.Struct;;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.extethswitch.EthernetSwitchModulePortMo;
import se.ericsson.cello.extethswitch.StructEthModOperatingModeImpl;
import se.ericsson.cello.extethswitch.SwitchPortStpMo;
import se.ericsson.cello.extethswitch.SwitchPortStpMoFactory;
import se.ericsson.cello.extethswitch.SwitchPortStpMoImpl;
import se.ericsson.cello.extethswitch.exs_esmp_mi;
import se.ericsson.cello.extethswitch.mom.EnumRemoteFaultIndication;
import se.ericsson.cello.extethswitch.mom.EnumTrafficState;
import se.ericsson.cello.extethswitch.mom.Lag;
import se.ericsson.cello.extethswitch.mom.Vlan;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumAdmState;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public abstract class EthernetSwitchModulePortMoGen
extends CelloMao
implements EthernetSwitchModulePortMo {
    protected String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"portNo", "untaggedIngressPriority", "actualSpeedDuplex", "availabilityStatus", "operationalState", "administrativeState", "pbitQueueMap", "operatingMode", "externalPort", "egressUntagVlanRef", "vlanRef", "untaggedIngressVlanRef", "trafficState", "remoteFaultIndication", "vlanRefMembership", "VlanRefInformationPair", "EgressUntag", "esmFroId", "piuFroId"};
    protected String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"portNo", "untaggedIngressPriority", "administrativeState", "EthernetSwitchModulePortId", "pbitQueueMap", "operatingMode", "externalPort", "egressUntagVlanRef", "vlanRef", "untaggedIngressVlanRef", "userLabel", "trafficState", "lagRef", "remoteFaultIndication"};
    protected FroProxy froProxy = null;
    protected MoData data;
    protected static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new exs_esmp_mi());
    protected MaoFroIndicationHandler indHandler;
    Map myPmProxyFroIdMap = new HashMap(3);
    protected static final String FROID = "froId";
    protected static final int MO_DATA_REVISION_LATEST = 8000;

    private void checkMandatoryAttrs(AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        this.checkMandatoryAttribute("portNo", attrList);
    }

    private void checkMandatoryAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0 || attrList.getValue(n) == null) {
            throw new AttrMissingAtCreateException(string, "EthernetSwitchModulePort");
        }
    }

    protected EthernetSwitchModulePortMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, InitialMaoContext initialMaoContext, AttrList attrList, MaoFroIndicationHandler maoFroIndicationHandler, SwitchPortStpMoFactory switchPortStpMoFactory) throws MoAccessException {
        super(managedObject, "EthernetSwitchModulePort", string, coordinator, initialMaoContext);
        this.froProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        this.checkMandatoryAttrs(attrList);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("EthernetSwitchModulePort");
        setRequestContextImpl.assertAllowedAttributes(this.NON_READONLY_MOM_ATTRIBUTES, "EthernetSwitchModulePort");
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), "EthernetSwitchModulePort", true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("lagRef", true));
        this.data.setRevision(8000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"portNo", (AttrList)attrList, (Class)Integer.class, (String)"EthernetSwitchModulePort");
        int n2 = n;
        this.validatePortNo(n2, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("portNo", n2));
        Integer n3 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"untaggedIngressPriority", (AttrList)attrList, (Class)Integer.class, (String)"EthernetSwitchModulePort");
        int n4 = 0;
        if (n3 != null) {
            n4 = n3;
        }
        this.validateUntaggedIngressPriority(n4, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("untaggedIngressPriority", n4));
        Integer n5 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"administrativeState", (AttrList)attrList, (Class)Integer.class, (String)"EthernetSwitchModulePort");
        int n6 = 0;
        if (n5 != null) {
            n6 = n5;
        }
        this.validateAdministrativeState(n6, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("administrativeState", n6));
        Struct[] structArray = (Struct[])MoGenUtil.checkAndGetAttributeType((String)"pbitQueueMap", (AttrList)attrList, (Class)Struct;.class, (String)"EthernetSwitchModulePort");
        if (structArray == null) {
            structArray = PBIT_QUEUE_MAP_DEFAULT;
        }
        this.validatePbitQueueMap(structArray, (SetRequestContext)setRequestContextImpl);
        this.handleSetPbitQueueMap(structArray, (SetRequestContext)setRequestContextImpl);
        Struct struct = (Struct)MoGenUtil.checkAndGetAttributeType((String)"operatingMode", (AttrList)attrList, (Class)Struct.class, (String)"EthernetSwitchModulePort");
        if (struct == null) {
            struct = OPERATING_MODE_DEFAULT;
        }
        this.validateOperatingMode(struct, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)StructEthModOperatingModeImpl.toStructParameter(struct, "EthernetSwitchModulePort", "operatingMode"));
        Boolean bl = (Boolean)MoGenUtil.checkAndGetAttributeType((String)"externalPort", (AttrList)attrList, (Class)Boolean.class, (String)"EthernetSwitchModulePort");
        boolean bl2 = false;
        if (bl != null) {
            bl2 = bl;
        }
        this.validateExternalPort(bl2, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("externalPort", bl2));
        ManagedObject[] managedObjectArray = (ManagedObject[])MoGenUtil.checkAndGetAttributeType((String)"egressUntagVlanRef", (AttrList)attrList, (Class)ManagedObject;.class, (String)"EthernetSwitchModulePort");
        if (managedObjectArray == null) {
            managedObjectArray = EGRESS_UNTAG_VLAN_REF_DEFAULT;
        }
        this.validateEgressUntagVlanRef(managedObjectArray, (SetRequestContext)setRequestContextImpl);
        this.handleSetEgressUntagVlanRef(managedObjectArray, (SetRequestContext)setRequestContextImpl);
        ManagedObject[] managedObjectArray2 = (ManagedObject[])MoGenUtil.checkAndGetAttributeType((String)"vlanRef", (AttrList)attrList, (Class)ManagedObject;.class, (String)"EthernetSwitchModulePort");
        if (managedObjectArray2 == null) {
            managedObjectArray2 = VLAN_REF_DEFAULT;
        }
        this.validateVlanRef(managedObjectArray2, (SetRequestContext)setRequestContextImpl);
        this.handleSetVlanRef(managedObjectArray2, (SetRequestContext)setRequestContextImpl);
        ManagedObject managedObject2 = (ManagedObject)MoGenUtil.checkAndGetAttributeType((String)"untaggedIngressVlanRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"EthernetSwitchModulePort");
        if (managedObject2 == null) {
            managedObject2 = UNTAGGED_INGRESS_VLAN_REF_DEFAULT;
        }
        this.validateUntaggedIngressVlanRef(managedObject2, (SetRequestContext)setRequestContextImpl);
        int n7 = 0;
        if (managedObject2 != null && managedObject2 instanceof FroInfo) {
            n7 = ((FroInfo)managedObject2).getFroId(coordinator);
        }
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("untaggedIngressVlanRef", n7));
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"EthernetSwitchModulePort");
        if (string2 == null) {
            string2 = "";
        }
        this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
        Integer n8 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"trafficState", (AttrList)attrList, (Class)Integer.class, (String)"EthernetSwitchModulePort");
        int n9 = 1;
        if (n8 != null) {
            n9 = n8;
        }
        this.validateTrafficState(n9, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("trafficState", n9));
        ManagedObject managedObject3 = (ManagedObject)MoGenUtil.checkAndGetAttributeType((String)"lagRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"EthernetSwitchModulePort");
        if (managedObject3 == null) {
            managedObject3 = LAG_REF_DEFAULT;
        }
        this.validateLagRef(managedObject3, (SetRequestContext)setRequestContextImpl);
        this.handleSetLagRef(managedObject3, (SetRequestContext)setRequestContextImpl);
        Integer n10 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"remoteFaultIndication", (AttrList)attrList, (Class)Integer.class, (String)"EthernetSwitchModulePort");
        int n11 = 0;
        if (n10 != null) {
            n11 = n10;
        }
        this.validateRemoteFaultIndication(n11, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("remoteFaultIndication", n11));
        this.onCreate((SetRequestContext)setRequestContextImpl);
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        FroData froData = setRequestContextImpl.sendCreateRequest(this.froProxy);
        int n12 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n12));
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n12);
        switchPortStpMoFactory.autoCreateMo(this, "1", coordinator);
    }

    public EthernetSwitchModulePortMoGen(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("lagRef");
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(null));
    }

    protected abstract Object handleGetPbitQueueMap(GetRequestContext var1) throws MoAccessException;

    protected abstract void handleSetPbitQueueMap(Struct[] var1, SetRequestContext var2) throws MoAccessException;

    protected abstract Object handleGetCurrentPmRegister(GetRequestContext var1) throws MoAccessException;

    protected abstract void handleSetCurrentPmRegister(String[] var1, SetRequestContext var2) throws MoAccessException;

    protected abstract Object handleGetEgressUntagVlanRef(GetRequestContext var1) throws MoAccessException;

    protected abstract void handleSetEgressUntagVlanRef(ManagedObject[] var1, SetRequestContext var2) throws MoAccessException;

    protected abstract Object handleGetVlanRef(GetRequestContext var1) throws MoAccessException;

    protected abstract void handleSetVlanRef(ManagedObject[] var1, SetRequestContext var2) throws MoAccessException;

    protected abstract Object handleGetLagRef(GetRequestContext var1) throws MoAccessException;

    protected abstract void handleSetLagRef(ManagedObject var1, SetRequestContext var2) throws MoAccessException;

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onGetAttributes(GetRequestContext getRequestContext) throws MoAccessException {
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        return object;
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
    }

    protected void updateParamChangedInd(Map map, String string, SetRequestContext setRequestContext) throws MoAccessException {
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.onDelete(coordinator);
        ManagedObject[] managedObjectArray = null;
        ManagedObject managedObject = null;
        managedObjectArray = this.getEgressUntagVlanRef(coordinator);
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (managedObjectArray[n] == null || !(managedObjectArray[n] instanceof Reservable)) continue;
            ((Reservable)managedObjectArray[n]).release((ManagedObject)this, coordinator);
        }
        managedObjectArray = this.getVlanRef(coordinator);
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (managedObjectArray[n] == null || !(managedObjectArray[n] instanceof Reservable)) continue;
            ((Reservable)managedObjectArray[n]).release((ManagedObject)this, coordinator);
        }
        managedObject = this.getUntaggedIngressVlanRef(coordinator);
        if (managedObject != null && managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if ((managedObject = this.getLagRef(coordinator)) != null && managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (!(object instanceof SwitchPortStpMo)) continue;
            ((SwitchPortStpMoImpl)object).deleteMo(coordinator);
        }
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getPmIfOutMulticastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutMulticastPkts", coordinator);
    }

    public int getPmIfOutBroadcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutBroadcastPkts", coordinator);
    }

    public int getPmIfOutUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutUcastPkts", coordinator);
    }

    public int getPmIfInMulticastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInMulticastPkts", coordinator);
    }

    public int getPmIfInBroadcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInBroadcastPkts", coordinator);
    }

    public int getPmIfInUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInUcastPkts", coordinator);
    }

    public int getPmIfOutErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutErrors", coordinator);
    }

    public int getPmIfInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInErrors", coordinator);
    }

    public int getPmIfOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutDiscards", coordinator);
    }

    public int getPmIfInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInDiscards", coordinator);
    }

    public int getPmIfOutOctetsHi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutOctetsHi", coordinator);
    }

    public int getPmIfInOctetsHi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInOctetsHi", coordinator);
    }

    public int getPortNo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("portNo", coordinator);
    }

    public void setUntaggedIngressPriority(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("untaggedIngressPriority", new Integer(n), coordinator);
    }

    public int getUntaggedIngressPriority(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("untaggedIngressPriority", coordinator);
    }

    public int getActualSpeedDuplex(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("actualSpeedDuplex", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setPbitQueueMap(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("pbitQueueMap", structArray, coordinator);
    }

    public Struct[] getPbitQueueMap(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("pbitQueueMap", coordinator);
    }

    public void setOperatingMode(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("operatingMode", struct, coordinator);
    }

    public Struct getOperatingMode(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("operatingMode", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public int getPmIfInOctetsLo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInOctetsLo", coordinator);
    }

    public int getPmIfOutOctetsLo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutOctetsLo", coordinator);
    }

    public void setExternalPort(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("externalPort", bl, coordinator);
    }

    public boolean getExternalPort(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("externalPort", coordinator);
    }

    public void setEgressUntagVlanRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("egressUntagVlanRef", managedObjectArray, coordinator);
    }

    public ManagedObject[] getEgressUntagVlanRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("egressUntagVlanRef", coordinator);
    }

    public abstract ManagedObject[] fetchEgressUntagVlanRef(ArrayParameter var1, Coordinator var2) throws MoAccessException;

    public void setVlanRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vlanRef", managedObjectArray, coordinator);
    }

    public ManagedObject[] getVlanRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("vlanRef", coordinator);
    }

    public abstract ManagedObject[] fetchVlanRef(ArrayParameter var1, Coordinator var2) throws MoAccessException;

    public void setUntaggedIngressVlanRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("untaggedIngressVlanRef", managedObject, coordinator);
    }

    public ManagedObject getUntaggedIngressVlanRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("untaggedIngressVlanRef", coordinator);
    }

    public abstract ManagedObject fetchUntaggedIngressVlanRef(SignedIntParameter var1, Coordinator var2) throws MoAccessException;

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setTrafficState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("trafficState", new Integer(n), coordinator);
    }

    public int getTrafficState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("trafficState", coordinator);
    }

    public void setLagRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("lagRef", managedObject, coordinator);
    }

    public ManagedObject getLagRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("lagRef", coordinator);
    }

    public void setRemoteFaultIndication(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("remoteFaultIndication", new Integer(n), coordinator);
    }

    public int getRemoteFaultIndication(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("remoteFaultIndication", coordinator);
    }

    public String getType() {
        return "EthernetSwitchModulePort";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, this.getFroId(coordinator), this.ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("pmIfOutMulticastPkts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfOutMulticastPkts", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfOutBroadcastPkts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfOutBroadcastPkts", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfOutUcastPkts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfOutUcastPkts", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfInMulticastPkts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfInMulticastPkts", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfInBroadcastPkts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfInBroadcastPkts", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfInUcastPkts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfInUcastPkts", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfOutErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfOutErrors", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfInErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfInErrors", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfOutDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfOutDiscards", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfInDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfInDiscards", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfOutOctetsHi")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfOutOctetsHi", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfInOctetsHi")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfInOctetsHi", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("portNo")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("portNo");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: portNo", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("untaggedIngressPriority")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("untaggedIngressPriority");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: untaggedIngressPriority", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("actualSpeedDuplex")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("actualSpeedDuplex");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: actualSpeedDuplex", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("availabilityStatus");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: availabilityStatus", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("operationalState");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: operationalState", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("administrativeState");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: administrativeState", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
            } else if (stringArray[i].equalsIgnoreCase("pbitQueueMap")) {
                objectArray[i] = this.handleGetPbitQueueMap((GetRequestContext)getRequestContextImpl);
            } else if (stringArray[i].equalsIgnoreCase("operatingMode")) {
                signedIntParameter = (StructParameter)getRequestContextImpl.getParameter("operatingMode");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: operatingMode", "getAttributes", -1);
                }
                objectArray[i] = StructEthModOperatingModeImpl.toStruct((StructParameter)signedIntParameter);
            } else if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = this.handleGetCurrentPmRegister((GetRequestContext)getRequestContextImpl);
            } else if (stringArray[i].equalsIgnoreCase("pmIfInOctetsLo")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfInOctetsLo", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIfOutOctetsLo")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfOutOctetsLo", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("externalPort")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("externalPort");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: externalPort", "getAttributes", -1);
                }
                objectArray[i] = signedIntParameter.getBoolean();
            } else if (stringArray[i].equalsIgnoreCase("egressUntagVlanRef")) {
                objectArray[i] = this.handleGetEgressUntagVlanRef((GetRequestContext)getRequestContextImpl);
            } else if (stringArray[i].equalsIgnoreCase("vlanRef")) {
                objectArray[i] = this.handleGetVlanRef((GetRequestContext)getRequestContextImpl);
            } else if (stringArray[i].equalsIgnoreCase("untaggedIngressVlanRef")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("untaggedIngressVlanRef");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: untaggedIngressVlanRef", "getAttributes", -1);
                }
                objectArray[i] = this.fetchUntaggedIngressVlanRef(signedIntParameter, coordinator);
            } else if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("trafficState")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("trafficState");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: trafficState", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("lagRef")) {
                objectArray[i] = this.handleGetLagRef((GetRequestContext)getRequestContextImpl);
            } else if (stringArray[i].equalsIgnoreCase("remoteFaultIndication")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("remoteFaultIndication");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: remoteFaultIndication", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else {
                objectArray[i] = super.getAttribute(stringArray[i], coordinator);
            }
            objectArray[i] = this.onGetAttributes((GetRequestContext)getRequestContextImpl, stringArray[i], objectArray[i]);
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("EthernetSwitchModulePort");
        for (int i = 0; i < stringArray.length; ++i) {
            ManagedObject managedObject;
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("untaggedIngressPriority")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateUntaggedIngressPriority(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("untaggedIngressPriority", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("untaggedIngressPriority", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("administrativeState")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateAdministrativeState(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("administrativeState", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("administrativeState", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("pbitQueueMap")) {
                if (object instanceof Struct[]) {
                    Struct[] structArray = (Struct[])object;
                    this.validatePbitQueueMap(structArray, (SetRequestContext)setRequestContextImpl);
                    this.handleSetPbitQueueMap(structArray, (SetRequestContext)setRequestContextImpl);
                    continue;
                }
                throw new WrongAttributeTypeException("pbitQueueMap", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("operatingMode")) {
                if (object instanceof Struct) {
                    Struct struct = (Struct)object;
                    this.validateOperatingMode(struct, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)StructEthModOperatingModeImpl.toStructParameter(struct, "EthernetSwitchModulePort", "operatingMode"));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("operatingMode", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("externalPort")) {
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    this.validateExternalPort(bl, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("externalPort", bl));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("externalPort", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("egressUntagVlanRef")) {
                if (object instanceof ManagedObject[]) {
                    ManagedObject[] managedObjectArray = (ManagedObject[])object;
                    this.validateEgressUntagVlanRef(managedObjectArray, (SetRequestContext)setRequestContextImpl);
                    managedObject = this.getEgressUntagVlanRef(coordinator);
                    this.updateReservedMos((ManagedObject[])managedObject, managedObjectArray, coordinator, string);
                    this.handleSetEgressUntagVlanRef(managedObjectArray, (SetRequestContext)setRequestContextImpl);
                    continue;
                }
                throw new WrongAttributeTypeException("egressUntagVlanRef", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("vlanRef")) {
                if (object instanceof ManagedObject[]) {
                    ManagedObject[] managedObjectArray = (ManagedObject[])object;
                    this.validateVlanRef(managedObjectArray, (SetRequestContext)setRequestContextImpl);
                    managedObject = this.getVlanRef(coordinator);
                    this.updateReservedMos((ManagedObject[])managedObject, managedObjectArray, coordinator, string);
                    this.handleSetVlanRef(managedObjectArray, (SetRequestContext)setRequestContextImpl);
                    continue;
                }
                throw new WrongAttributeTypeException("vlanRef", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("untaggedIngressVlanRef")) {
                if (object == null || object instanceof ManagedObject) {
                    ManagedObject managedObject2 = (ManagedObject)object;
                    this.validateUntaggedIngressVlanRef(managedObject2, (SetRequestContext)setRequestContextImpl);
                    managedObject = this.getUntaggedIngressVlanRef(coordinator);
                    this.updateReservedMos(managedObject, managedObject2, coordinator, string);
                    int n = 0;
                    if (managedObject2 != null && managedObject2 instanceof FroInfo) {
                        n = ((FroInfo)managedObject2).getFroId(coordinator);
                    }
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("untaggedIngressVlanRef", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("untaggedIngressVlanRef", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("trafficState")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateTrafficState(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("trafficState", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("trafficState", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("lagRef")) {
                if (object == null || object instanceof ManagedObject) {
                    ManagedObject managedObject3 = (ManagedObject)object;
                    this.validateLagRef(managedObject3, (SetRequestContext)setRequestContextImpl);
                    managedObject = this.getLagRef(coordinator);
                    this.updateReservedMos(managedObject, managedObject3, coordinator, string);
                    this.handleSetLagRef(managedObject3, (SetRequestContext)setRequestContextImpl);
                    continue;
                }
                throw new WrongAttributeTypeException("lagRef", "EthernetSwitchModulePort");
            }
            if (string.equalsIgnoreCase("remoteFaultIndication")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateRemoteFaultIndication(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("remoteFaultIndication", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("remoteFaultIndication", "EthernetSwitchModulePort");
            }
            throw new NoSuchAttributeException(string, "EthernetSwitchModulePort");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void updateReservedMos(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator, String string) throws MoAccessException {
        if (managedObject != null && managedObject2 != null && managedObject.equals(managedObject2)) {
            return;
        }
        if (managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
    }

    protected void updateReservedMos(ManagedObject[] managedObjectArray, ManagedObject[] managedObjectArray2, Coordinator coordinator, String string) throws MoAccessException {
        int n;
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (!(managedObjectArray[n] instanceof Reservable)) continue;
            ((Reservable)managedObjectArray[n]).release((ManagedObject)this, coordinator);
        }
        for (n = 0; n < managedObjectArray2.length; ++n) {
            if (!(managedObjectArray2[n] instanceof Reservable)) continue;
            ((Reservable)managedObjectArray2[n]).reserve((ManagedObject)this, coordinator);
        }
    }

    public void actionSetPbitQueue(int n, int n2, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("setPbitQueue_pBit", n));
        arrayList.add(new SignedIntParameter("setPbitQueue_queue", n2));
        this.froProxy.actionWithoutCfm(coordinator, this.getFroId(coordinator), 102, arrayList);
    }

    public void actionSetAllVlanRefs(ManagedObject[] managedObjectArray, ManagedObject managedObject, ManagedObject[] managedObjectArray2, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayParameter arrayParameter = null;
        if (managedObjectArray != null) {
            arrayParameter = new ArrayParameter("vlanRef");
            SignedIntParameter signedIntParameter = null;
            int n = 0;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                n = ((FroInfo)managedObjectArray[i]).getFroId(coordinator);
                signedIntParameter = new SignedIntParameter("setAllVlanRefs_vlanRef_member", n);
                arrayParameter.add((Parameter)signedIntParameter);
            }
        }
        arrayList.add(arrayParameter);
        int n = 0;
        if (managedObject != null) {
            n = ((FroInfo)managedObject).getFroId(coordinator);
        }
        arrayList.add(new SignedIntParameter("setAllVlanRefs_untaggedIngressVlanRef", n));
        ArrayParameter arrayParameter2 = null;
        if (managedObjectArray2 != null) {
            arrayParameter2 = new ArrayParameter("egressUntagVlanRef");
            SignedIntParameter signedIntParameter = null;
            int n2 = 0;
            for (int i = 0; i < managedObjectArray2.length; ++i) {
                n2 = ((FroInfo)managedObjectArray2[i]).getFroId(coordinator);
                signedIntParameter = new SignedIntParameter("setAllVlanRefs_egressUntagVlanRef_member", n2);
                arrayParameter2.add((Parameter)signedIntParameter);
            }
        }
        arrayList.add(arrayParameter2);
        this.froProxy.actionWithoutCfm(coordinator, this.getFroId(coordinator), 103, arrayList);
    }

    public void actionDeblockBouncingPort(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList arrayList = new ArrayList();
        this.froProxy.actionWithoutCfm(coordinator, this.getFroId(coordinator), 101, arrayList);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Iterator iterator = map.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                SignedIntParameter signedIntParameter;
                string = (String)iterator.next();
                if (string.equals("portNo")) {
                    signedIntParameter = (SignedIntParameter)map.get("portNo");
                    setRequestContextImpl.addAvcNotification("portNo", (Object)new Integer(signedIntParameter.getValue()));
                } else if (string.equals("administrativeState")) {
                    signedIntParameter = (SignedIntParameter)map.get("administrativeState");
                    setRequestContextImpl.addAvcNotification("administrativeState", (Object)new Integer(signedIntParameter.getValue()));
                } else {
                    MessageLog.traceError(this.getClass(), (String)("Unknown attribute in parameterChanged(): " + string));
                }
                this.updateParamChangedInd(map, string, (SetRequestContext)setRequestContextImpl);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)("Attribute tag not found. " + moAccessException.toString()));
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void validatePortNo(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"portNo", (int)n, (int)1, (int)12, (String)"EthernetSwitchModulePort");
    }

    protected void validateUntaggedIngressPriority(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"untaggedIngressPriority", (int)n, (int)0, (int)7, (String)"EthernetSwitchModulePort");
    }

    protected void validateAdministrativeState(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkEnumAttribute((String)"administrativeState", (int)n, (int[])EnumAdmState.VALUES_ARRAY, (String)"EthernetSwitchModulePort");
    }

    protected void validatePbitQueueMap(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkUniquenessOfArray((String)"pbitQueueMap", (Object)structArray, (String)"EthernetSwitchModulePort");
    }

    protected void validateOperatingMode(Struct struct, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateExternalPort(boolean bl, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateEgressUntagVlanRef(ManagedObject[] managedObjectArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObjectArray != null && managedObjectArray.length > 0 && !MoGenUtil.isAcceptedArrayType((ManagedObject[])managedObjectArray, (String)"Vlan")) {
            throw new WrongAttributeTypeException("egressUntagVlanRef", "EthernetSwitchModulePort");
        }
        MoGenUtil.checkUniquenessOfArray((String)"egressUntagVlanRef", (Object)managedObjectArray, (String)"EthernetSwitchModulePort");
    }

    protected void validateVlanRef(ManagedObject[] managedObjectArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObjectArray != null && managedObjectArray.length > 0 && !MoGenUtil.isAcceptedArrayType((ManagedObject[])managedObjectArray, (String)"Vlan")) {
            throw new WrongAttributeTypeException("vlanRef", "EthernetSwitchModulePort");
        }
        MoGenUtil.checkUniquenessOfArray((String)"vlanRef", (Object)managedObjectArray, (String)"EthernetSwitchModulePort");
    }

    protected void validateUntaggedIngressVlanRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObject != null && !(managedObject instanceof Vlan)) {
            throw new WrongAttributeTypeException("untaggedIngressVlanRef", "EthernetSwitchModulePort");
        }
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"EthernetSwitchModulePort");
    }

    protected void validateTrafficState(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkEnumAttribute((String)"trafficState", (int)n, (int[])EnumTrafficState.VALUES_ARRAY, (String)"EthernetSwitchModulePort");
    }

    protected void validateLagRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObject != null && !(managedObject instanceof Lag)) {
            throw new WrongAttributeTypeException("lagRef", "EthernetSwitchModulePort");
        }
    }

    protected void validateRemoteFaultIndication(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkEnumAttribute((String)"remoteFaultIndication", (int)n, (int[])EnumRemoteFaultIndication.VALUES_ARRAY, (String)"EthernetSwitchModulePort");
    }
}

