/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.maofro.framework.MaoFroStructWrapper;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class PbitQueue {
    private int pbit = 0;
    private int queue = 0;
    private Struct moStruct = null;
    private StructParameter parameter = null;
    private static final String[] MEMBER_ORDER = new String[]{"pbit", "queue"};
    private static final int NUMBER_OF_MEMBERS = 2;
    private static final int QUEUE_0_DEFAULT = 0;
    private static final int QUEUE_1_DEFAULT = 1;
    private static final int QUEUE_2_DEFAULT = 2;
    private static final int QUEUE_3_DEFAULT = 3;
    private static final int PBIT_MIN = 0;
    private static final int PBIT_MAX = 7;
    private static final int QUEUE_MIN = 0;
    private static final int QUEUE_MAX = 3;

    public PbitQueue(int n) throws MoAccessException {
        this.pbit = n;
        this.queue = this.assignDefaultQueue(n);
        this.validateRanges();
        this.moStruct = this.makeStruct();
        MaoFroStructWrapper maoFroStructWrapper = new MaoFroStructWrapper(this.moStruct, "pbitQueuePair", MEMBER_ORDER);
        this.parameter = maoFroStructWrapper.toParameter();
    }

    public PbitQueue(int n, int n2) throws MoAccessException {
        this.pbit = n;
        this.queue = n2;
        this.validateRanges();
        this.moStruct = this.makeStruct();
        MaoFroStructWrapper maoFroStructWrapper = new MaoFroStructWrapper(this.moStruct, "pbitQueuePair", MEMBER_ORDER);
        this.parameter = maoFroStructWrapper.toParameter();
    }

    public PbitQueue(Struct struct) throws MoAccessException {
        if (struct.size() != 2) {
            throw new ValueOutOfRangeException("Missing member in PbitQueue", "EthernetSwitchPort");
        }
        if (!(struct.getValue("pbit") instanceof Integer)) {
            throw new WrongAttributeTypeException("pbit", "EthernetSwitchPort");
        }
        this.pbit = (Integer)struct.getValue("pbit");
        if (!(struct.getValue("queue") instanceof Integer)) {
            throw new WrongAttributeTypeException("queue", "EthernetSwitchPort");
        }
        this.queue = (Integer)struct.getValue("queue");
        this.moStruct = struct;
        this.validateRanges();
        MaoFroStructWrapper maoFroStructWrapper = new MaoFroStructWrapper(this.moStruct, "pbitQueuePair", MEMBER_ORDER);
        this.parameter = maoFroStructWrapper.toParameter();
    }

    public PbitQueue(StructParameter structParameter) throws MoAccessException {
        this.parameter = structParameter;
        MaoFroStructWrapper maoFroStructWrapper = new MaoFroStructWrapper(structParameter);
        this.moStruct = maoFroStructWrapper.toStruct();
    }

    private void validateRanges() throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"pbit", (int)this.pbit, (int)0, (int)7, (String)"EthernetSwitchPort");
        MoAttributeValidator.checkIntegerAttribute((String)"queue", (int)this.queue, (int)0, (int)3, (String)"EthernetSwitchPort");
    }

    public Struct toStruct() throws MoAccessException {
        return this.moStruct;
    }

    private Struct makeStruct() throws MoAccessException {
        String[] stringArray = new String[]{"pbit", "queue"};
        Object[] objectArray = new Object[]{new Integer(this.pbit), new Integer(this.queue)};
        return new StructImpl(stringArray, objectArray);
    }

    public StructParameter toParameter() throws MoAccessException {
        return this.parameter;
    }

    protected int getPbit() {
        return this.pbit;
    }

    protected int getQueue() {
        return this.queue;
    }

    private int assignDefaultQueue(int n) throws MoAccessException {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        if (n == 2) {
            return 1;
        }
        if (n == 3) {
            return 1;
        }
        if (n == 4) {
            return 2;
        }
        if (n == 5) {
            return 2;
        }
        if (n == 6) {
            return 3;
        }
        if (n == 7) {
            return 3;
        }
        return 0;
    }
}

