/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.extethswitch.PbitQueue;
import se.ericsson.cello.extethswitch.PbitQueue8;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class PbitQueueMap {
    private Map pbitQueueMap = null;
    private ArrayParameter parameter = null;
    private Struct[] moStructs = null;
    public static final int NUMBER_OF_ELEMENTS = 8;

    public PbitQueueMap() throws MoAccessException {
        this.pbitQueueMap = new HashMap(8);
        for (int i = 0; i < 8; ++i) {
            this.pbitQueueMap.put(new Integer(i), new PbitQueue(i));
        }
        this.parameter = this.createParameter();
        this.moStructs = this.createStructs();
    }

    public PbitQueueMap(String string, String string2) throws MoAccessException {
        this.pbitQueueMap = new HashMap(8);
        for (int i = 0; i < 8; ++i) {
            this.pbitQueueMap.put(new Integer(i), new PbitQueue8(i, string2));
        }
        this.parameter = this.createParameter(string);
        this.moStructs = this.createStructs(string);
    }

    public PbitQueueMap(String string) throws MoAccessException {
        this.pbitQueueMap = new HashMap(8);
        for (int i = 0; i < 8; ++i) {
            this.pbitQueueMap.put(new Integer(i), new PbitQueue8(i));
        }
        this.parameter = this.createParameter(string);
        this.moStructs = this.createStructs(string);
    }

    public PbitQueueMap(Struct[] structArray) throws MoAccessException {
        if (structArray.length != 8) {
            throw new ValueOutOfRangeException("Missing element in pbitQueueMap", "EthernetSwitchPort");
        }
        this.pbitQueueMap = new HashMap(8);
        for (int i = 0; i < 8; ++i) {
            if (!(structArray[i].getValue("pbit") instanceof Integer)) {
                throw new WrongAttributeTypeException("pbit", "EthernetSwitchPort");
            }
            if (!(structArray[i].getValue("queue") instanceof Integer)) {
                throw new WrongAttributeTypeException("queue", "EthernetSwitchPort");
            }
            this.pbitQueueMap.put(structArray[i].getValue("pbit"), new PbitQueue(structArray[i]));
        }
        this.checkRanges();
        this.parameter = this.createParameter();
    }

    public PbitQueueMap(Struct[] structArray, String string) throws MoAccessException {
        if (structArray.length != 8) {
            throw new ValueOutOfRangeException("Missing element in pbitQueueMap", "EthernetSwitchModulePort");
        }
        this.pbitQueueMap = new HashMap(8);
        for (int i = 0; i < 8; ++i) {
            if (!(structArray[i].getValue("pbit") instanceof Integer)) {
                throw new WrongAttributeTypeException("pbitQueueMapElement_pbit", "EthernetSwitchModulePort");
            }
            if (!(structArray[i].getValue("queue") instanceof Integer)) {
                throw new WrongAttributeTypeException("pbitQueueMapElement_queue", "EthernetSwitchModulePort");
            }
            this.pbitQueueMap.put(structArray[i].getValue("pbit"), new PbitQueue8(structArray[i]));
        }
        this.checkRanges();
        this.parameter = this.createParameter(string);
    }

    public PbitQueueMap(Struct[] structArray, String string, boolean bl) throws MoAccessException {
        if (structArray.length != 8) {
            throw new ValueOutOfRangeException("Missing element in pbitQueueMap", "EthernetBridgePort");
        }
        this.pbitQueueMap = new HashMap(8);
        for (int i = 0; i < 8; ++i) {
            if (!(structArray[i].getValue("pbit") instanceof Integer)) {
                throw new WrongAttributeTypeException("pbitQueueMapElement_pbit", "EthernetBridgePort");
            }
            if (!(structArray[i].getValue("queue") instanceof Integer)) {
                throw new WrongAttributeTypeException("pbitQueueMapElement_queue", "EthernetBridgePort");
            }
            this.pbitQueueMap.put(structArray[i].getValue("pbit"), new PbitQueue8(structArray[i], bl));
        }
        this.checkRanges();
        this.parameter = this.createParameter("pbitQueueMap");
    }

    public PbitQueueMap(ArrayParameter arrayParameter, String string, boolean bl) throws MoAccessException {
        if (arrayParameter.size() != 8) {
            throw new ValueOutOfRangeException("Missing element in pbitQueueMap", "EthernetBridgePort");
        }
        this.pbitQueueMap = new HashMap(8);
        String string2 = "pbitQueueMapElement_pbit";
        if (!bl) {
            string2 = "pbitQueueMapElement_pbit";
        }
        for (int i = 0; i < 8; ++i) {
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            int n = ((SignedIntParameter)structParameter.get(string2)).getValue();
            this.pbitQueueMap.put(new Integer(n), new PbitQueue8(structParameter));
        }
        this.moStructs = this.createStructs(string);
        this.parameter = arrayParameter;
    }

    protected void setPbitQueue(int n, int n2, String string, boolean bl) throws MoAccessException {
        PbitQueue8 pbitQueue8 = new PbitQueue8(n, n2, bl);
        Integer n3 = new Integer(n);
        this.pbitQueueMap.remove(n3);
        this.pbitQueueMap.put(n3, pbitQueue8);
        this.moStructs = this.createStructs(string);
        this.parameter = this.createParameter(string);
    }

    public PbitQueueMap(ArrayParameter arrayParameter) throws MoAccessException {
        if (arrayParameter.size() != 8) {
            throw new ValueOutOfRangeException("Missing element in pbitQueueMap", "EthernetSwitchPort");
        }
        this.pbitQueueMap = new HashMap(8);
        for (int i = 0; i < 8; ++i) {
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            int n = ((SignedIntParameter)structParameter.get("pbit")).getValue();
            this.pbitQueueMap.put(new Integer(n), new PbitQueue(structParameter));
        }
        this.moStructs = this.createStructs();
        this.parameter = arrayParameter;
    }

    public PbitQueueMap(ArrayParameter arrayParameter, String string) throws MoAccessException {
        if (arrayParameter.size() != 8) {
            throw new ValueOutOfRangeException("Missing element in pbitQueueMap", "EthernetSwitchPort");
        }
        this.pbitQueueMap = new HashMap(8);
        String string2 = "pbit";
        if (string.equals("EthernetSwitchModulePort")) {
            string2 = "pbitQueueMapElement_pbit";
        }
        for (int i = 0; i < 8; ++i) {
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            int n = ((SignedIntParameter)structParameter.get(string2)).getValue();
            this.pbitQueueMap.put(new Integer(n), new PbitQueue8(structParameter));
        }
        this.moStructs = this.createStructs(string);
        this.parameter = arrayParameter;
    }

    public Struct[] toStructs() throws MoAccessException {
        return this.moStructs;
    }

    private Struct[] createStructs() throws MoAccessException {
        StructImpl[] structImplArray = new StructImpl[8];
        for (int i = 0; i < 8; ++i) {
            structImplArray[i] = ((PbitQueue)this.pbitQueueMap.get(new Integer(i))).toStruct();
        }
        return structImplArray;
    }

    private Struct[] createStructs(String string) throws MoAccessException {
        StructImpl[] structImplArray = new StructImpl[8];
        for (int i = 0; i < 8; ++i) {
            structImplArray[i] = ((PbitQueue8)this.pbitQueueMap.get(new Integer(i))).toStruct();
        }
        return structImplArray;
    }

    private void checkRanges() throws MoAccessException {
        for (int i = 0; i < 8; ++i) {
            if (this.pbitQueueMap.containsKey(new Integer(i))) continue;
            throw new ValueOutOfRangeException("The pbit values must be unique in the attribute pbitQueueMap", "EthernetSwitchPort");
        }
    }

    public ArrayParameter toParameter() throws MoAccessException {
        return this.parameter;
    }

    private ArrayParameter createParameter() throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter("pbitQueueMap");
        for (int i = 0; i < 8; ++i) {
            arrayParameter.add((Parameter)((PbitQueue)this.pbitQueueMap.get(new Integer(i))).toParameter());
        }
        return arrayParameter;
    }

    private ArrayParameter createParameter(String string) throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter("pbitQueueMap");
        for (int i = 0; i < 8; ++i) {
            arrayParameter.add((Parameter)((PbitQueue8)this.pbitQueueMap.get(new Integer(i))).toParameter());
        }
        return arrayParameter;
    }

    protected void setPbitQueue(int n, int n2) throws MoAccessException {
        PbitQueue pbitQueue = new PbitQueue(n, n2);
        Integer n3 = new Integer(n);
        this.pbitQueueMap.remove(n3);
        this.pbitQueueMap.put(n3, pbitQueue);
        this.moStructs = this.createStructs();
        this.parameter = this.createParameter();
    }

    protected void setPbitQueue(int n, int n2, String string) throws MoAccessException {
        PbitQueue8 pbitQueue8 = new PbitQueue8(n, n2);
        Integer n3 = new Integer(n);
        this.pbitQueueMap.remove(n3);
        this.pbitQueueMap.put(n3, pbitQueue8);
        this.moStructs = this.createStructs(string);
        this.parameter = this.createParameter(string);
    }
}

