/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.extethswitch.EthernetBridgePortMo;
import se.ericsson.cello.extethswitch.EthernetBridgePortMoImpl;
import se.ericsson.cello.extethswitch.EthernetSwitchModulePortMo;
import se.ericsson.cello.extethswitch.EthernetSwitchModulePortMoImpl;
import se.ericsson.cello.extethswitch.EthernetSwitchPortMo;
import se.ericsson.cello.extethswitch.EthernetSwitchPortMoImpl;
import se.ericsson.cello.extethswitch.ExtethswitchUtil;
import se.ericsson.cello.extethswitch.LagMo;
import se.ericsson.cello.extethswitch.LagMoImpl;
import se.ericsson.cello.extethswitch.SwitchPortStpMoGen;
import se.ericsson.cello.extethswitch.exs_spstp_mi;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class SwitchPortStpMoImpl
extends SwitchPortStpMoGen
implements FroInfo {
    private static final TagNameDictionary DICTIONARY = TagNameDictionaries.get((ResourceBundle)new exs_spstp_mi());
    private static final int ACTIVE_L2GP_LINK_COUNT_MAX = 16;
    private static final String ACTIVE_L2GP_LINK_COUNT = "activeL2gpLinksCount";
    private static IntegerAttribute activeL2gpLinksCount = new IntegerAttribute("activeL2gpLinksCount", false, 0);
    private int configuredPathCostDefault;
    private boolean manualPathCostDefault;
    private static final int CONFIGURED_PATH_COST_CAX_DEFAULT = 200;
    private static final boolean MANUAL_PATH_COST_CAX_DEFAULT = true;

    public SwitchPortStpMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public SwitchPortStpMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        CelloMao celloMao = (CelloMao)this.getParent();
        Coordinator coordinator = setRequestContext.getCoordinator();
        this.updateCaxDefaultValues((ManagedObject)celloMao, coordinator);
        SignedIntParameter signedIntParameter = new SignedIntParameter("configuredPathCost", this.configuredPathCostDefault);
        setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter);
        SignedIntParameter signedIntParameter2 = new SignedIntParameter("manualPathCost", MaoFroTypeConverter.boolean2int((boolean)this.manualPathCostDefault));
        setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter2);
        int n = celloMao.getFroId(coordinator);
        SignedIntParameter signedIntParameter3 = new SignedIntParameter("exphFroId", n);
        setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter3);
        int n2 = PiuUtils.findPiuParentFroId((ManagedObject)celloMao);
        SignedIntParameter signedIntParameter4 = new SignedIntParameter("piuFroId", n2);
        setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter4);
        if (celloMao instanceof EthernetSwitchPortMo) {
            int n3 = ((EthernetSwitchPortMoImpl)celloMao).getFroType();
            SignedIntParameter signedIntParameter5 = new SignedIntParameter("parentFroType", n3);
            setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter5);
        } else if (celloMao instanceof EthernetSwitchModulePortMo) {
            int n4 = ((EthernetSwitchModulePortMoImpl)celloMao).getFroType();
            SignedIntParameter signedIntParameter6 = new SignedIntParameter("parentFroType", n4);
            setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter6);
        } else if (celloMao instanceof LagMo) {
            int n5 = ((LagMoImpl)celloMao).getFroType();
            SignedIntParameter signedIntParameter7 = new SignedIntParameter("parentFroType", n5);
            setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter7);
        } else if (celloMao instanceof EthernetBridgePortMo) {
            int n6 = ((EthernetBridgePortMoImpl)celloMao).getFroType();
            SignedIntParameter signedIntParameter8 = new SignedIntParameter("parentFroType", n6);
            setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter8);
        }
    }

    private void updateCaxDefaultValues(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        boolean bl = ExtethswitchUtil.isCaxSubrack(managedObject, coordinator);
        boolean bl2 = SwitchPortStpMoImpl.isAutoCreated(managedObject);
        if (bl && bl2) {
            this.configuredPathCostDefault = 200;
            this.manualPathCostDefault = true;
        } else {
            this.configuredPathCostDefault = 20000;
            this.manualPathCostDefault = false;
        }
    }

    private static boolean isAutoCreated(ManagedObject managedObject) {
        boolean bl = false;
        if (managedObject.getRelativeDistinguishedName().equals("EthernetBridgePort=BackPlaneLinkEBP1")) {
            bl = true;
        }
        return bl;
    }

    public void recoverTotalL2gpPortCount() throws MoAccessException {
        if (this.getL2gpActive(null)) {
            SwitchPortStpMoImpl.increaseActiveL2gpLinksCount(null);
        }
    }

    private static int getActiveL2gpLinksCount(Coordinator coordinator) throws MoAccessException {
        return activeL2gpLinksCount.getValue(coordinator);
    }

    private static void increaseActiveL2gpLinksCount(Coordinator coordinator) throws MoAccessException {
        activeL2gpLinksCount.setValue(SwitchPortStpMoImpl.getActiveL2gpLinksCount(coordinator) + 1);
    }

    private static void decreaseActiveL2gpLinksCount(Coordinator coordinator) throws MoAccessException {
        activeL2gpLinksCount.setValue(SwitchPortStpMoImpl.getActiveL2gpLinksCount(coordinator) - 1);
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        boolean bl;
        Coordinator coordinator = setRequestContext.getCoordinator();
        boolean bl2 = false;
        boolean bl3 = false;
        if (setRequestContext.isIncludedInRequest("l2gpActive")) {
            bl2 = true;
            bl3 = (Boolean)setRequestContext.getAttributeFromRequest("l2gpActive");
            bl = this.getL2gpActive(coordinator);
            boolean bl4 = bl3;
            if (!bl) {
                if (bl4) {
                    if (this.getParent() instanceof EthernetSwitchModulePortMo && !((EthernetSwitchModulePortMoImpl)this.getParent()).getExternalPort(coordinator)) {
                        throw new OperationNotAllowedException("SwitchPortStp", "L2GPActive can not be set to true when externalPort of parent EthernetSwitchModulePort is false");
                    }
                    if (SwitchPortStpMoImpl.getActiveL2gpLinksCount(coordinator) + 1 > 16) {
                        throw new MaxNumberExceededException("SwitchPortStp", "L2GPActive can not be set to true. There are already " + SwitchPortStpMoImpl.getActiveL2gpLinksCount(coordinator) + " L2GPActive ports on the node.");
                    }
                    SwitchPortStpMoImpl.increaseActiveL2gpLinksCount(coordinator);
                }
            } else if (bl && !bl4) {
                this.setL2gpBpduReceive(true, coordinator);
                SwitchPortStpMoImpl.decreaseActiveL2gpLinksCount(coordinator);
            }
        }
        if (setRequestContext.isIncludedInRequest("l2gpBpduReceive") && !(bl = ((Boolean)setRequestContext.getAttributeFromRequest("l2gpBpduReceive")).booleanValue())) {
            if (bl2) {
                if (!bl3) {
                    MessageLog.info(this.getClass(), (String)"SwitchPortStp l2gpBpduReceive is set to true since l2gpActive is set to false under the same set operation");
                    bl = true;
                    setRequestContext.replaceParameter(this.froProxy, (Parameter)new SignedIntParameter("l2gpBpduReceive", bl));
                    setRequestContext.addAvcNotification("l2gpBpduReceive", (Object)bl);
                }
            } else if (!this.getL2gpActive(coordinator)) {
                throw new OperationNotAllowedException("SwitchPortStp", "l2gpBpduReceive can not be set to false when l2gpActive is false");
            }
        }
    }

    public void actionUnblockEdgePort(Coordinator coordinator) throws MoAccessException {
        this.froProxy.actionWithoutCfm(null, this.getFroId(null), 101, null);
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        Map map = null;
        String string = "";
        try {
            StringParameter stringParameter;
            map = maoFroGenericEventInd.getParameters(DICTIONARY);
            if (map != null && (stringParameter = (StringParameter)map.get("additionalText")) != null) {
                string = stringParameter.getValue();
            }
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)("Unable to read parameters from event indication in " + this.getLocalDistinguishedName()), (Throwable)exception);
        }
        switch (maoFroGenericEventInd.getSpecificEvent()) {
            case 74: {
                AlarmManager.getReporter().reportEvent(74, (ManagedObject)this, "", string, null);
                break;
            }
            case 75: {
                AlarmManager.getReporter().reportEvent(75, (ManagedObject)this, "", string, null);
                break;
            }
            case 76: {
                AlarmManager.getReporter().reportEvent(76, (ManagedObject)this, "", string, null);
                break;
            }
            case 77: {
                AlarmManager.getReporter().reportEvent(77, (ManagedObject)this, "", string, null);
                break;
            }
            case 78: {
                AlarmManager.getReporter().reportEvent(78, (ManagedObject)this, "", string, null);
                break;
            }
            case 79: {
                AlarmManager.getReporter().reportEvent(79, (ManagedObject)this, "", string, null);
                break;
            }
            default: {
                MessageLog.info(this.getClass(), (String)("Unknown specificEvent: " + maoFroGenericEventInd.getSpecificEvent() + " sent in signal MaoFroGenericEventInd"));
            }
        }
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        if (this.getL2gpActive(coordinator)) {
            SwitchPortStpMoImpl.decreaseActiveL2gpLinksCount(coordinator);
        }
    }

    protected Object handleGetCurrentPmRegister(GetRequestContext getRequestContext) throws MoAccessException {
        return null;
    }

    protected void handleSetCurrentPmRegister(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
    }
}

