/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba;

import java.io.IOException;
import java.security.cert.X509Certificate;
import org.jacorb.orb.listener.SSLSessionEvent;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import se.ericsson.security.corba.SecurityLogger;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class NetworkListener
implements TCPConnectionListener,
SSLSessionListener {
    private static SecurityLogger logger = null;
    private static TraceErrorLogger traceLogger = new TraceErrorLogger();

    public boolean isListenerEnabled() {
        return true;
    }

    public static void setImplementation(SecurityLogger securityLogger) {
        logger = securityLogger;
    }

    public void connectionOpened(TCPConnectionEvent tCPConnectionEvent) {
        logger.logTCPConnectionOpened(tCPConnectionEvent.getRemoteIP(), tCPConnectionEvent.getRemotePort(), tCPConnectionEvent.getLocalPort());
    }

    public void connectionClosed(TCPConnectionEvent tCPConnectionEvent) {
        logger.logTCPConnectionClosed(tCPConnectionEvent.getRemoteIP(), tCPConnectionEvent.getRemotePort(), tCPConnectionEvent.getLocalPort());
    }

    public void sessionCreated(SSLSessionEvent sSLSessionEvent) {
        logger.logSSLSessionCreated(sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
    }

    public void handshakeException(SSLSessionEvent sSLSessionEvent) {
        String string = null;
        IOException iOException = sSLSessionEvent.getCause();
        if (iOException != null) {
            string = iOException.getMessage();
        }
        if (string == null) {
            logger.logSSLHandshakeException(sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
        } else {
            logger.logSSLHandshakeException2(string, sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
        }
    }

    public void keyException(SSLSessionEvent sSLSessionEvent) {
        String string = null;
        IOException iOException = sSLSessionEvent.getCause();
        if (iOException != null) {
            string = iOException.getMessage();
        }
        if (string == null) {
            logger.logSSLKeyException(sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
        } else {
            logger.logSSLKeyException2(string, sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
        }
    }

    public void peerUnverifiedException(SSLSessionEvent sSLSessionEvent) {
        String string = null;
        IOException iOException = sSLSessionEvent.getCause();
        if (iOException != null) {
            string = iOException.getMessage();
        }
        if (string == null) {
            logger.logSSLPeerUnverifiedException(sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
        } else {
            logger.logSSLPeerUnverifiedException2(string, sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
        }
    }

    public void protocolException(SSLSessionEvent sSLSessionEvent) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        IOException iOException = sSLSessionEvent.getCause();
        if (iOException != null) {
            string = iOException.getMessage();
        }
        if (string == null) {
            logger.logSSLProtocolException(sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
        } else {
            traceLogger.info(this.getClass(), "SSL protocol exception " + sSLSessionEvent.getRemoteIP() + ":" + sSLSessionEvent.getRemotePort() + "localhost: " + sSLSessionEvent.getLocalPort() + string);
            string3 = sSLSessionEvent.getRemoteIP();
            string4 = this.getSubject(sSLSessionEvent);
            n = string3.length();
            n2 = string4.length();
            n3 = n + n2 + 8;
            n4 = 48000 - n3;
            string2 = string.length() > n4 ? string.substring(0, n4) : string;
            logger.logSSLProtocolException2(string2, sSLSessionEvent.getRemoteIP(), sSLSessionEvent.getRemotePort(), sSLSessionEvent.getLocalPort(), this.getSubject(sSLSessionEvent));
        }
    }

    private String getSubject(SSLSessionEvent sSLSessionEvent) {
        String string = "UNKNOWN";
        if (sSLSessionEvent.getPeerCertificateChain() != null && sSLSessionEvent.getPeerCertificateChain().length > 0 && sSLSessionEvent.getPeerCertificateChain()[0] instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)sSLSessionEvent.getPeerCertificateChain()[0];
            string = x509Certificate.getSubjectDN().getName();
        }
        return string;
    }

    public void sslException(SSLSessionEvent sSLSessionEvent) {
        traceLogger.trace(1, this.getClass(), "sslException:" + sSLSessionEvent.toString());
        String string = sSLSessionEvent.getCause().getMessage();
        if (string.equals("untrusted client cert chain")) {
            this.peerUnverifiedException(sSLSessionEvent);
        }
        if (string.equals("null cert chain")) {
            this.peerUnverifiedException(sSLSessionEvent);
        } else {
            traceLogger.trace(1, this.getClass(), "Unhandled SSL exception \"" + string + "\", sending protocolException to logs.");
            this.protocolException(sSLSessionEvent);
        }
    }
}

