/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;
import se.ericsson.security.cppsec.prngc.PrngcApi;
import se.ericsson.security.cppsec.prngc.PrngcException;

public class PrngAdapter {
    private static TraceErrorLogger logger = new TraceErrorLogger();

    public byte[] getRandomBytes() throws IOException {
        try {
            PrngcApi prngcApi = new PrngcApi();
            byte[] byArray = prngcApi.getRandomBytes((byte)32);
            logger.trace(1, this.getClass(), "Got seed from PRNG.");
            return byArray;
        }
        catch (PrngcException prngcException) {
            logger.trace(1, this.getClass(), "Could not contact PRNGD, using fall back values.");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(System.currentTimeMillis());
            dataOutputStream.writeLong(Runtime.getRuntime().freeMemory());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }
}

