/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorMoImpl;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;

public class DataCollectorMoFactory
implements MoFactory {
    private CollectorContext context = null;

    public DataCollectorMoFactory(CollectorContext collectorContext) {
        this.context = collectorContext;
    }

    public ManagedObject createMo(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoNameAlreadyTakenException, TransactionRequiredException {
        return new DataCollectorMoImpl(MibMgr.instance().getMib().getRootMo(), string, coordinator);
    }

    public ManagedObject recoverMo(MoData moData) throws MoNameAlreadyTakenException {
        DataCollectorMoImpl dataCollectorMoImpl = null;
        try {
            dataCollectorMoImpl = new DataCollectorMoImpl(moData);
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            this.deleteMoData(moData);
        }
        return dataCollectorMoImpl;
    }

    private void deleteMoData(MoData moData) {
        try {
            TransactionWrapper transactionWrapper = this.context.getTransactionWrapperFactory().create();
            moData.delete(transactionWrapper.getCoordinator());
            transactionWrapper.commit();
            this.context.getLogger().info(this.getClass(), "Deleted " + this.duplicateEntry(moData));
        }
        catch (AueException aueException) {
            this.unableToDelete(moData, aueException);
            if (aueException.getRootCause() != null) {
                this.context.getLogger().error(this.getClass(), "Root cause : " + aueException.getRootCause().getMessage(), aueException.getRootCause());
            }
        }
        catch (TransactionRequiredException transactionRequiredException) {
            this.unableToDelete(moData, (Exception)((Object)transactionRequiredException));
        }
    }

    private void unableToDelete(MoData moData, Exception exception) {
        this.context.getLogger().error(this.getClass(), "Unable to delete " + this.duplicateEntry(moData), exception);
    }

    private String duplicateEntry(MoData moData) {
        return "duplicate modata entry with LDN " + moData.getLocalDistinguishedName();
    }
}

