/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.Vector;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.AueRuntimeException;
import se.ericsson.cello.aueframework.converter.UpgradeHandler;
import se.ericsson.cello.aueframework.converter.WriteableConverterContext;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.MoDataConverter;
import se.ericsson.cello.transaction.Coordinator;

public class DataConverter
implements MoDataConverter {
    private WriteableConverterContext context;
    private String name;
    private UpgradeHandler handler;
    private static final boolean CONVERSION_SUCCESSFUL = false;
    private static final String CONVERTER_NAME_SUFFIX = " MO data converter";

    public DataConverter(String string, UpgradeHandler upgradeHandler, WriteableConverterContext writeableConverterContext) {
        this.name = string;
        this.handler = upgradeHandler;
        this.context = writeableConverterContext;
    }

    public boolean convertMoData(Vector vector, Coordinator coordinator) throws MoDataConversionException {
        long l = System.currentTimeMillis();
        this.info("Starting MO data conversion.");
        this.context.getMoDataSource().init(vector);
        try {
            this.handler.upgrade(this.context);
        }
        catch (AueException aueException) {
            this.handleException(aueException, aueException.getRootCause());
        }
        catch (AueRuntimeException aueRuntimeException) {
            this.handleException(aueRuntimeException, aueRuntimeException.getRootCause());
        }
        long l2 = System.currentTimeMillis();
        this.info("Conversion completed in " + (l2 - l) + "ms.");
        return false;
    }

    private void deleteCollectedDataSource(Coordinator coordinator) throws AueException {
        if (this.context.getCollectedDataSource() == null) {
            this.trace("No collected data source found -- Ignored.");
        } else {
            this.trace("Deleting collected data.");
            this.context.getCollectedDataSource().delete(this.context, coordinator);
        }
    }

    private void handleException(Throwable throwable, Throwable throwable2) throws MoDataConversionException {
        this.context.getLogger().error(this.getClass(), " " + this.name + CONVERTER_NAME_SUFFIX + " : MO Data conversion failed.", throwable);
        if (throwable2 != null) {
            this.context.getLogger().error(this.getClass(), " " + this.name + CONVERTER_NAME_SUFFIX + " : Root cause :", throwable2);
        }
        throw new MoDataConversionException(this.name + CONVERTER_NAME_SUFFIX + " : " + throwable.getMessage() + (throwable2 == null ? "" : " : " + throwable2.getMessage()));
    }

    private void trace(String string) {
        this.context.getLogger().trace(1, this.getClass(), " " + this.name + CONVERTER_NAME_SUFFIX + " : " + string);
    }

    private void info(String string) {
        this.context.getLogger().info(this.getClass(), " " + this.name + CONVERTER_NAME_SUFFIX + " : " + string);
    }
}

