/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DerivedDataTypeRef;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.state.DefaultSettable;

public class MomSequenceImpl
extends MomBase
implements MomSequence,
MomEntityResolvable,
DefaultSettable {
    private static final String TRUE = "true";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String DATA_TYPE = "dataType: ";
    private static final String FALSE = "false";
    private static final String NON_UNIQUE = "nonUnique: ";
    private static final String MAX_LENGTH = "maxLength: ";
    private static final String MIN_LENGTH = "minLength: ";
    private static final String ARRAY_BRACKETS = "[]";
    private static final String NEW_LINE = "\n";
    private static final String DEFAULT_VALUES = "defaultValues: ";
    private static final String ORDERED = "ordered: ";
    private int length = -1;
    private int maxLength = -1;
    private int minLength = -1;
    private String maxLengthRawData;
    private String minLengthRawData;
    private boolean areElementsUnique = true;
    private boolean isOrdered;
    private MomEntity type;
    private ArrayList seqDefaultValue = new ArrayList();
    private String seqName;
    private static final String NULL = "null";
    private static final String EMPTY_STRING = "";

    public MomSequenceImpl(String string, Attributes attributes, MimModelImpl mimModelImpl, int n) {
        super(string, attributes, mimModelImpl, n);
    }

    public void setSeqName(String string) {
        this.seqName = string;
    }

    public int getLength() {
        return this.length;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public void setLength(String string) {
        this.length = this.convertToInt(string);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getMaxLengthRawData() {
        return this.maxLengthRawData;
    }

    public void setMaxLength(String string) {
        this.maxLengthRawData = string;
        this.maxLength = this.convertToInt(string);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public String getMinLengthRawData() {
        return this.minLengthRawData;
    }

    public void setMinLength(String string) {
        this.minLengthRawData = string;
        this.minLength = this.convertToInt(string);
    }

    public boolean areElementsUnique() {
        return this.areElementsUnique;
    }

    public void setAreElementsUnique(boolean bl) {
        this.areElementsUnique = bl;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void setIsOrdered() {
        this.isOrdered = true;
    }

    public MomEntity getType() {
        return this.type;
    }

    public void setType(MomEntity momEntity) {
        this.type = momEntity;
    }

    public void setResolvedEntity(MomEntity momEntity) {
        this.setType(momEntity);
    }

    private int convertToInt(String string) {
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            String string2 = "MomSequenceImpl.convertToInt()  Can not convert String to int for element:" + this.seqName + " String=" + string + "  Exception=" + exception.toString();
            this.getModel().addToWarningList(string2);
            return -1;
        }
    }

    public Iterator getDefaultValues() {
        return this.seqDefaultValue.iterator();
    }

    void addDefaultValue(Object object) {
        this.seqDefaultValue.add(object);
    }

    public void setDefault(String string) {
        this.addDefaultValue(string);
    }

    public String getExtendedDescription() {
        MomEntity momEntity;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getMaxLength() != -1) {
            stringBuffer.append(MAX_LENGTH + this.getMaxLength() + "\n");
        }
        if (this.getMinLength() != -1) {
            stringBuffer.append(MIN_LENGTH + this.getMinLength() + "\n");
        }
        if (this.areElementsUnique()) {
            stringBuffer.append("nonUnique: false\n");
        }
        if (this.isOrdered()) {
            stringBuffer.append("ordered: true\n");
        } else {
            stringBuffer.append("nonUnique: true\n");
        }
        String string = this.appendDefaultValues(this);
        if (!string.equalsIgnoreCase(NULL) && !string.equalsIgnoreCase(EMPTY_STRING)) {
            stringBuffer.append(DEFAULT_VALUES + string + "\n");
        }
        if ((momEntity = this.getType()) instanceof MomCorbaTypeAttribute) {
            MomCorbaTypeAttribute momCorbaTypeAttribute = (MomCorbaTypeAttribute)momEntity;
            stringBuffer.append(momCorbaTypeAttribute.getExtendedDescription());
        }
        return stringBuffer.toString();
    }

    public String getTypeInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        MomEntity momEntity = this.getType();
        if (momEntity instanceof MomCorbaTypeAttribute) {
            stringBuffer.append(momEntity.getXmlType() + ARRAY_BRACKETS);
        } else if (momEntity instanceof MoRef) {
            stringBuffer.append(momEntity.getXmlType() + SPACE + momEntity.getName() + "\n");
        } else if (momEntity instanceof MomEnumRef) {
            stringBuffer.append(momEntity.getXmlType() + SPACE + momEntity.getName() + "\n");
        } else if (momEntity instanceof MomStructRef) {
            stringBuffer.append(momEntity.getXmlType() + SPACE + momEntity.getName() + "\n");
        } else if (momEntity instanceof DerivedDataTypeRef) {
            DerivedDataTypeRef derivedDataTypeRef = (DerivedDataTypeRef)momEntity;
            stringBuffer.append(derivedDataTypeRef.getXmlType() + SPACE + momEntity.getName() + "\n");
        } else {
            stringBuffer.append(momEntity.getName());
        }
        return stringBuffer.toString();
    }
}

