/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.model.DirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MomAssociationEndImpl;
import se.ericsson.cello.mimparser.model.MomCardinalityImpl;
import se.ericsson.cello.mimparser.model.MomHasClassImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipEndInfoImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.state.ApplicationTagState;
import se.ericsson.cello.mimparser.state.DeletionPolicySettable;
import se.ericsson.cello.mimparser.state.DeletionPolicyState;
import se.ericsson.cello.mimparser.state.DescriptionSettable;
import se.ericsson.cello.mimparser.state.DescriptionState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.HasClassState;
import se.ericsson.cello.mimparser.state.MaxMinSettable;
import se.ericsson.cello.mimparser.state.MaxState;
import se.ericsson.cello.mimparser.state.MinState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ToState
extends MomBaseState
implements MaxMinSettable,
DescriptionSettable,
DeletionPolicySettable {
    private MomRelationshipImpl momRelationship;
    private MomAssociationEndImpl associationEnd = null;
    private static String[] allPossibleToElements = new String[]{"associationEnd", "supported"};

    public ToState(MomRelationshipImpl momRelationshipImpl, DirectionalAssociationImpl directionalAssociationImpl, StateMachine stateMachine, String string, Attributes attributes) {
        super(string);
        this.momRelationship = momRelationshipImpl;
        if (string.equals("associationEnd")) {
            this.momRelationship.setToName(attributes.getValue("name"));
            this.associationEnd = new MomAssociationEndImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            directionalAssociationImpl.addAssociationEndTo(this.associationEnd);
        }
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        stateMachine.getParseInfo().getMimModel();
        if (string.equals("description")) {
            stateMachine.pushState(new DescriptionState(this));
        } else if (string.equals("applicationTag")) {
            stateMachine.pushState(new ApplicationTagState(this));
        } else if (string.equals("hasClass")) {
            MomClass momClass = stateMachine.getParseInfo().getMimModel().getClass(attributes.getValue("name"));
            MomHasClassImpl momHasClassImpl = new MomHasClassImpl(attributes, momClass);
            this.associationEnd.setHasClass(momHasClassImpl);
            stateMachine.pushState(new HasClassState(momHasClassImpl));
            this.momRelationship.setToElementName(attributes.getValue("name"));
        } else if (string.equals("min")) {
            stateMachine.pushState(new MinState(this));
        } else if (string.equals("max")) {
            stateMachine.pushState(new MaxState(this));
        } else if (string.equals("deletionPolicy")) {
            stateMachine.pushState(new DeletionPolicyState(this));
        } else if (string.equals("domainExtension")) {
            DomainExtensionImpl domainExtensionImpl = new DomainExtensionImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.associationEnd.setDomain(domainExtensionImpl);
            stateMachine.pushState(new DomainExtensionState(domainExtensionImpl));
        }
    }

    public void setDescription(String string) {
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = this.getEndInfo();
        momRelationshipEndInfoImpl.setDescription(string);
    }

    public void setApplicationTag(String string) {
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = this.getEndInfo();
        momRelationshipEndInfoImpl.setApplicationTag(string);
    }

    public void addMinValue(String string) {
        MomCardinalityImpl momCardinalityImpl = this.getCardinality();
        momCardinalityImpl.setMin(string);
    }

    public void addMaxValue(String string) {
        MomCardinalityImpl momCardinalityImpl = this.getCardinality();
        momCardinalityImpl.setMax(string);
    }

    private MomRelationshipEndInfoImpl getEndInfo() {
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = (MomRelationshipEndInfoImpl)this.momRelationship.getToInfo();
        if (momRelationshipEndInfoImpl == null) {
            momRelationshipEndInfoImpl = new MomRelationshipEndInfoImpl();
            this.momRelationship.setToInfo(momRelationshipEndInfoImpl);
        }
        return momRelationshipEndInfoImpl;
    }

    private MomCardinalityImpl getCardinality() {
        MomCardinalityImpl momCardinalityImpl = (MomCardinalityImpl)this.momRelationship.getToCardinality();
        if (momCardinalityImpl == null) {
            momCardinalityImpl = new MomCardinalityImpl(null);
            this.momRelationship.setToCardinality(momCardinalityImpl);
        }
        return momCardinalityImpl;
    }

    public static boolean isToElement(String string) {
        boolean bl = false;
        for (int i = 0; i < allPossibleToElements.length; ++i) {
            if (!string.equals(allPossibleToElements[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void endElement(StateMachine stateMachine, String string) {
        if (string.equals(this.getReturnTag())) {
            if (this.momRelationship.getAssociationType().equals("biDirectionalAssociation")) {
                this.momRelationship.createNewRelationshipWithReversedDirection();
            }
            stateMachine.popState();
        }
    }

    public void setDeletionPolicy(String string) {
        this.associationEnd.setDeletionPolicy(string);
    }
}

