/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mibmgr;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import se.ericsson.cello.ncli.mibmgr.DumpFormatter;
import se.ericsson.cello.ncli.mibmgr.DumpFormatterFactory;
import se.ericsson.cello.ncli.mibmgr.MoAttribute;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.support.thread.CelloGZIPOutputStream;
import se.ericsson.cello.support.util.BlockingQueue;

public class DumpFileWriter {
    private static final String UTF8 = "UTF-8";
    private BlockingQueue queue;
    private Thread fileWorkerThread;
    public boolean stopWorking;
    private DumpFormatter formatter;
    private String fileName;
    private int enqueueCounter = 0;
    private boolean fileCompleted = false;

    public DumpFileWriter(int n) {
        this.queue = new BlockingQueue();
        this.formatter = DumpFormatterFactory.getFormatter(n);
    }

    protected DumpFileWriter() {
    }

    public boolean isFileCompleted() {
        return this.fileCompleted;
    }

    public void init() throws IOException {
        String string = new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime());
        String string2 = "MIBDUMP_" + string;
        this.fileName = this.getPath() + string2 + ".txt.gz";
        Log.info(this.getClass(), "Starting mib dump file for " + this.fileName);
        this.fileWorkerThread = new Thread(new FileWorker(this.getPrintWriter(this.fileName)));
        this.fileWorkerThread.setName(string2);
        this.fileWorkerThread.start();
    }

    protected String getPath() {
        String string = "/c/configuration/";
        if (System.getProperty("SIM") != null) {
            string = "/host/configuration/";
        }
        return System.getProperty("se.ericsson.cello.ncli.mibdump.dir", string);
    }

    public void writeMoData(Object object) {
        try {
            if (!this.queue.enqueue(object)) {
                Log.trace(this.getClass(), "Could not enqueue MoAttribute");
                this.stopWorking = true;
            } else {
                ++this.enqueueCounter;
            }
        }
        catch (BlockingQueue.ClosedException closedException) {
            this.stopWorking = true;
        }
    }

    private PrintWriter getPrintWriter(String string) throws IOException {
        BufferedWriter bufferedWriter = null;
        bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new CelloGZIPOutputStream((OutputStream)new FileOutputStream(string)), UTF8));
        return new PrintWriter(bufferedWriter);
    }

    public void stopWorking() {
        this.stopWorking = true;
        Log.trace(this.getClass(), "Stop working. queue size= " + this.queue.size() + " total enqueued = " + this.enqueueCounter);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void waitForCompletion(int n) throws InterruptedException {
        this.fileWorkerThread.join(n);
    }

    private class FileWorker
    implements Runnable {
        private PrintWriter writer;

        public FileWorker(PrintWriter printWriter) {
            DumpFileWriter.this.stopWorking = false;
            this.writer = printWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int n = 0;
            try {
                try {
                    Object[] objectArray;
                    this.writer.println(DumpFileWriter.this.formatter.getHeader());
                    while (!DumpFileWriter.this.stopWorking) {
                        try {
                            objectArray = DumpFileWriter.this.queue.dequeue();
                            Log.trace(this.getClass(), "dequing object # " + ++n);
                            if (objectArray instanceof MoAttribute) {
                                this.writer.println(DumpFileWriter.this.formatter.format((MoAttribute)objectArray));
                                continue;
                            }
                            if (!(objectArray instanceof Integer)) continue;
                            DumpFileWriter.this.stopWorking = true;
                        }
                        catch (BlockingQueue.ClosedException closedException) {
                            DumpFileWriter.this.stopWorking = true;
                        }
                        catch (Exception exception) {
                            Log.trace(this.getClass(), "Exception reading from queue " + exception.getMessage());
                            break;
                        }
                    }
                    if (!DumpFileWriter.this.queue.isEmpty()) {
                        Log.trace(this.getClass(), "Read remaining elements in queue ");
                        try {
                            objectArray = DumpFileWriter.this.queue.dequeueAll();
                            n += objectArray.length;
                            Log.trace(this.getClass(), "Remaining elements in queue = " + objectArray.length);
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (objectArray[i] instanceof Integer) {
                                    Log.trace(this.getClass(), "Queue end");
                                    break;
                                }
                                this.writer.println(DumpFileWriter.this.formatter.format((MoAttribute)objectArray[i]));
                            }
                        }
                        catch (BlockingQueue.ClosedException closedException) {
                            // empty catch block
                        }
                    }
                    DumpFileWriter.this.fileCompleted = true;
                }
                catch (Throwable throwable) {
                    Log.info(this.getClass(), "Error writing mib dump");
                    Object var5_9 = null;
                    this.writer.println(DumpFileWriter.this.formatter.getFooter());
                    Log.trace(this.getClass(), "Closing file. Total objects read from queue = " + n);
                    this.writer.flush();
                    this.writer.close();
                    if (DumpFileWriter.this.enqueueCounter != 1) return;
                    Log.info(this.getClass(), "No file will be generated. Nothing to write in the file.");
                    File file2 = new File(DumpFileWriter.this.fileName);
                    if (!file2.exists()) return;
                    file2.delete();
                    DumpFileWriter.this.fileCompleted = false;
                    DumpFileWriter.this.fileName = "";
                    return;
                }
                Object var5_8 = null;
                this.writer.println(DumpFileWriter.this.formatter.getFooter());
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.writer.println(DumpFileWriter.this.formatter.getFooter());
                Log.trace(this.getClass(), "Closing file. Total objects read from queue = " + n);
                this.writer.flush();
                this.writer.close();
                if (DumpFileWriter.this.enqueueCounter != 1) throw throwable;
                Log.info(this.getClass(), "No file will be generated. Nothing to write in the file.");
                File file = new File(DumpFileWriter.this.fileName);
                if (!file.exists()) throw throwable;
                file.delete();
                DumpFileWriter.this.fileCompleted = false;
                DumpFileWriter.this.fileName = "";
                throw throwable;
            }
            Log.trace(this.getClass(), "Closing file. Total objects read from queue = " + n);
            this.writer.flush();
            this.writer.close();
            if (DumpFileWriter.this.enqueueCounter != 1) return;
            Log.info(this.getClass(), "No file will be generated. Nothing to write in the file.");
            File file = new File(DumpFileWriter.this.fileName);
            if (!file.exists()) return;
            file.delete();
            DumpFileWriter.this.fileCompleted = false;
            DumpFileWriter.this.fileName = "";
        }
    }
}

