/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mibmgr;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.moframework.ManagedObject;

public class MoAttribute {
    private static final String EQUALS = "=";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private String moClass;
    private String ldn;
    private ManagedObject mo = null;
    private String[] attributeNames;
    private Object[] values;
    private static int moFormat = -1;

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] objectArray) {
        this.values = objectArray;
    }

    public MoAttribute(String string) throws IllegalArgumentException {
        this.parseLine(string);
    }

    public MoAttribute(ManagedObject managedObject, String[] stringArray) {
        this.mo = managedObject;
        this.attributeNames = stringArray;
    }

    private void parseLine(String string) throws IllegalArgumentException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, COLON);
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.indexOf(EQUALS) != -1) {
                moFormat = 1;
                this.ldn = string2;
                int n = string2.lastIndexOf(COMMA);
                object = string2.substring(n + 1, string2.length());
                this.moClass = ((String)object).substring(0, ((String)object).indexOf(EQUALS));
            } else {
                moFormat = 0;
                this.ldn = null;
                this.moClass = string2;
            }
        } else {
            throw new IllegalArgumentException("MO separator (:) not found in string ");
        }
        ArrayList<String> arrayList = null;
        if (stringTokenizer.hasMoreTokens()) {
            object = new StringTokenizer(stringTokenizer.nextToken(), COMMA);
            arrayList = new ArrayList<String>(((StringTokenizer)object).countTokens());
            while (((StringTokenizer)object).hasMoreElements()) {
                arrayList.add(((StringTokenizer)object).nextToken().trim());
            }
        } else {
            throw new IllegalArgumentException("Attributes missing");
        }
        this.attributeNames = arrayList.toArray(new String[arrayList.size()]);
    }

    public String getMoClass() {
        return this.moClass;
    }

    public void setMo(ManagedObject managedObject) {
        this.mo = managedObject;
    }

    public String getLdn() {
        if (this.mo == null) {
            return this.ldn;
        }
        return this.mo.getLocalDistinguishedName();
    }

    public String[] getAttributes() {
        return this.attributeNames;
    }

    public int getMoFormat() {
        return moFormat;
    }
}

