/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.Command;
import se.ericsson.cello.ncli.server.command.implementors.DeleteCommand;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroup;
import se.ericsson.cello.ncli.server.command.result.Printout;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.MoAddressResolver;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.cs.transaction.TransactionHandling;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;

public abstract class CSCommand
extends Command {
    protected static final String WORKING_MO_NO_LONGER_EXIST = "Working MO no longer exist. Changing to root MO";
    protected String myMoAddress;
    protected ArrayList myAttributeSeq;
    protected boolean myGlobalFlag;
    protected NodeServices nodeServices;
    protected MoAddressResolver myAddressResolver;
    protected String ldn;
    protected boolean noConfirmationFlag = false;
    protected TransactionHandling transactionHandler;

    public CSCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener);
        this.nodeServices = nodeServices;
        this.setAddressResolver(this.nodeServices.getAddressResolver());
        this.transactionHandler = this.nodeServices.getTransactionHandler();
    }

    protected String getMoAddress() {
        return this.myMoAddress;
    }

    public void setMoAddress(String string) {
        this.myMoAddress = string;
    }

    protected ArrayList getAttributeSeq() {
        return this.myAttributeSeq;
    }

    public void setAttributeSeq(ArrayList arrayList) {
        this.myAttributeSeq = arrayList;
    }

    protected boolean getGlobalFlag() {
        return this.myGlobalFlag;
    }

    public void setGlobalFlag(boolean bl) {
        this.myGlobalFlag = bl;
    }

    public void setNoConfirmationFlag(boolean bl) {
        this.noConfirmationFlag = bl;
    }

    protected NodeServices getCS() {
        return this.nodeServices;
    }

    protected MoAddressResolver getAddressResolver() {
        return this.myAddressResolver;
    }

    protected void setAddressResolver(MoAddressResolver moAddressResolver) {
        this.myAddressResolver = moAddressResolver;
    }

    protected String getLdn() throws NcliException {
        if (this.myGlobalFlag) {
            String[] stringArray = null;
            stringArray = this.myAddressResolver.getGlobalAddress(this.myMoAddress);
            if (stringArray == null || stringArray.length <= 0) {
                throw new NcliException("Could not resolve LDN from address: " + this.myMoAddress);
            }
            if (stringArray.length == 1) {
                this.ldn = stringArray[0];
                return this.ldn;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("   ");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("\n");
            }
            throw new NcliException("Could not find a unique MO. The following LDNs matched the addresss:\n" + stringBuffer.toString());
        }
        this.ldn = this.myAddressResolver.resolveAddress(this.myMoAddress);
        if (this.ldn == null) {
            throw new NcliException("Could not resolve LDN from address: null");
        }
        return this.ldn;
    }

    protected String[] getAttributeArray() {
        Object[] objectArray = this.getAttributeSeq().toArray();
        String[] stringArray = new String[this.getAttributeSeq().size()];
        for (int i = 0; i < this.getAttributeSeq().size(); ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    protected NameValue[] getNameValueArray() {
        if (this.getAttributeSeq() == null) {
            return null;
        }
        NameValue[] nameValueArray = new NameValue[this.getAttributeSeq().size()];
        for (int i = 0; i < this.getAttributeSeq().size(); ++i) {
            nameValueArray[i] = (NameValue)this.getAttributeSeq().get(i);
        }
        return nameValueArray;
    }

    protected boolean confirmCommand(String string) {
        Printout printout = PrintoutFactory.createPrintout();
        printout.addLDN(string);
        printout.addConfirmationText();
        return super.confirmCommand(printout);
    }

    protected boolean confirmGroup(MoGroup moGroup) throws NcliException {
        try {
            if (this.noConfirmationFlag) {
                return true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            List list = moGroup.getGroupMembers();
            Iterator iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                String string = (String)iterator.next();
                if (string != null) {
                    if (!bl) {
                        stringBuffer.append("   ");
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                    bl = false;
                }
                if (!this.resultListener.checkCancellation()) continue;
                Log.trace(DeleteCommand.class, "Command cancelled");
                return false;
            }
            return this.confirmCommand(stringBuffer.toString());
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    protected boolean confirmGroupRange(MoGroup moGroup, String string) throws NcliException {
        try {
            if (this.noConfirmationFlag) {
                return true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            int n = moGroup.getSize();
            int[] nArray = this.nodeServices.getAddressResolver().resolveIndexFromRange(string, n);
            for (int i = 0; i < nArray.length; ++i) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                String string2 = moGroup.getLdnAtIndex(nArray[i]);
                if (string2 != null) {
                    if (!bl) {
                        stringBuffer.append("   ");
                    }
                    stringBuffer.append(string2);
                    stringBuffer.append("\n");
                    bl = false;
                }
                if (!this.resultListener.checkCancellation()) continue;
                Log.trace(DeleteCommand.class, "Command cancelled");
                return false;
            }
            return this.confirmCommand(stringBuffer.toString());
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    protected void validateMo(Mo mo) throws NcliException {
        if (!mo.exists()) {
            if (mo.getLdn().equals(this.nodeServices.getWorkingMo().getLdn())) {
                this.nodeServices.setWorkingMo(this.nodeServices.getRootMo());
                throw new NcliException("WORKING_MO_NO_LONGER_EXIST");
            }
            throw new NcliException(mo.getLdn() + " does not exist");
        }
    }
}

