/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.implementors.GroupExecutor;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroup;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Transaction;

public class SetCommand
extends CSCommand
implements GroupExecutor {
    private String range;
    private boolean groupFlag;

    public SetCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void setGroupFlag(boolean bl) {
        this.groupFlag = bl;
    }

    public void setRange(String string) {
        this.range = string;
    }

    public void execute() {
        Log.trace(SetCommand.class, "SetCommand::execute()");
        try {
            this.printout = PrintoutFactory.createPrintout();
            Transaction transaction = this.transactionHandler.getTransaction();
            if (this.myAttributeSeq == null || this.myAttributeSeq.isEmpty()) {
                this.printout.addErrorText("Missing attributes");
                this.sendResponse();
                return;
            }
            if (this.range != null) {
                this.executeGroupRange(this.range, transaction);
            } else if (this.groupFlag) {
                this.executeEntireGroup(transaction);
            } else {
                this.getLdn();
                this.executeSingleMo(this.ldn, transaction);
                this.transactionHandler.softCommitTransaction();
                this.printout.addExecutedString();
                this.sendResponse();
            }
        }
        catch (Exception exception) {
            this.transactionHandler.softRollbackTransaction();
            this.printout.addErrorText(new NcliException(exception));
            this.sendResponse();
        }
    }

    public void executeSingleMo(String string, Transaction transaction) throws NcliException {
        try {
            Mo mo = null;
            mo = this.nodeServices.getCm().getMo(string);
            this.validateMo(mo);
            mo.setAttributes(this.getNameValueArray(), transaction);
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public void executeEntireGroup(Transaction transaction) throws NcliException {
        try {
            if (!this.confirmGroup(this.nodeServices.getMoGroupHandler().getDefaultGroup())) {
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.sendResponse();
                return;
            }
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            List list = moGroup.getGroupMembers();
            Iterator iterator = list.iterator();
            String string = null;
            while (iterator.hasNext()) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                string = (String)iterator.next();
                if (string != null) {
                    this.executeSingleMo(string, transaction);
                } else {
                    Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$SetCommand == null ? SetCommand.class$("se.ericsson.cello.ncli.server.command.implementors.SetCommand") : class$se$ericsson$cello$ncli$server$command$implementors$SetCommand, "Encountered null element in group, ignoring.");
                }
                if (!this.resultListener.checkCancellation()) continue;
                Log.trace(SetCommand.class, "Command cancelled");
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.resultListener.commandCancelled(this.printout);
                this.sendResponse();
                return;
            }
            this.transactionHandler.softCommitTransaction();
            this.printout.addExecutedString();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public void executeGroupRange(String string, Transaction transaction) throws NcliException {
        try {
            if (!this.confirmGroupRange(this.nodeServices.getMoGroupHandler().getDefaultGroup(), string)) {
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.sendResponse();
                return;
            }
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            int n = moGroup.getSize();
            int[] nArray = this.nodeServices.getAddressResolver().resolveIndexFromRange(string, n);
            String string2 = null;
            for (int i = 0; i < nArray.length; ++i) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                string2 = moGroup.getLdnAtIndex(nArray[i]);
                if (string2 == null) {
                    Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$SetCommand == null ? SetCommand.class$("se.ericsson.cello.ncli.server.command.implementors.SetCommand") : class$se$ericsson$cello$ncli$server$command$implementors$SetCommand, "Encountered null element in group, ignoring.");
                } else {
                    this.executeSingleMo(string2, transaction);
                }
                if (!this.resultListener.checkCancellation()) continue;
                Log.trace(SetCommand.class, "Command cancelled");
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.resultListener.commandCancelled(this.printout);
                this.sendResponse();
                return;
            }
            this.transactionHandler.softCommitTransaction();
            this.printout.addExecutedString();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }
}

