/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.mogroup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroup;
import se.ericsson.cello.ncli.server.logging.Log;

public class MoGroupImpl
implements MoGroup {
    private SortedMap sortedMap = null;
    private String name = null;
    private boolean isHomogenous = true;
    private String homogenousMoType = "";

    public MoGroupImpl(String string) {
        this.name = string;
        this.initCollections();
    }

    private void initCollections() {
        this.sortedMap = new TreeMap();
        this.sortedMap.put(new Integer(0), null);
    }

    public String getName() {
        return this.name;
    }

    public List getGroupMembers() {
        List list = this.addLdnToList();
        return list;
    }

    public boolean isHomogenous() {
        return this.isHomogenous;
    }

    public boolean containsLdn(String string) {
        boolean bl = false;
        Iterator iterator = this.sortedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!string.equals(entry.getValue())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void addGroupMembers(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = this.getMoType(string);
            if (this.sortedMap.size() <= 1) {
                this.homogenousMoType = string2;
            }
            int n = Integer.parseInt(this.sortedMap.lastKey().toString());
            this.sortedMap.put(new Integer(++n), string);
            if (!this.isHomogenous || this.homogenousMoType.equalsIgnoreCase(string2)) continue;
            this.isHomogenous = false;
        }
    }

    public void clearGroup() {
        this.sortedMap.clear();
        this.initCollections();
        this.isHomogenous = true;
        this.homogenousMoType = "";
    }

    public void removeGroupMember(String string) {
        try {
            if (string == null) {
                return;
            }
            Iterator iterator = this.sortedMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!string.equals(this.sortedMap.get(k))) continue;
                this.sortedMap.put(k, null);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("IndexOutOfBoundsException");
            return;
        }
    }

    public void removeGroupMembers(int[] nArray) {
        List list = this.addLdnToList();
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            String string = null;
            try {
                string = (String)list.get(nArray[i]);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return;
            }
            this.removeGroupMember(string);
        }
        if (list.size() <= 1) {
            this.clearGroup();
        }
    }

    private String getMoType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("=");
        int n2 = string.lastIndexOf(",");
        if (n < 0) {
            return null;
        }
        if (n2 < 0) {
            return string.substring(0, n);
        }
        return string.substring(n2, n);
    }

    public int getSize() {
        return this.sortedMap.size() - 1;
    }

    public String getLdnAtIndex(int n) {
        List list = this.addLdnToList();
        return (String)list.get(n);
    }

    public String getTopMostMemberLdn() {
        List list = this.addLdnToList();
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) continue;
                return string;
            }
            return null;
        }
        catch (Exception exception) {
            Log.trace(MoGroupImpl.class, ".getTopMostMemberLdn() Exception occured." + exception.toString());
            return null;
        }
    }

    public String getFirstValidMemberLdnInRange(int[] nArray) {
        List list = this.addLdnToList();
        try {
            if (nArray == null) {
                return null;
            }
            for (int i = 0; i < nArray.length; ++i) {
                String string = null;
                try {
                    string = (String)list.get(nArray[i]);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                if (string == null) continue;
                return string;
            }
            return null;
        }
        catch (Exception exception) {
            Log.trace(MoGroupImpl.class, ".getFirstValidMemberLdnInRange() Exception occured." + exception.toString());
            return null;
        }
    }

    public long getMemorySize() {
        List list = this.addLdnToList();
        int n = 0;
        for (int i = 1; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string == null) continue;
            n += string.length();
        }
        return n * 2;
    }

    public List addLdnToList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            int n = Integer.parseInt(k.toString());
            arrayList.add(n, this.sortedMap.get(k));
        }
        return arrayList;
    }
}

