/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.completers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.completion.CsCmdCompleter;
import se.ericsson.cello.ncli.server.completion.util.CompletionHelper;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;

public class CmdGroupCompleter
extends CsCmdCompleter {
    protected static final String ADDFLAG = "-a";
    protected static final String REMOVEFLAG = "-rm";
    protected static final String LISTFLAG = "-l";
    protected static final String CLEARFLAG = "-clear";
    String[] flags = new String[4];
    protected static final String EXPRESSIONFLAG = "-e";
    protected Completer searchCompleter = null;

    public CmdGroupCompleter(NodeServices nodeServices) {
        super(nodeServices);
        this.flags[0] = ADDFLAG;
        this.flags[1] = REMOVEFLAG;
        this.flags[2] = LISTFLAG;
        this.flags[3] = CLEARFLAG;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void completeString(String string) {
        Log.trace(CmdGroupCompleter.class, "completeString(" + string + ")");
        this.completedString = "";
        this.completionOptionList = new ArrayList(0);
        if (string.indexOf("group ") == -1) {
            Log.error(CmdGroupCompleter.class, "Error in completion");
            return;
        }
        String string2 = string.substring(0, 5);
        String string3 = string.substring(6);
        Log.trace(CmdGroupCompleter.class, "completeString::remainder = " + string3);
        if (string3.trim().equals("")) {
            this.completeFlag(string3, string2, string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
        int n = stringTokenizer.countTokens();
        Log.trace(CmdGroupCompleter.class, "completeString::nrOfTokens=" + n);
        if (n <= 0) {
            if (string3.endsWith(" ")) {
                this.completeFlag("", string2, string);
                return;
            }
            this.completedString = string;
            return;
        }
        if (n != 1) {
            this.completeMulti(string2, string3, string);
            return;
        }
        String string4 = stringTokenizer.nextToken();
        if (string3.endsWith(" ")) {
            this.completeSecondToken(string4, string2, string);
            return;
        }
        this.completeFlag(string4, string2, string);
    }

    protected void completeMulti(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        int n = stringTokenizer.countTokens();
        Log.trace(CmdGroupCompleter.class, "completeMulti::nr of tokens = " + n);
        String string4 = stringTokenizer.nextToken();
        if (string4.equals(ADDFLAG)) {
            this.completeAddStatement(string + " " + string4, stringTokenizer, string3);
        } else {
            this.completedString = string3;
            this.completionOptionList = new ArrayList();
        }
    }

    protected void completeAddStatement(String string, StringTokenizer stringTokenizer, String string2) {
        int n = stringTokenizer.countTokens();
        Log.trace(CmdGroupCompleter.class, "completeAddStatement::nrOfTokens = " + n);
        this.completedString = string2;
        this.completionOptionList = new ArrayList(0);
        String string3 = stringTokenizer.nextToken();
        Log.trace(CmdGroupCompleter.class, "firstToken = " + string3);
        String string4 = null;
        String string5 = null;
        if (string3.equals(EXPRESSIONFLAG)) {
            this.completeSearchExpression(stringTokenizer, string2);
        } else if (n == 1) {
            if (string2.endsWith(" ")) {
                this.moAddrCompleter = CompleterFactory.createMoAddrCompleter(this.nodeServices, this.globalAddr);
                this.moAddrCompleter.completeString("");
                this.completedString = this.completedString.concat(this.moAddrCompleter.getCompletedString());
                this.completionOptionList = this.moAddrCompleter.getCompletionOptionList();
            } else {
                this.completeMoAddress(string3, stringTokenizer, string2);
                if (string3.equals("-")) {
                    this.completionOptionList.add(EXPRESSIONFLAG);
                }
            }
        } else if (n == 2) {
            if (string3.equals("-g")) {
                this.completeMoAddress(string3, stringTokenizer, string2);
            } else {
                string5 = stringTokenizer.nextToken();
                this.completeMoAddress(string5, stringTokenizer, string2);
            }
        } else if (string3.equals("-g") && n == 2) {
            this.completeMoAddress(string3, stringTokenizer, string2);
        } else {
            for (int i = 1; i < n - 2; ++i) {
                stringTokenizer.nextToken();
            }
            string4 = stringTokenizer.nextToken();
            if (string4.equals("-g")) {
                this.completeMoAddress(string4, stringTokenizer, string2);
            } else {
                string5 = stringTokenizer.nextToken();
                this.completeMoAddress(string5, stringTokenizer, string2);
            }
        }
    }

    protected void completeSearchExpression(StringTokenizer stringTokenizer, String string) {
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            this.completedString = string.concat(" ( ");
        } else {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("(")) {
                if (n == 1 && !string.endsWith(" ")) {
                    this.completedString = string.concat(" ");
                    this.completionOptionList = new ArrayList(0);
                    return;
                }
                String string3 = "group -a -e ( ";
                int n2 = string3.length();
                String string4 = string.substring(n2);
                String string5 = "search ";
                this.searchCompleter = CompleterFactory.createCmdSearchCompleter(this.nodeServices);
                this.searchCompleter.completeString(string5.concat(string4));
                String string6 = this.searchCompleter.getCompletedString();
                this.completedString = string3.concat(string6.substring(string5.length()));
                this.completionOptionList = this.searchCompleter.getCompletionOptionList();
            } else {
                this.completedString = string;
                this.completionOptionList = new ArrayList(0);
            }
        }
    }

    protected void completeSecondToken(String string, String string2, String string3) {
        String string4 = string.toLowerCase();
        if (!string4.equals(ADDFLAG)) {
            if (string4.equals(LISTFLAG)) {
                this.completedString = string3;
                return;
            }
            if (string4.equals(CLEARFLAG)) {
                this.completedString = string3;
                return;
            }
            if (string4.equals(REMOVEFLAG)) {
                this.completedString = string3;
                return;
            }
            this.completedString = string3;
            return;
        }
        this.completedString = string3;
        this.completionOptionList = new ArrayList(0);
        this.completionOptionList.add(EXPRESSIONFLAG);
        this.moAddrCompleter = CompleterFactory.createMoAddrCompleter(this.nodeServices, this.globalAddr);
        this.moAddrCompleter.completeString("");
        this.completedString = this.completedString.concat(this.moAddrCompleter.getCompletedString());
        this.completionOptionList.addAll(this.moAddrCompleter.getCompletionOptionList());
    }

    protected void completeFlag(String string, String string2, String string3) {
        String string4 = "";
        this.completionOptionList = new ArrayList(0);
        if (string.equals("")) {
            for (int i = 0; i < this.flags.length; ++i) {
                this.completionOptionList.add(this.flags[i]);
            }
        } else {
            String string5 = string.toLowerCase();
            for (int i = 0; i < this.flags.length; ++i) {
                if (!this.flags[i].startsWith(string5)) continue;
                this.completionOptionList.add(this.flags[i]);
            }
        }
        if (this.completionOptionList.isEmpty()) {
            this.completedString = string3;
        } else if (this.completionOptionList.size() == 1) {
            this.completedString = string2 + " " + this.completionOptionList.get(0) + " ";
            this.completionOptionList = new ArrayList(0);
        } else {
            string4 = CompletionHelper.getCommonStartStr(this.completionOptionList, string);
            this.completedString = string2.concat(" ").concat(string4);
        }
    }
}

